/*
** ###################################################################
**     Version:             rev. 1.0, 2014-05-14
**     Build:               b150317
**
**     Abstract:
**         Chip specific module features.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2014-05-14)
**         Customer release.
**
** ###################################################################
*/

#if !defined(__FSL_XBAR_SIGNALS_H__)
#define __FSL_XBAR_SIGNALS_H__


typedef enum _xbar_input_signal {
#if defined(CPU_MKV40F128VLH15) || defined(CPU_MKV40F256VLH15) || defined(CPU_MKV40F64VLH15)
    kXbaraInputVSS = 0|0x100U, /*!< Logic zero output assigned to XBARA_IN0 input. */
    kXbaraInputVDD = 1|0x100U, /*!< Logic one output assigned to XBARA_IN1 input. */
    kXbaraInputXBARIN2 = 2|0x100U, /*!< XBARIN2 input pin output assigned to XBARA_IN2 input. */
    kXbaraInputXBARIN3 = 3|0x100U, /*!< XBARIN3 input pin output assigned to XBARA_IN3 input. */
    kXbaraInputXBARIN4 = 4|0x100U, /*!< XBARIN4 input pin output assigned to XBARA_IN4 input. */
    kXbaraInputXBARIN5 = 5|0x100U, /*!< XBARIN5 input pin output assigned to XBARA_IN5 input. */
    kXbaraInputXBARIN6 = 6|0x100U, /*!< XBARIN6 input pin output assigned to XBARA_IN6 input. */
    kXbaraInputXBARIN7 = 7|0x100U, /*!< XBARIN7 input pin output assigned to XBARA_IN7 input. */
    kXbaraInputXBARIN8 = 8|0x100U, /*!< XBARIN8 input pin output assigned to XBARA_IN8 input. */
    kXbaraInputXBARIN9 = 9|0x100U, /*!< XBARIN9 input pin output assigned to XBARA_IN9 input. */
    kXbaraInputXBARIN10 = 10|0x100U, /*!< XBARIN10 input pin output assigned to XBARA_IN10 input. */
    kXbaraInputXBARIN11 = 11|0x100U, /*!< XBARIN11 input pin output assigned to XBARA_IN11 input. */
    kXbaraInputCMP0_output = 12|0x100U, /*!< CMP0 Output output assigned to XBARA_IN12 input. */
    kXbaraInputCMP1_output = 13|0x100U, /*!< CMP1 Output output assigned to XBARA_IN13 input. */
    kXbaraInputCMP2_output = 14|0x100U, /*!< CMP2 Output output assigned to XBARA_IN14 input. */
    kXbaraInputCMP3_output = 15|0x100U, /*!< CMP3 Output output assigned to XBARA_IN15 input. */
    kXbaraInputFTM0_match = 16|0x100U, /*!< FTM0 all channels output compare ORed together output assigned to XBARA_IN16 input. */
    kXbaraInputFTM0_EXTRIG = 17|0x100U, /*!< FTM0 all channels counter init ORed together output assigned to XBARA_IN17 input. */
    kXbaraInputRESERVED18 = 18|0x100U, /*!< XBARA_IN18 input is reserved. */
    kXbaraInputRESERVED19 = 19|0x100U, /*!< XBARA_IN19 input is reserved. */
    kXbaraInputRESERVED20 = 20|0x100U, /*!< XBARA_IN20 input is reserved. */
    kXbaraInputRESERVED21 = 21|0x100U, /*!< XBARA_IN21 input is reserved. */
    kXbaraInputRESERVED22 = 22|0x100U, /*!< XBARA_IN22 input is reserved. */
    kXbaraInputRESERVED23 = 23|0x100U, /*!< XBARA_IN23 input is reserved. */
    kXbaraInputRESERVED24 = 24|0x100U, /*!< XBARA_IN24 input is reserved. */
    kXbaraInputRESERVED25 = 25|0x100U, /*!< XBARA_IN25 input is reserved. */
    kXbaraInputRESERVED26 = 26|0x100U, /*!< XBARA_IN26 input is reserved. */
    kXbaraInputRESERVED27 = 27|0x100U, /*!< XBARA_IN27 input is reserved. */
    kXbaraInputRESERVED28 = 28|0x100U, /*!< XBARA_IN28 input is reserved. */
    kXbaraInputPDB0_CH0_Output = 29|0x100U, /*!< PDB0 channel 0 output trigger output assigned to XBARA_IN29 input. */
    kXbaraInputRESERVED30 = 30|0x100U, /*!< XBARA_IN30 input is reserved. */
    kXbaraInputPDB1_CH0_Output = 31|0x100U, /*!< PDB1 channel 0 output trigger output assigned to XBARA_IN31 input. */
    kXbaraInputRESERVED32 = 32|0x100U, /*!< XBARA_IN32 input is reserved. */
    kXbaraInputADCA_ES = 33|0x100U, /*!< ADC converter A end of scan output assigned to XBARA_IN33 input. */
    kXbaraInputRESERVED34 = 34|0x100U, /*!< XBARA_IN34 input is reserved. */
    kXbaraInputADCB_ES = 35|0x100U, /*!< ADC converter B end of scan output assigned to XBARA_IN35 input. */
    kXbaraInputFTM1_match = 36|0x100U, /*!< FTM1 all channels output compare ORed together output assigned to XBARA_IN36 input. */
    kXbaraInputFTM1_EXTRIG = 37|0x100U, /*!< FTM1 all channels counter init ORed together output assigned to XBARA_IN37 input. */
    kXbaraInputDMA_CH0_done = 38|0x100U, /*!< DMA channel 0 done output assigned to XBARA_IN38 input. */
    kXbaraInputDMA_CH1_done = 39|0x100U, /*!< DMA channel 1 done output assigned to XBARA_IN39 input. */
    kXbaraInputDMA_CH6_done = 40|0x100U, /*!< DMA channel 6 done output assigned to XBARA_IN40 input. */
    kXbaraInputDMA_CH7_done = 41|0x100U, /*!< DMA channel 7 done output assigned to XBARA_IN41 input. */
    kXbaraInputPIT_trigger_0 = 42|0x100U, /*!< PIT trigger 0 output assigned to XBARA_IN42 input. */
    kXbaraInputPIT_trigger_1 = 43|0x100U, /*!< PIT trigger 1 output assigned to XBARA_IN43 input. */
    kXbaraInputRESERVED44 = 44|0x100U, /*!< XBARA_IN44 input is reserved. */
    kXbaraInputENC_CMP_pos_match = 45|0x100U, /*!< ENC compare trigger and position match output assigned to XBARA_IN45 input. */
    kXbaraInputAND_OR_INVERT_0 = 46|0x100U, /*!< AOI output 0 output assigned to XBARA_IN46 input. */
    kXbaraInputAND_OR_INVERT_1 = 47|0x100U, /*!< AOI output 1 output assigned to XBARA_IN47 input. */
    kXbaraInputAND_OR_INVERT_2 = 48|0x100U, /*!< AOI output 2 output assigned to XBARA_IN48 input. */
    kXbaraInputAND_OR_INVERT_3 = 49|0x100U, /*!< AOI output 3 output assigned to XBARA_IN49 input. */
    kXbaraInputPIT_trigger_2 = 50|0x100U, /*!< PIT trigger 2 output assigned to XBARA_IN50 input. */
    kXbaraInputPIT_trigger_3 = 51|0x100U, /*!< PIT trigger 3 output assigned to XBARA_IN51 input. */
    kXbarbInputCMP0_output = 0|0x200U, /*!< CMP0 Output output assigned to XBARB_IN0 input. */
    kXbarbInputCMP1_output = 1|0x200U, /*!< CMP1 Output output assigned to XBARB_IN1 input. */
    kXbarbInputCMP2_output = 2|0x200U, /*!< CMP2 Output output assigned to XBARB_IN2 input. */
    kXbarbInputCMP3_output = 3|0x200U, /*!< CMP3 Output output assigned to XBARB_IN3 input. */
    kXbarbInputFTM0_match = 4|0x200U, /*!< FTM0 all channels output compare ORed together output assigned to XBARB_IN4 input. */
    kXbarbInputFTM0_EXTRIG = 5|0x200U, /*!< FTM0 all channels counter init ORed together output assigned to XBARB_IN5 input. */
    kXbarbInputRESERVED6 = 6|0x200U, /*!< XBARB_IN6 input is reserved. */
    kXbarbInputRESERVED7 = 7|0x200U, /*!< XBARB_IN7 input is reserved. */
    kXbarbInputRESERVED8 = 8|0x200U, /*!< XBARB_IN8 input is reserved. */
    kXbarbInputRESERVED9 = 9|0x200U, /*!< XBARB_IN9 input is reserved. */
    kXbarbInputRESERVED10 = 10|0x200U, /*!< XBARB_IN10 input is reserved. */
    kXbarbInputRESERVED11 = 11|0x200U, /*!< XBARB_IN11 input is reserved. */
    kXbarbInputPDB0_CH0_Output = 12|0x200U, /*!< PDB0 channel 0 output trigger output assigned to XBARB_IN12 input. */
    kXbarbInputADCA_ES = 13|0x200U, /*!< ADC converter A end of scan output assigned to XBARB_IN13 input. */
    kXbarbInputXBARIN2 = 14|0x200U, /*!< XBARIN2 input pin output assigned to XBARB_IN14 input. */
    kXbarbInputXBARIN3 = 15|0x200U, /*!< XBARIN3 input pin output assigned to XBARB_IN15 input. */
    kXbarbInputFTM1_match = 16|0x200U, /*!< FTM1 all channels output compare ORed together output assigned to XBARB_IN16 input. */
    kXbarbInputFTM1_EXTRIG = 17|0x200U, /*!< FTM1 all channels counter init ORed together output assigned to XBARB_IN17 input. */
    kXbarbInputDMA_CH0_done = 18|0x200U, /*!< DMA channel 0 done output assigned to XBARB_IN18 input. */
    kXbarbInputDMA_CH1_done = 19|0x200U, /*!< DMA channel 1 done output assigned to XBARB_IN19 input. */
    kXbarbInputXBARIN10 = 20|0x200U, /*!< XBARIN10 input pin output assigned to XBARB_IN20 input. */
    kXbarbInputXBARIN11 = 21|0x200U, /*!< XBARIN11 input pin output assigned to XBARB_IN21 input. */
    kXbarbInputDMA_CH6_done = 22|0x200U, /*!< DMA channel 6 done output assigned to XBARB_IN22 input. */
    kXbarbInputDMA_CH7_done = 23|0x200U, /*!< DMA channel 7 done output assigned to XBARB_IN23 input. */
    kXbarbInputPIT_trigger_0 = 24|0x200U, /*!< PIT trigger 0 output assigned to XBARB_IN24 input. */
    kXbarbInputPIT_trigger_1 = 25|0x200U, /*!< PIT trigger 1 output assigned to XBARB_IN25 input. */
    kXbarbInputPDB1_CH0_Output = 26|0x200U, /*!< PDB1 channel 0 output trigger output assigned to XBARB_IN26 input. */
    kXbarbInputADCB_ES = 27|0x200U, /*!< ADC converter B end of scan output assigned to XBARB_IN27 input. */
#elif defined(CPU_MKV40F128VLL15) || defined(CPU_MKV40F256VLL15)
    kXbaraInputVSS = 0|0x100U, /*!< Logic zero output assigned to XBARA_IN0 input. */
    kXbaraInputVDD = 1|0x100U, /*!< Logic one output assigned to XBARA_IN1 input. */
    kXbaraInputXBARIN2 = 2|0x100U, /*!< XBARIN2 input pin output assigned to XBARA_IN2 input. */
    kXbaraInputXBARIN3 = 3|0x100U, /*!< XBARIN3 input pin output assigned to XBARA_IN3 input. */
    kXbaraInputXBARIN4 = 4|0x100U, /*!< XBARIN4 input pin output assigned to XBARA_IN4 input. */
    kXbaraInputXBARIN5 = 5|0x100U, /*!< XBARIN5 input pin output assigned to XBARA_IN5 input. */
    kXbaraInputXBARIN6 = 6|0x100U, /*!< XBARIN6 input pin output assigned to XBARA_IN6 input. */
    kXbaraInputXBARIN7 = 7|0x100U, /*!< XBARIN7 input pin output assigned to XBARA_IN7 input. */
    kXbaraInputXBARIN8 = 8|0x100U, /*!< XBARIN8 input pin output assigned to XBARA_IN8 input. */
    kXbaraInputXBARIN9 = 9|0x100U, /*!< XBARIN9 input pin output assigned to XBARA_IN9 input. */
    kXbaraInputXBARIN10 = 10|0x100U, /*!< XBARIN10 input pin output assigned to XBARA_IN10 input. */
    kXbaraInputXBARIN11 = 11|0x100U, /*!< XBARIN11 input pin output assigned to XBARA_IN11 input. */
    kXbaraInputCMP0_output = 12|0x100U, /*!< CMP0 Output output assigned to XBARA_IN12 input. */
    kXbaraInputCMP1_output = 13|0x100U, /*!< CMP1 Output output assigned to XBARA_IN13 input. */
    kXbaraInputCMP2_output = 14|0x100U, /*!< CMP2 Output output assigned to XBARA_IN14 input. */
    kXbaraInputCMP3_output = 15|0x100U, /*!< CMP3 Output output assigned to XBARA_IN15 input. */
    kXbaraInputFTM0_match = 16|0x100U, /*!< FTM0 all channels output compare ORed together output assigned to XBARA_IN16 input. */
    kXbaraInputFTM0_EXTRIG = 17|0x100U, /*!< FTM0 all channels counter init ORed together output assigned to XBARA_IN17 input. */
    kXbaraInputFTM3_match = 18|0x100U, /*!< FTM3 all channels output compare ORed together output assigned to XBARA_IN18 input. */
    kXbaraInputFTM3_EXTRIG = 19|0x100U, /*!< FTM3 all channels counter init ORed together output assigned to XBARA_IN19 input. */
    kXbaraInputRESERVED20 = 20|0x100U, /*!< XBARA_IN20 input is reserved. */
    kXbaraInputRESERVED21 = 21|0x100U, /*!< XBARA_IN21 input is reserved. */
    kXbaraInputRESERVED22 = 22|0x100U, /*!< XBARA_IN22 input is reserved. */
    kXbaraInputRESERVED23 = 23|0x100U, /*!< XBARA_IN23 input is reserved. */
    kXbaraInputRESERVED24 = 24|0x100U, /*!< XBARA_IN24 input is reserved. */
    kXbaraInputRESERVED25 = 25|0x100U, /*!< XBARA_IN25 input is reserved. */
    kXbaraInputRESERVED26 = 26|0x100U, /*!< XBARA_IN26 input is reserved. */
    kXbaraInputRESERVED27 = 27|0x100U, /*!< XBARA_IN27 input is reserved. */
    kXbaraInputRESERVED28 = 28|0x100U, /*!< XBARA_IN28 input is reserved. */
    kXbaraInputPDB0_CH0_Output = 29|0x100U, /*!< PDB0 channel 0 output trigger output assigned to XBARA_IN29 input. */
    kXbaraInputRESERVED30 = 30|0x100U, /*!< XBARA_IN30 input is reserved. */
    kXbaraInputPDB1_CH0_Output = 31|0x100U, /*!< PDB1 channel 0 output trigger output assigned to XBARA_IN31 input. */
    kXbaraInputRESERVED32 = 32|0x100U, /*!< XBARA_IN32 input is reserved. */
    kXbaraInputADCA_ES = 33|0x100U, /*!< ADC converter A end of scan output assigned to XBARA_IN33 input. */
    kXbaraInputRESERVED34 = 34|0x100U, /*!< XBARA_IN34 input is reserved. */
    kXbaraInputADCB_ES = 35|0x100U, /*!< ADC converter B end of scan output assigned to XBARA_IN35 input. */
    kXbaraInputFTM1_match = 36|0x100U, /*!< FTM1 all channels output compare ORed together output assigned to XBARA_IN36 input. */
    kXbaraInputFTM1_EXTRIG = 37|0x100U, /*!< FTM1 all channels counter init ORed together output assigned to XBARA_IN37 input. */
    kXbaraInputDMA_CH0_done = 38|0x100U, /*!< DMA channel 0 done output assigned to XBARA_IN38 input. */
    kXbaraInputDMA_CH1_done = 39|0x100U, /*!< DMA channel 1 done output assigned to XBARA_IN39 input. */
    kXbaraInputDMA_CH6_done = 40|0x100U, /*!< DMA channel 6 done output assigned to XBARA_IN40 input. */
    kXbaraInputDMA_CH7_done = 41|0x100U, /*!< DMA channel 7 done output assigned to XBARA_IN41 input. */
    kXbaraInputPIT_trigger_0 = 42|0x100U, /*!< PIT trigger 0 output assigned to XBARA_IN42 input. */
    kXbaraInputPIT_trigger_1 = 43|0x100U, /*!< PIT trigger 1 output assigned to XBARA_IN43 input. */
    kXbaraInputRESERVED44 = 44|0x100U, /*!< XBARA_IN44 input is reserved. */
    kXbaraInputENC_CMP_pos_match = 45|0x100U, /*!< ENC compare trigger and position match output assigned to XBARA_IN45 input. */
    kXbaraInputAND_OR_INVERT_0 = 46|0x100U, /*!< AOI output 0 output assigned to XBARA_IN46 input. */
    kXbaraInputAND_OR_INVERT_1 = 47|0x100U, /*!< AOI output 1 output assigned to XBARA_IN47 input. */
    kXbaraInputAND_OR_INVERT_2 = 48|0x100U, /*!< AOI output 2 output assigned to XBARA_IN48 input. */
    kXbaraInputAND_OR_INVERT_3 = 49|0x100U, /*!< AOI output 3 output assigned to XBARA_IN49 input. */
    kXbaraInputPIT_trigger_2 = 50|0x100U, /*!< PIT trigger 2 output assigned to XBARA_IN50 input. */
    kXbaraInputPIT_trigger_3 = 51|0x100U, /*!< PIT trigger 3 output assigned to XBARA_IN51 input. */
    kXbarbInputCMP0_output = 0|0x200U, /*!< CMP0 Output output assigned to XBARB_IN0 input. */
    kXbarbInputCMP1_output = 1|0x200U, /*!< CMP1 Output output assigned to XBARB_IN1 input. */
    kXbarbInputCMP2_output = 2|0x200U, /*!< CMP2 Output output assigned to XBARB_IN2 input. */
    kXbarbInputCMP3_output = 3|0x200U, /*!< CMP3 Output output assigned to XBARB_IN3 input. */
    kXbarbInputFTM0_match = 4|0x200U, /*!< FTM0 all channels output compare ORed together output assigned to XBARB_IN4 input. */
    kXbarbInputFTM0_EXTRIG = 5|0x200U, /*!< FTM0 all channels counter init ORed together output assigned to XBARB_IN5 input. */
    kXbarbInputFTM3_match = 6|0x200U, /*!< FTM3 all channels output compare ORed together output assigned to XBARB_IN6 input. */
    kXbarbInputFTM3_EXTRIG = 7|0x200U, /*!< FTM3 all channels counter init ORed together output assigned to XBARB_IN7 input. */
    kXbarbInputRESERVED8 = 8|0x200U, /*!< XBARB_IN8 input is reserved. */
    kXbarbInputRESERVED9 = 9|0x200U, /*!< XBARB_IN9 input is reserved. */
    kXbarbInputRESERVED10 = 10|0x200U, /*!< XBARB_IN10 input is reserved. */
    kXbarbInputRESERVED11 = 11|0x200U, /*!< XBARB_IN11 input is reserved. */
    kXbarbInputPDB0_CH0_Output = 12|0x200U, /*!< PDB0 channel 0 output trigger output assigned to XBARB_IN12 input. */
    kXbarbInputADCA_ES = 13|0x200U, /*!< ADC converter A end of scan output assigned to XBARB_IN13 input. */
    kXbarbInputXBARIN2 = 14|0x200U, /*!< XBARIN2 input pin output assigned to XBARB_IN14 input. */
    kXbarbInputXBARIN3 = 15|0x200U, /*!< XBARIN3 input pin output assigned to XBARB_IN15 input. */
    kXbarbInputFTM1_match = 16|0x200U, /*!< FTM1 all channels output compare ORed together output assigned to XBARB_IN16 input. */
    kXbarbInputFTM1_EXTRIG = 17|0x200U, /*!< FTM1 all channels counter init ORed together output assigned to XBARB_IN17 input. */
    kXbarbInputDMA_CH0_done = 18|0x200U, /*!< DMA channel 0 done output assigned to XBARB_IN18 input. */
    kXbarbInputDMA_CH1_done = 19|0x200U, /*!< DMA channel 1 done output assigned to XBARB_IN19 input. */
    kXbarbInputXBARIN10 = 20|0x200U, /*!< XBARIN10 input pin output assigned to XBARB_IN20 input. */
    kXbarbInputXBARIN11 = 21|0x200U, /*!< XBARIN11 input pin output assigned to XBARB_IN21 input. */
    kXbarbInputDMA_CH6_done = 22|0x200U, /*!< DMA channel 6 done output assigned to XBARB_IN22 input. */
    kXbarbInputDMA_CH7_done = 23|0x200U, /*!< DMA channel 7 done output assigned to XBARB_IN23 input. */
    kXbarbInputPIT_trigger_0 = 24|0x200U, /*!< PIT trigger 0 output assigned to XBARB_IN24 input. */
    kXbarbInputPIT_trigger_1 = 25|0x200U, /*!< PIT trigger 1 output assigned to XBARB_IN25 input. */
    kXbarbInputPDB1_CH0_Output = 26|0x200U, /*!< PDB1 channel 0 output trigger output assigned to XBARB_IN26 input. */
    kXbarbInputADCB_ES = 27|0x200U, /*!< ADC converter B end of scan output assigned to XBARB_IN27 input. */
#elif defined(CPU_MKV43F128VLH15) || defined(CPU_MKV43F128VLL15) || defined(CPU_MKV43F64VLH15) || defined(CPU_MKV44F128VLH15) || \
    defined(CPU_MKV44F128VLL15) || defined(CPU_MKV44F64VLH15)
    kXbaraInputVSS = 0|0x100U, /*!< Logic zero output assigned to XBARA_IN0 input. */
    kXbaraInputVDD = 1|0x100U, /*!< Logic one output assigned to XBARA_IN1 input. */
    kXbaraInputXBARIN2 = 2|0x100U, /*!< XBARIN2 input pin output assigned to XBARA_IN2 input. */
    kXbaraInputXBARIN3 = 3|0x100U, /*!< XBARIN3 input pin output assigned to XBARA_IN3 input. */
    kXbaraInputXBARIN4 = 4|0x100U, /*!< XBARIN4 input pin output assigned to XBARA_IN4 input. */
    kXbaraInputXBARIN5 = 5|0x100U, /*!< XBARIN5 input pin output assigned to XBARA_IN5 input. */
    kXbaraInputXBARIN6 = 6|0x100U, /*!< XBARIN6 input pin output assigned to XBARA_IN6 input. */
    kXbaraInputXBARIN7 = 7|0x100U, /*!< XBARIN7 input pin output assigned to XBARA_IN7 input. */
    kXbaraInputXBARIN8 = 8|0x100U, /*!< XBARIN8 input pin output assigned to XBARA_IN8 input. */
    kXbaraInputXBARIN9 = 9|0x100U, /*!< XBARIN9 input pin output assigned to XBARA_IN9 input. */
    kXbaraInputXBARIN10 = 10|0x100U, /*!< XBARIN10 input pin output assigned to XBARA_IN10 input. */
    kXbaraInputXBARIN11 = 11|0x100U, /*!< XBARIN11 input pin output assigned to XBARA_IN11 input. */
    kXbaraInputCMP0_output = 12|0x100U, /*!< CMP0 Output output assigned to XBARA_IN12 input. */
    kXbaraInputCMP1_output = 13|0x100U, /*!< CMP1 Output output assigned to XBARA_IN13 input. */
    kXbaraInputCMP2_output = 14|0x100U, /*!< CMP2 Output output assigned to XBARA_IN14 input. */
    kXbaraInputCMP3_output = 15|0x100U, /*!< CMP3 Output output assigned to XBARA_IN15 input. */
    kXbaraInputRESERVED16 = 16|0x100U, /*!< XBARA_IN16 input is reserved. */
    kXbaraInputRESERVED17 = 17|0x100U, /*!< XBARA_IN17 input is reserved. */
    kXbaraInputRESERVED18 = 18|0x100U, /*!< XBARA_IN18 input is reserved. */
    kXbaraInputRESERVED19 = 19|0x100U, /*!< XBARA_IN19 input is reserved. */
    kXbaraInputPWM0_TRG0 = 20|0x100U, /*!< PWMA channel 0 trigger 0 output assigned to XBARA_IN20 input. */
    kXbaraInputPWM0_TRG1 = 21|0x100U, /*!< PWMA channel 0 trigger 1 output assigned to XBARA_IN21 input. */
    kXbaraInputPWM1_TRG0 = 22|0x100U, /*!< PWMA channel 1 trigger 0 output assigned to XBARA_IN22 input. */
    kXbaraInputPWM1_TRG1 = 23|0x100U, /*!< PWMA channel 1 trigger 1 output assigned to XBARA_IN23 input. */
    kXbaraInputPWM2_TRG0 = 24|0x100U, /*!< PWMA channel 2 trigger 0 output assigned to XBARA_IN24 input. */
    kXbaraInputPWM2_TRG1 = 25|0x100U, /*!< PWMA channel 2 trigger 1 output assigned to XBARA_IN25 input. */
    kXbaraInputPWM3_TRG0 = 26|0x100U, /*!< PWMA channel 3 trigger 0 output assigned to XBARA_IN26 input. */
    kXbaraInputPWM3_TRG1 = 27|0x100U, /*!< PWMA channel 3 trigger 1 output assigned to XBARA_IN27 input. */
    kXbaraInputRESERVED28 = 28|0x100U, /*!< XBARA_IN28 input is reserved. */
    kXbaraInputPDB0_CH0_Output = 29|0x100U, /*!< PDB0 channel 0 output trigger output assigned to XBARA_IN29 input. */
    kXbaraInputRESERVED30 = 30|0x100U, /*!< XBARA_IN30 input is reserved. */
    kXbaraInputPDB1_CH0_Output = 31|0x100U, /*!< PDB1 channel 0 output trigger output assigned to XBARA_IN31 input. */
    kXbaraInputRESERVED32 = 32|0x100U, /*!< XBARA_IN32 input is reserved. */
    kXbaraInputADCA_ES = 33|0x100U, /*!< ADC converter A end of scan output assigned to XBARA_IN33 input. */
    kXbaraInputRESERVED34 = 34|0x100U, /*!< XBARA_IN34 input is reserved. */
    kXbaraInputADCB_ES = 35|0x100U, /*!< ADC converter B end of scan output assigned to XBARA_IN35 input. */
    kXbaraInputRESERVED36 = 36|0x100U, /*!< XBARA_IN36 input is reserved. */
    kXbaraInputRESERVED37 = 37|0x100U, /*!< XBARA_IN37 input is reserved. */
    kXbaraInputDMA_CH0_done = 38|0x100U, /*!< DMA channel 0 done output assigned to XBARA_IN38 input. */
    kXbaraInputDMA_CH1_done = 39|0x100U, /*!< DMA channel 1 done output assigned to XBARA_IN39 input. */
    kXbaraInputDMA_CH6_done = 40|0x100U, /*!< DMA channel 6 done output assigned to XBARA_IN40 input. */
    kXbaraInputDMA_CH7_done = 41|0x100U, /*!< DMA channel 7 done output assigned to XBARA_IN41 input. */
    kXbaraInputPIT_trigger_0 = 42|0x100U, /*!< PIT trigger 0 output assigned to XBARA_IN42 input. */
    kXbaraInputPIT_trigger_1 = 43|0x100U, /*!< PIT trigger 1 output assigned to XBARA_IN43 input. */
    kXbaraInputRESERVED44 = 44|0x100U, /*!< XBARA_IN44 input is reserved. */
    kXbaraInputENC_CMP_pos_match = 45|0x100U, /*!< ENC compare trigger and position match output assigned to XBARA_IN45 input. */
    kXbaraInputAND_OR_INVERT_0 = 46|0x100U, /*!< AOI output 0 output assigned to XBARA_IN46 input. */
    kXbaraInputAND_OR_INVERT_1 = 47|0x100U, /*!< AOI output 1 output assigned to XBARA_IN47 input. */
    kXbaraInputAND_OR_INVERT_2 = 48|0x100U, /*!< AOI output 2 output assigned to XBARA_IN48 input. */
    kXbaraInputAND_OR_INVERT_3 = 49|0x100U, /*!< AOI output 3 output assigned to XBARA_IN49 input. */
    kXbaraInputPIT_trigger_2 = 50|0x100U, /*!< PIT trigger 2 output assigned to XBARA_IN50 input. */
    kXbaraInputPIT_trigger_3 = 51|0x100U, /*!< PIT trigger 3 output assigned to XBARA_IN51 input. */
    kXbarbInputCMP0_output = 0|0x200U, /*!< CMP0 Output output assigned to XBARB_IN0 input. */
    kXbarbInputCMP1_output = 1|0x200U, /*!< CMP1 Output output assigned to XBARB_IN1 input. */
    kXbarbInputCMP2_output = 2|0x200U, /*!< CMP2 Output output assigned to XBARB_IN2 input. */
    kXbarbInputCMP3_output = 3|0x200U, /*!< CMP3 Output output assigned to XBARB_IN3 input. */
    kXbarbInputRESERVED4 = 4|0x200U, /*!< XBARB_IN4 input is reserved. */
    kXbarbInputRESERVED5 = 5|0x200U, /*!< XBARB_IN5 input is reserved. */
    kXbarbInputRESERVED6 = 6|0x200U, /*!< XBARB_IN6 input is reserved. */
    kXbarbInputRESERVED7 = 7|0x200U, /*!< XBARB_IN7 input is reserved. */
    kXbarbInputPWM0_TRG0_or_PWM0_TRG1 = 8|0x200U, /*!< PWMA channel 0 trigger 0 or  trigger 1 output assigned to XBARB_IN8 input. */
    kXbarbInputPWM1_TRG0_or_PWM1_TRG1 = 9|0x200U, /*!< PWMA channel 1 trigger 0 or  trigger 1 output assigned to XBARB_IN9 input. */
    kXbarbInputPWM2_TRG0_or_PWM2_TRG1 = 10|0x200U, /*!< PWMA channel 2 trigger 0 or  trigger 1 output assigned to XBARB_IN10 input. */
    kXbarbInputPWM3_TRG0_or_PWM3_TRG1 = 11|0x200U, /*!< PWMA channel 3 trigger 0 or  trigger 1 output assigned to XBARB_IN11 input. */
    kXbarbInputPDB0_CH0_Output = 12|0x200U, /*!< PDB0 channel 0 output trigger output assigned to XBARB_IN12 input. */
    kXbarbInputADCA_ES = 13|0x200U, /*!< ADC converter A end of scan output assigned to XBARB_IN13 input. */
    kXbarbInputXBARIN2 = 14|0x200U, /*!< XBARIN2 input pin output assigned to XBARB_IN14 input. */
    kXbarbInputXBARIN3 = 15|0x200U, /*!< XBARIN3 input pin output assigned to XBARB_IN15 input. */
    kXbarbInputRESERVED16 = 16|0x200U, /*!< XBARB_IN16 input is reserved. */
    kXbarbInputRESERVED17 = 17|0x200U, /*!< XBARB_IN17 input is reserved. */
    kXbarbInputDMA_CH0_done = 18|0x200U, /*!< DMA channel 0 done output assigned to XBARB_IN18 input. */
    kXbarbInputDMA_CH1_done = 19|0x200U, /*!< DMA channel 1 done output assigned to XBARB_IN19 input. */
    kXbarbInputXBARIN10 = 20|0x200U, /*!< XBARIN10 input pin output assigned to XBARB_IN20 input. */
    kXbarbInputXBARIN11 = 21|0x200U, /*!< XBARIN11 input pin output assigned to XBARB_IN21 input. */
    kXbarbInputDMA_CH6_done = 22|0x200U, /*!< DMA channel 6 done output assigned to XBARB_IN22 input. */
    kXbarbInputDMA_CH7_done = 23|0x200U, /*!< DMA channel 7 done output assigned to XBARB_IN23 input. */
    kXbarbInputPIT_trigger_0 = 24|0x200U, /*!< PIT trigger 0 output assigned to XBARB_IN24 input. */
    kXbarbInputPIT_trigger_1 = 25|0x200U, /*!< PIT trigger 1 output assigned to XBARB_IN25 input. */
    kXbarbInputPDB1_CH0_Output = 26|0x200U, /*!< PDB1 channel 0 output trigger output assigned to XBARB_IN26 input. */
    kXbarbInputADCB_ES = 27|0x200U, /*!< ADC converter B end of scan output assigned to XBARB_IN27 input. */
#elif defined(CPU_MKV45F128VLH15) || defined(CPU_MKV45F256VLH15) || defined(CPU_MKV46F128VLH15) || defined(CPU_MKV46F256VLH15)
    kXbaraInputVSS = 0|0x100U, /*!< Logic zero output assigned to XBARA_IN0 input. */
    kXbaraInputVDD = 1|0x100U, /*!< Logic one output assigned to XBARA_IN1 input. */
    kXbaraInputXBARIN2 = 2|0x100U, /*!< XBARIN2 input pin output assigned to XBARA_IN2 input. */
    kXbaraInputXBARIN3 = 3|0x100U, /*!< XBARIN3 input pin output assigned to XBARA_IN3 input. */
    kXbaraInputXBARIN4 = 4|0x100U, /*!< XBARIN4 input pin output assigned to XBARA_IN4 input. */
    kXbaraInputXBARIN5 = 5|0x100U, /*!< XBARIN5 input pin output assigned to XBARA_IN5 input. */
    kXbaraInputXBARIN6 = 6|0x100U, /*!< XBARIN6 input pin output assigned to XBARA_IN6 input. */
    kXbaraInputXBARIN7 = 7|0x100U, /*!< XBARIN7 input pin output assigned to XBARA_IN7 input. */
    kXbaraInputXBARIN8 = 8|0x100U, /*!< XBARIN8 input pin output assigned to XBARA_IN8 input. */
    kXbaraInputXBARIN9 = 9|0x100U, /*!< XBARIN9 input pin output assigned to XBARA_IN9 input. */
    kXbaraInputXBARIN10 = 10|0x100U, /*!< XBARIN10 input pin output assigned to XBARA_IN10 input. */
    kXbaraInputXBARIN11 = 11|0x100U, /*!< XBARIN11 input pin output assigned to XBARA_IN11 input. */
    kXbaraInputCMP0_output = 12|0x100U, /*!< CMP0 Output output assigned to XBARA_IN12 input. */
    kXbaraInputCMP1_output = 13|0x100U, /*!< CMP1 Output output assigned to XBARA_IN13 input. */
    kXbaraInputCMP2_output = 14|0x100U, /*!< CMP2 Output output assigned to XBARA_IN14 input. */
    kXbaraInputCMP3_output = 15|0x100U, /*!< CMP3 Output output assigned to XBARA_IN15 input. */
    kXbaraInputFTM0_match = 16|0x100U, /*!< FTM0 all channels output compare ORed together output assigned to XBARA_IN16 input. */
    kXbaraInputFTM0_EXTRIG = 17|0x100U, /*!< FTM0 all channels counter init ORed together output assigned to XBARA_IN17 input. */
    kXbaraInputRESERVED18 = 18|0x100U, /*!< XBARA_IN18 input is reserved. */
    kXbaraInputRESERVED19 = 19|0x100U, /*!< XBARA_IN19 input is reserved. */
    kXbaraInputPWM0_TRG0 = 20|0x100U, /*!< PWMA channel 0 trigger 0 output assigned to XBARA_IN20 input. */
    kXbaraInputPWM0_TRG1 = 21|0x100U, /*!< PWMA channel 0 trigger 1 output assigned to XBARA_IN21 input. */
    kXbaraInputPWM1_TRG0 = 22|0x100U, /*!< PWMA channel 1 trigger 0 output assigned to XBARA_IN22 input. */
    kXbaraInputPWM1_TRG1 = 23|0x100U, /*!< PWMA channel 1 trigger 1 output assigned to XBARA_IN23 input. */
    kXbaraInputPWM2_TRG0 = 24|0x100U, /*!< PWMA channel 2 trigger 0 output assigned to XBARA_IN24 input. */
    kXbaraInputPWM2_TRG1 = 25|0x100U, /*!< PWMA channel 2 trigger 1 output assigned to XBARA_IN25 input. */
    kXbaraInputPWM3_TRG0 = 26|0x100U, /*!< PWMA channel 3 trigger 0 output assigned to XBARA_IN26 input. */
    kXbaraInputPWM3_TRG1 = 27|0x100U, /*!< PWMA channel 3 trigger 1 output assigned to XBARA_IN27 input. */
    kXbaraInputRESERVED28 = 28|0x100U, /*!< XBARA_IN28 input is reserved. */
    kXbaraInputPDB0_CH0_Output = 29|0x100U, /*!< PDB0 channel 0 output trigger output assigned to XBARA_IN29 input. */
    kXbaraInputRESERVED30 = 30|0x100U, /*!< XBARA_IN30 input is reserved. */
    kXbaraInputPDB1_CH0_Output = 31|0x100U, /*!< PDB1 channel 0 output trigger output assigned to XBARA_IN31 input. */
    kXbaraInputRESERVED32 = 32|0x100U, /*!< XBARA_IN32 input is reserved. */
    kXbaraInputADCA_ES = 33|0x100U, /*!< ADC converter A end of scan output assigned to XBARA_IN33 input. */
    kXbaraInputRESERVED34 = 34|0x100U, /*!< XBARA_IN34 input is reserved. */
    kXbaraInputADCB_ES = 35|0x100U, /*!< ADC converter B end of scan output assigned to XBARA_IN35 input. */
    kXbaraInputFTM1_match = 36|0x100U, /*!< FTM1 all channels output compare ORed together output assigned to XBARA_IN36 input. */
    kXbaraInputFTM1_EXTRIG = 37|0x100U, /*!< FTM1 all channels counter init ORed together output assigned to XBARA_IN37 input. */
    kXbaraInputDMA_CH0_done = 38|0x100U, /*!< DMA channel 0 done output assigned to XBARA_IN38 input. */
    kXbaraInputDMA_CH1_done = 39|0x100U, /*!< DMA channel 1 done output assigned to XBARA_IN39 input. */
    kXbaraInputDMA_CH6_done = 40|0x100U, /*!< DMA channel 6 done output assigned to XBARA_IN40 input. */
    kXbaraInputDMA_CH7_done = 41|0x100U, /*!< DMA channel 7 done output assigned to XBARA_IN41 input. */
    kXbaraInputPIT_trigger_0 = 42|0x100U, /*!< PIT trigger 0 output assigned to XBARA_IN42 input. */
    kXbaraInputPIT_trigger_1 = 43|0x100U, /*!< PIT trigger 1 output assigned to XBARA_IN43 input. */
    kXbaraInputRESERVED44 = 44|0x100U, /*!< XBARA_IN44 input is reserved. */
    kXbaraInputENC_CMP_pos_match = 45|0x100U, /*!< ENC compare trigger and position match output assigned to XBARA_IN45 input. */
    kXbaraInputAND_OR_INVERT_0 = 46|0x100U, /*!< AOI output 0 output assigned to XBARA_IN46 input. */
    kXbaraInputAND_OR_INVERT_1 = 47|0x100U, /*!< AOI output 1 output assigned to XBARA_IN47 input. */
    kXbaraInputAND_OR_INVERT_2 = 48|0x100U, /*!< AOI output 2 output assigned to XBARA_IN48 input. */
    kXbaraInputAND_OR_INVERT_3 = 49|0x100U, /*!< AOI output 3 output assigned to XBARA_IN49 input. */
    kXbaraInputPIT_trigger_2 = 50|0x100U, /*!< PIT trigger 2 output assigned to XBARA_IN50 input. */
    kXbaraInputPIT_trigger_3 = 51|0x100U, /*!< PIT trigger 3 output assigned to XBARA_IN51 input. */
    kXbarbInputCMP0_output = 0|0x200U, /*!< CMP0 Output output assigned to XBARB_IN0 input. */
    kXbarbInputCMP1_output = 1|0x200U, /*!< CMP1 Output output assigned to XBARB_IN1 input. */
    kXbarbInputCMP2_output = 2|0x200U, /*!< CMP2 Output output assigned to XBARB_IN2 input. */
    kXbarbInputCMP3_output = 3|0x200U, /*!< CMP3 Output output assigned to XBARB_IN3 input. */
    kXbarbInputFTM0_match = 4|0x200U, /*!< FTM0 all channels output compare ORed together output assigned to XBARB_IN4 input. */
    kXbarbInputFTM0_EXTRIG = 5|0x200U, /*!< FTM0 all channels counter init ORed together output assigned to XBARB_IN5 input. */
    kXbarbInputRESERVED6 = 6|0x200U, /*!< XBARB_IN6 input is reserved. */
    kXbarbInputRESERVED7 = 7|0x200U, /*!< XBARB_IN7 input is reserved. */
    kXbarbInputPWM0_TRG0_or_PWM0_TRG1 = 8|0x200U, /*!< PWMA channel 0 trigger 0 or  trigger 1 output assigned to XBARB_IN8 input. */
    kXbarbInputPWM1_TRG0_or_PWM1_TRG1 = 9|0x200U, /*!< PWMA channel 1 trigger 0 or  trigger 1 output assigned to XBARB_IN9 input. */
    kXbarbInputPWM2_TRG0_or_PWM2_TRG1 = 10|0x200U, /*!< PWMA channel 2 trigger 0 or  trigger 1 output assigned to XBARB_IN10 input. */
    kXbarbInputPWM3_TRG0_or_PWM3_TRG1 = 11|0x200U, /*!< PWMA channel 3 trigger 0 or  trigger 1 output assigned to XBARB_IN11 input. */
    kXbarbInputPDB0_CH0_Output = 12|0x200U, /*!< PDB0 channel 0 output trigger output assigned to XBARB_IN12 input. */
    kXbarbInputADCA_ES = 13|0x200U, /*!< ADC converter A end of scan output assigned to XBARB_IN13 input. */
    kXbarbInputXBARIN2 = 14|0x200U, /*!< XBARIN2 input pin output assigned to XBARB_IN14 input. */
    kXbarbInputXBARIN3 = 15|0x200U, /*!< XBARIN3 input pin output assigned to XBARB_IN15 input. */
    kXbarbInputFTM1_match = 16|0x200U, /*!< FTM1 all channels output compare ORed together output assigned to XBARB_IN16 input. */
    kXbarbInputFTM1_EXTRIG = 17|0x200U, /*!< FTM1 all channels counter init ORed together output assigned to XBARB_IN17 input. */
    kXbarbInputDMA_CH0_done = 18|0x200U, /*!< DMA channel 0 done output assigned to XBARB_IN18 input. */
    kXbarbInputDMA_CH1_done = 19|0x200U, /*!< DMA channel 1 done output assigned to XBARB_IN19 input. */
    kXbarbInputXBARIN10 = 20|0x200U, /*!< XBARIN10 input pin output assigned to XBARB_IN20 input. */
    kXbarbInputXBARIN11 = 21|0x200U, /*!< XBARIN11 input pin output assigned to XBARB_IN21 input. */
    kXbarbInputDMA_CH6_done = 22|0x200U, /*!< DMA channel 6 done output assigned to XBARB_IN22 input. */
    kXbarbInputDMA_CH7_done = 23|0x200U, /*!< DMA channel 7 done output assigned to XBARB_IN23 input. */
    kXbarbInputPIT_trigger_0 = 24|0x200U, /*!< PIT trigger 0 output assigned to XBARB_IN24 input. */
    kXbarbInputPIT_trigger_1 = 25|0x200U, /*!< PIT trigger 1 output assigned to XBARB_IN25 input. */
    kXbarbInputPDB1_CH0_Output = 26|0x200U, /*!< PDB1 channel 0 output trigger output assigned to XBARB_IN26 input. */
    kXbarbInputADCB_ES = 27|0x200U, /*!< ADC converter B end of scan output assigned to XBARB_IN27 input. */
#elif defined(CPU_MKV45F128VLL15) || defined(CPU_MKV45F256VLL15) || defined(CPU_MKV46F128VLL15) || defined(CPU_MKV46F256VLL15)
    kXbaraInputVSS = 0|0x100U, /*!< Logic zero output assigned to XBARA_IN0 input. */
    kXbaraInputVDD = 1|0x100U, /*!< Logic one output assigned to XBARA_IN1 input. */
    kXbaraInputXBARIN2 = 2|0x100U, /*!< XBARIN2 input pin output assigned to XBARA_IN2 input. */
    kXbaraInputXBARIN3 = 3|0x100U, /*!< XBARIN3 input pin output assigned to XBARA_IN3 input. */
    kXbaraInputXBARIN4 = 4|0x100U, /*!< XBARIN4 input pin output assigned to XBARA_IN4 input. */
    kXbaraInputXBARIN5 = 5|0x100U, /*!< XBARIN5 input pin output assigned to XBARA_IN5 input. */
    kXbaraInputXBARIN6 = 6|0x100U, /*!< XBARIN6 input pin output assigned to XBARA_IN6 input. */
    kXbaraInputXBARIN7 = 7|0x100U, /*!< XBARIN7 input pin output assigned to XBARA_IN7 input. */
    kXbaraInputXBARIN8 = 8|0x100U, /*!< XBARIN8 input pin output assigned to XBARA_IN8 input. */
    kXbaraInputXBARIN9 = 9|0x100U, /*!< XBARIN9 input pin output assigned to XBARA_IN9 input. */
    kXbaraInputXBARIN10 = 10|0x100U, /*!< XBARIN10 input pin output assigned to XBARA_IN10 input. */
    kXbaraInputXBARIN11 = 11|0x100U, /*!< XBARIN11 input pin output assigned to XBARA_IN11 input. */
    kXbaraInputCMP0_output = 12|0x100U, /*!< CMP0 Output output assigned to XBARA_IN12 input. */
    kXbaraInputCMP1_output = 13|0x100U, /*!< CMP1 Output output assigned to XBARA_IN13 input. */
    kXbaraInputCMP2_output = 14|0x100U, /*!< CMP2 Output output assigned to XBARA_IN14 input. */
    kXbaraInputCMP3_output = 15|0x100U, /*!< CMP3 Output output assigned to XBARA_IN15 input. */
    kXbaraInputFTM0_match = 16|0x100U, /*!< FTM0 all channels output compare ORed together output assigned to XBARA_IN16 input. */
    kXbaraInputFTM0_EXTRIG = 17|0x100U, /*!< FTM0 all channels counter init ORed together output assigned to XBARA_IN17 input. */
    kXbaraInputFTM3_match = 18|0x100U, /*!< FTM3 all channels output compare ORed together output assigned to XBARA_IN18 input. */
    kXbaraInputFTM3_EXTRIG = 19|0x100U, /*!< FTM3 all channels counter init ORed together output assigned to XBARA_IN19 input. */
    kXbaraInputPWM0_TRG0 = 20|0x100U, /*!< PWMA channel 0 trigger 0 output assigned to XBARA_IN20 input. */
    kXbaraInputPWM0_TRG1 = 21|0x100U, /*!< PWMA channel 0 trigger 1 output assigned to XBARA_IN21 input. */
    kXbaraInputPWM1_TRG0 = 22|0x100U, /*!< PWMA channel 1 trigger 0 output assigned to XBARA_IN22 input. */
    kXbaraInputPWM1_TRG1 = 23|0x100U, /*!< PWMA channel 1 trigger 1 output assigned to XBARA_IN23 input. */
    kXbaraInputPWM2_TRG0 = 24|0x100U, /*!< PWMA channel 2 trigger 0 output assigned to XBARA_IN24 input. */
    kXbaraInputPWM2_TRG1 = 25|0x100U, /*!< PWMA channel 2 trigger 1 output assigned to XBARA_IN25 input. */
    kXbaraInputPWM3_TRG0 = 26|0x100U, /*!< PWMA channel 3 trigger 0 output assigned to XBARA_IN26 input. */
    kXbaraInputPWM3_TRG1 = 27|0x100U, /*!< PWMA channel 3 trigger 1 output assigned to XBARA_IN27 input. */
    kXbaraInputRESERVED28 = 28|0x100U, /*!< XBARA_IN28 input is reserved. */
    kXbaraInputPDB0_CH0_Output = 29|0x100U, /*!< PDB0 channel 0 output trigger output assigned to XBARA_IN29 input. */
    kXbaraInputRESERVED30 = 30|0x100U, /*!< XBARA_IN30 input is reserved. */
    kXbaraInputPDB1_CH0_Output = 31|0x100U, /*!< PDB1 channel 0 output trigger output assigned to XBARA_IN31 input. */
    kXbaraInputRESERVED32 = 32|0x100U, /*!< XBARA_IN32 input is reserved. */
    kXbaraInputADCA_ES = 33|0x100U, /*!< ADC converter A end of scan output assigned to XBARA_IN33 input. */
    kXbaraInputRESERVED34 = 34|0x100U, /*!< XBARA_IN34 input is reserved. */
    kXbaraInputADCB_ES = 35|0x100U, /*!< ADC converter B end of scan output assigned to XBARA_IN35 input. */
    kXbaraInputFTM1_match = 36|0x100U, /*!< FTM1 all channels output compare ORed together output assigned to XBARA_IN36 input. */
    kXbaraInputFTM1_EXTRIG = 37|0x100U, /*!< FTM1 all channels counter init ORed together output assigned to XBARA_IN37 input. */
    kXbaraInputDMA_CH0_done = 38|0x100U, /*!< DMA channel 0 done output assigned to XBARA_IN38 input. */
    kXbaraInputDMA_CH1_done = 39|0x100U, /*!< DMA channel 1 done output assigned to XBARA_IN39 input. */
    kXbaraInputDMA_CH6_done = 40|0x100U, /*!< DMA channel 6 done output assigned to XBARA_IN40 input. */
    kXbaraInputDMA_CH7_done = 41|0x100U, /*!< DMA channel 7 done output assigned to XBARA_IN41 input. */
    kXbaraInputPIT_trigger_0 = 42|0x100U, /*!< PIT trigger 0 output assigned to XBARA_IN42 input. */
    kXbaraInputPIT_trigger_1 = 43|0x100U, /*!< PIT trigger 1 output assigned to XBARA_IN43 input. */
    kXbaraInputRESERVED44 = 44|0x100U, /*!< XBARA_IN44 input is reserved. */
    kXbaraInputENC_CMP_pos_match = 45|0x100U, /*!< ENC compare trigger and position match output assigned to XBARA_IN45 input. */
    kXbaraInputAND_OR_INVERT_0 = 46|0x100U, /*!< AOI output 0 output assigned to XBARA_IN46 input. */
    kXbaraInputAND_OR_INVERT_1 = 47|0x100U, /*!< AOI output 1 output assigned to XBARA_IN47 input. */
    kXbaraInputAND_OR_INVERT_2 = 48|0x100U, /*!< AOI output 2 output assigned to XBARA_IN48 input. */
    kXbaraInputAND_OR_INVERT_3 = 49|0x100U, /*!< AOI output 3 output assigned to XBARA_IN49 input. */
    kXbaraInputPIT_trigger_2 = 50|0x100U, /*!< PIT trigger 2 output assigned to XBARA_IN50 input. */
    kXbaraInputPIT_trigger_3 = 51|0x100U, /*!< PIT trigger 3 output assigned to XBARA_IN51 input. */
    kXbarbInputCMP0_output = 0|0x200U, /*!< CMP0 Output output assigned to XBARB_IN0 input. */
    kXbarbInputCMP1_output = 1|0x200U, /*!< CMP1 Output output assigned to XBARB_IN1 input. */
    kXbarbInputCMP2_output = 2|0x200U, /*!< CMP2 Output output assigned to XBARB_IN2 input. */
    kXbarbInputCMP3_output = 3|0x200U, /*!< CMP3 Output output assigned to XBARB_IN3 input. */
    kXbarbInputFTM0_match = 4|0x200U, /*!< FTM0 all channels output compare ORed together output assigned to XBARB_IN4 input. */
    kXbarbInputFTM0_EXTRIG = 5|0x200U, /*!< FTM0 all channels counter init ORed together output assigned to XBARB_IN5 input. */
    kXbarbInputFTM3_match = 6|0x200U, /*!< FTM3 all channels output compare ORed together output assigned to XBARB_IN6 input. */
    kXbarbInputFTM3_EXTRIG = 7|0x200U, /*!< FTM3 all channels counter init ORed together output assigned to XBARB_IN7 input. */
    kXbarbInputPWM0_TRG0_or_PWM0_TRG1 = 8|0x200U, /*!< PWMA channel 0 trigger 0 or  trigger 1 output assigned to XBARB_IN8 input. */
    kXbarbInputPWM1_TRG0_or_PWM1_TRG1 = 9|0x200U, /*!< PWMA channel 1 trigger 0 or  trigger 1 output assigned to XBARB_IN9 input. */
    kXbarbInputPWM2_TRG0_or_PWM2_TRG1 = 10|0x200U, /*!< PWMA channel 2 trigger 0 or  trigger 1 output assigned to XBARB_IN10 input. */
    kXbarbInputPWM3_TRG0_or_PWM3_TRG1 = 11|0x200U, /*!< PWMA channel 3 trigger 0 or  trigger 1 output assigned to XBARB_IN11 input. */
    kXbarbInputPDB0_CH0_Output = 12|0x200U, /*!< PDB0 channel 0 output trigger output assigned to XBARB_IN12 input. */
    kXbarbInputADCA_ES = 13|0x200U, /*!< ADC converter A end of scan output assigned to XBARB_IN13 input. */
    kXbarbInputXBARIN2 = 14|0x200U, /*!< XBARIN2 input pin output assigned to XBARB_IN14 input. */
    kXbarbInputXBARIN3 = 15|0x200U, /*!< XBARIN3 input pin output assigned to XBARB_IN15 input. */
    kXbarbInputFTM1_match = 16|0x200U, /*!< FTM1 all channels output compare ORed together output assigned to XBARB_IN16 input. */
    kXbarbInputFTM1_EXTRIG = 17|0x200U, /*!< FTM1 all channels counter init ORed together output assigned to XBARB_IN17 input. */
    kXbarbInputDMA_CH0_done = 18|0x200U, /*!< DMA channel 0 done output assigned to XBARB_IN18 input. */
    kXbarbInputDMA_CH1_done = 19|0x200U, /*!< DMA channel 1 done output assigned to XBARB_IN19 input. */
    kXbarbInputXBARIN10 = 20|0x200U, /*!< XBARIN10 input pin output assigned to XBARB_IN20 input. */
    kXbarbInputXBARIN11 = 21|0x200U, /*!< XBARIN11 input pin output assigned to XBARB_IN21 input. */
    kXbarbInputDMA_CH6_done = 22|0x200U, /*!< DMA channel 6 done output assigned to XBARB_IN22 input. */
    kXbarbInputDMA_CH7_done = 23|0x200U, /*!< DMA channel 7 done output assigned to XBARB_IN23 input. */
    kXbarbInputPIT_trigger_0 = 24|0x200U, /*!< PIT trigger 0 output assigned to XBARB_IN24 input. */
    kXbarbInputPIT_trigger_1 = 25|0x200U, /*!< PIT trigger 1 output assigned to XBARB_IN25 input. */
    kXbarbInputPDB1_CH0_Output = 26|0x200U, /*!< PDB1 channel 0 output trigger output assigned to XBARB_IN26 input. */
    kXbarbInputADCB_ES = 27|0x200U, /*!< ADC converter B end of scan output assigned to XBARB_IN27 input. */
#else
    #error "No valid CPU defined!"
#endif
} xbar_input_signal_t;

typedef enum _xbar_output_signal {
#if defined(CPU_MKV40F128VLH15) || defined(CPU_MKV40F256VLH15) || defined(CPU_MKV40F64VLH15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputRESERVED15 = 15|0x100U, /*!< XBARA_OUT15 output is reserved. */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputRESERVED20 = 20|0x100U, /*!< XBARA_OUT20 output is reserved. */
    kXbaraOutputRESERVED21 = 21|0x100U, /*!< XBARA_OUT21 output is reserved. */
    kXbaraOutputRESERVED22 = 22|0x100U, /*!< XBARA_OUT22 output is reserved. */
    kXbaraOutputRESERVED23 = 23|0x100U, /*!< XBARA_OUT23 output is reserved. */
    kXbaraOutputRESERVED24 = 24|0x100U, /*!< XBARA_OUT24 output is reserved. */
    kXbaraOutputRESERVED25 = 25|0x100U, /*!< XBARA_OUT25 output is reserved. */
    kXbaraOutputRESERVED26 = 26|0x100U, /*!< XBARA_OUT26 output is reserved. */
    kXbaraOutputRESERVED27 = 27|0x100U, /*!< XBARA_OUT27 output is reserved. */
    kXbaraOutputRESERVED28 = 28|0x100U, /*!< XBARA_OUT28 output is reserved. */
    kXbaraOutputRESERVED29 = 29|0x100U, /*!< XBARA_OUT29 output is reserved. */
    kXbaraOutputRESERVED30 = 30|0x100U, /*!< XBARA_OUT30 output is reserved. */
    kXbaraOutputRESERVED31 = 31|0x100U, /*!< XBARA_OUT31 output is reserved. */
    kXbaraOutputRESERVED32 = 32|0x100U, /*!< XBARA_OUT32 output is reserved. */
    kXbaraOutputRESERVED33 = 33|0x100U, /*!< XBARA_OUT33 output is reserved. */
    kXbaraOutputFTM0_TRIG2 = 34|0x100U, /*!< XBARA_OUT34 output assigned to FTM0 hardware trigger 2 */
    kXbaraOutputFTM1_TRIG2 = 35|0x100U, /*!< XBARA_OUT35 output assigned to FTM1 hardware trigger 2 */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputRESERVED37 = 37|0x100U, /*!< XBARA_OUT37 output is reserved. */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputSIM_XOR_FTM1_CH1_FTM1_CH2 = 42|0x100U, /*!< XBARA_OUT42 output assigned to SIM XOR of FTM1_CH1 and FTM1_CH0 pins and XBARA output 42 */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputFTM0_FAULT3 = 49|0x100U, /*!< XBARA_OUT49 output assigned to FTM0 fault 3 */
    kXbaraOutputFTM1_FAULT1 = 50|0x100U, /*!< XBARA_OUT50 output assigned to FTM1 fault 1 */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputRESERVED52 = 52|0x100U, /*!< XBARA_OUT52 output is reserved. */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV40F128VLL15) || defined(CPU_MKV40F256VLL15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputRESERVED15 = 15|0x100U, /*!< XBARA_OUT15 output is reserved. */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputRESERVED20 = 20|0x100U, /*!< XBARA_OUT20 output is reserved. */
    kXbaraOutputRESERVED21 = 21|0x100U, /*!< XBARA_OUT21 output is reserved. */
    kXbaraOutputRESERVED22 = 22|0x100U, /*!< XBARA_OUT22 output is reserved. */
    kXbaraOutputRESERVED23 = 23|0x100U, /*!< XBARA_OUT23 output is reserved. */
    kXbaraOutputRESERVED24 = 24|0x100U, /*!< XBARA_OUT24 output is reserved. */
    kXbaraOutputRESERVED25 = 25|0x100U, /*!< XBARA_OUT25 output is reserved. */
    kXbaraOutputRESERVED26 = 26|0x100U, /*!< XBARA_OUT26 output is reserved. */
    kXbaraOutputRESERVED27 = 27|0x100U, /*!< XBARA_OUT27 output is reserved. */
    kXbaraOutputRESERVED28 = 28|0x100U, /*!< XBARA_OUT28 output is reserved. */
    kXbaraOutputRESERVED29 = 29|0x100U, /*!< XBARA_OUT29 output is reserved. */
    kXbaraOutputRESERVED30 = 30|0x100U, /*!< XBARA_OUT30 output is reserved. */
    kXbaraOutputRESERVED31 = 31|0x100U, /*!< XBARA_OUT31 output is reserved. */
    kXbaraOutputRESERVED32 = 32|0x100U, /*!< XBARA_OUT32 output is reserved. */
    kXbaraOutputRESERVED33 = 33|0x100U, /*!< XBARA_OUT33 output is reserved. */
    kXbaraOutputFTM0_TRIG2 = 34|0x100U, /*!< XBARA_OUT34 output assigned to FTM0 hardware trigger 2 */
    kXbaraOutputFTM1_TRIG2 = 35|0x100U, /*!< XBARA_OUT35 output assigned to FTM1 hardware trigger 2 */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputFTM3_TRIG2 = 37|0x100U, /*!< XBARA_OUT37 output assigned to FTM3 hardware trigger 2 */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputSIM_XOR_FTM1_CH1_FTM1_CH2 = 42|0x100U, /*!< XBARA_OUT42 output assigned to SIM XOR of FTM1_CH1 and FTM1_CH0 pins and XBARA output 42 */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputFTM0_FAULT3 = 49|0x100U, /*!< XBARA_OUT49 output assigned to FTM0 fault 3 */
    kXbaraOutputFTM1_FAULT1 = 50|0x100U, /*!< XBARA_OUT50 output assigned to FTM1 fault 1 */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputFTM3_FAULT3 = 52|0x100U, /*!< XBARA_OUT52 output assigned to FTM3 fault 3 */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV43F128VLH15) || defined(CPU_MKV43F128VLL15) || defined(CPU_MKV43F64VLH15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputRESERVED15 = 15|0x100U, /*!< XBARA_OUT15 output is reserved. */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputPWMA0_EXTA = 20|0x100U, /*!< XBARA_OUT20 output assigned to PWMA channel 0 external control A */
    kXbaraOutputPWMA1_EXTA = 21|0x100U, /*!< XBARA_OUT21 output assigned to PWMA channel 1 external control A */
    kXbaraOutputPWMA2_EXTA = 22|0x100U, /*!< XBARA_OUT22 output assigned to PWMA channel 2 external control A */
    kXbaraOutputPWMA3_EXTA = 23|0x100U, /*!< XBARA_OUT23 output assigned to PWMA channel 3 external control A */
    kXbaraOutputPWMA0_EXT_SYNC = 24|0x100U, /*!< XBARA_OUT24 output assigned to PWMA channel 0 external synchronization */
    kXbaraOutputPWMA1_EXT_SYNC = 25|0x100U, /*!< XBARA_OUT25 output assigned to PWMA channel 1 external synchronization */
    kXbaraOutputPWMA2_EXT_SYNC = 26|0x100U, /*!< XBARA_OUT26 output assigned to PWMA channel 2 external synchronization */
    kXbaraOutputPWMA3_EXT_SYNC = 27|0x100U, /*!< XBARA_OUT27 output assigned to PWMA channel 3 external synchronization */
    kXbaraOutputPWMA_EXT_CLK = 28|0x100U, /*!< XBARA_OUT28 output assigned to PWMA external clock */
    kXbaraOutputPWMA_FAULT0 = 29|0x100U, /*!< XBARA_OUT29 output assigned to PWMA fault 0 */
    kXbaraOutputPWMA_FAULT1 = 30|0x100U, /*!< XBARA_OUT30 output assigned to PWMA fault 1 */
    kXbaraOutputPWMA_FAULT2 = 31|0x100U, /*!< XBARA_OUT31 output assigned to PWMA fault 2 */
    kXbaraOutputPWMA_FAULT3 = 32|0x100U, /*!< XBARA_OUT32 output assigned to PWMA fault 3 */
    kXbaraOutputPWMA_FORCE = 33|0x100U, /*!< XBARA_OUT33 output assigned to PWMA external output force */
    kXbaraOutputRESERVED34 = 34|0x100U, /*!< XBARA_OUT34 output is reserved. */
    kXbaraOutputRESERVED35 = 35|0x100U, /*!< XBARA_OUT35 output is reserved. */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputRESERVED37 = 37|0x100U, /*!< XBARA_OUT37 output is reserved. */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputRESERVED42 = 42|0x100U, /*!< XBARA_OUT42 output is reserved. */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputRESERVED49 = 49|0x100U, /*!< XBARA_OUT49 output is reserved. */
    kXbaraOutputRESERVED50 = 50|0x100U, /*!< XBARA_OUT50 output is reserved. */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputRESERVED52 = 52|0x100U, /*!< XBARA_OUT52 output is reserved. */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV44F128VLH15) || defined(CPU_MKV44F128VLL15) || defined(CPU_MKV44F64VLH15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputDAC_12B_SYNC = 15|0x100U, /*!< XBARA_OUT15 output assigned to DAC synchronisation trigger */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputPWMA0_EXTA = 20|0x100U, /*!< XBARA_OUT20 output assigned to PWMA channel 0 external control A */
    kXbaraOutputPWMA1_EXTA = 21|0x100U, /*!< XBARA_OUT21 output assigned to PWMA channel 1 external control A */
    kXbaraOutputPWMA2_EXTA = 22|0x100U, /*!< XBARA_OUT22 output assigned to PWMA channel 2 external control A */
    kXbaraOutputPWMA3_EXTA = 23|0x100U, /*!< XBARA_OUT23 output assigned to PWMA channel 3 external control A */
    kXbaraOutputPWMA0_EXT_SYNC = 24|0x100U, /*!< XBARA_OUT24 output assigned to PWMA channel 0 external synchronization */
    kXbaraOutputPWMA1_EXT_SYNC = 25|0x100U, /*!< XBARA_OUT25 output assigned to PWMA channel 1 external synchronization */
    kXbaraOutputPWMA2_EXT_SYNC = 26|0x100U, /*!< XBARA_OUT26 output assigned to PWMA channel 2 external synchronization */
    kXbaraOutputPWMA3_EXT_SYNC = 27|0x100U, /*!< XBARA_OUT27 output assigned to PWMA channel 3 external synchronization */
    kXbaraOutputPWMA_EXT_CLK = 28|0x100U, /*!< XBARA_OUT28 output assigned to PWMA external clock */
    kXbaraOutputPWMA_FAULT0 = 29|0x100U, /*!< XBARA_OUT29 output assigned to PWMA fault 0 */
    kXbaraOutputPWMA_FAULT1 = 30|0x100U, /*!< XBARA_OUT30 output assigned to PWMA fault 1 */
    kXbaraOutputPWMA_FAULT2 = 31|0x100U, /*!< XBARA_OUT31 output assigned to PWMA fault 2 */
    kXbaraOutputPWMA_FAULT3 = 32|0x100U, /*!< XBARA_OUT32 output assigned to PWMA fault 3 */
    kXbaraOutputPWMA_FORCE = 33|0x100U, /*!< XBARA_OUT33 output assigned to PWMA external output force */
    kXbaraOutputRESERVED34 = 34|0x100U, /*!< XBARA_OUT34 output is reserved. */
    kXbaraOutputRESERVED35 = 35|0x100U, /*!< XBARA_OUT35 output is reserved. */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputRESERVED37 = 37|0x100U, /*!< XBARA_OUT37 output is reserved. */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputRESERVED42 = 42|0x100U, /*!< XBARA_OUT42 output is reserved. */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputRESERVED49 = 49|0x100U, /*!< XBARA_OUT49 output is reserved. */
    kXbaraOutputRESERVED50 = 50|0x100U, /*!< XBARA_OUT50 output is reserved. */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputRESERVED52 = 52|0x100U, /*!< XBARA_OUT52 output is reserved. */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV45F128VLH15) || defined(CPU_MKV45F256VLH15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputRESERVED15 = 15|0x100U, /*!< XBARA_OUT15 output is reserved. */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputPWMA0_EXTA = 20|0x100U, /*!< XBARA_OUT20 output assigned to PWMA channel 0 external control A */
    kXbaraOutputPWMA1_EXTA = 21|0x100U, /*!< XBARA_OUT21 output assigned to PWMA channel 1 external control A */
    kXbaraOutputPWMA2_EXTA = 22|0x100U, /*!< XBARA_OUT22 output assigned to PWMA channel 2 external control A */
    kXbaraOutputPWMA3_EXTA = 23|0x100U, /*!< XBARA_OUT23 output assigned to PWMA channel 3 external control A */
    kXbaraOutputPWMA0_EXT_SYNC = 24|0x100U, /*!< XBARA_OUT24 output assigned to PWMA channel 0 external synchronization */
    kXbaraOutputPWMA1_EXT_SYNC = 25|0x100U, /*!< XBARA_OUT25 output assigned to PWMA channel 1 external synchronization */
    kXbaraOutputPWMA2_EXT_SYNC = 26|0x100U, /*!< XBARA_OUT26 output assigned to PWMA channel 2 external synchronization */
    kXbaraOutputPWMA3_EXT_SYNC = 27|0x100U, /*!< XBARA_OUT27 output assigned to PWMA channel 3 external synchronization */
    kXbaraOutputPWMA_EXT_CLK = 28|0x100U, /*!< XBARA_OUT28 output assigned to PWMA external clock */
    kXbaraOutputPWMA_FAULT0 = 29|0x100U, /*!< XBARA_OUT29 output assigned to PWMA fault 0 */
    kXbaraOutputPWMA_FAULT1 = 30|0x100U, /*!< XBARA_OUT30 output assigned to PWMA fault 1 */
    kXbaraOutputPWMA_FAULT2 = 31|0x100U, /*!< XBARA_OUT31 output assigned to PWMA fault 2 */
    kXbaraOutputPWMA_FAULT3 = 32|0x100U, /*!< XBARA_OUT32 output assigned to PWMA fault 3 */
    kXbaraOutputPWMA_FORCE = 33|0x100U, /*!< XBARA_OUT33 output assigned to PWMA external output force */
    kXbaraOutputFTM0_TRIG2 = 34|0x100U, /*!< XBARA_OUT34 output assigned to FTM0 hardware trigger 2 */
    kXbaraOutputFTM1_TRIG2 = 35|0x100U, /*!< XBARA_OUT35 output assigned to FTM1 hardware trigger 2 */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputRESERVED37 = 37|0x100U, /*!< XBARA_OUT37 output is reserved. */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputSIM_XOR_FTM1_CH1_FTM1_CH2 = 42|0x100U, /*!< XBARA_OUT42 output assigned to SIM XOR of FTM1_CH1 and FTM1_CH0 pins and XBARA output 42 */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputFTM0_FAULT3 = 49|0x100U, /*!< XBARA_OUT49 output assigned to FTM0 fault 3 */
    kXbaraOutputFTM1_FAULT1 = 50|0x100U, /*!< XBARA_OUT50 output assigned to FTM1 fault 1 */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputRESERVED52 = 52|0x100U, /*!< XBARA_OUT52 output is reserved. */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV45F128VLL15) || defined(CPU_MKV45F256VLL15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputRESERVED15 = 15|0x100U, /*!< XBARA_OUT15 output is reserved. */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputPWMA0_EXTA = 20|0x100U, /*!< XBARA_OUT20 output assigned to PWMA channel 0 external control A */
    kXbaraOutputPWMA1_EXTA = 21|0x100U, /*!< XBARA_OUT21 output assigned to PWMA channel 1 external control A */
    kXbaraOutputPWMA2_EXTA = 22|0x100U, /*!< XBARA_OUT22 output assigned to PWMA channel 2 external control A */
    kXbaraOutputPWMA3_EXTA = 23|0x100U, /*!< XBARA_OUT23 output assigned to PWMA channel 3 external control A */
    kXbaraOutputPWMA0_EXT_SYNC = 24|0x100U, /*!< XBARA_OUT24 output assigned to PWMA channel 0 external synchronization */
    kXbaraOutputPWMA1_EXT_SYNC = 25|0x100U, /*!< XBARA_OUT25 output assigned to PWMA channel 1 external synchronization */
    kXbaraOutputPWMA2_EXT_SYNC = 26|0x100U, /*!< XBARA_OUT26 output assigned to PWMA channel 2 external synchronization */
    kXbaraOutputPWMA3_EXT_SYNC = 27|0x100U, /*!< XBARA_OUT27 output assigned to PWMA channel 3 external synchronization */
    kXbaraOutputPWMA_EXT_CLK = 28|0x100U, /*!< XBARA_OUT28 output assigned to PWMA external clock */
    kXbaraOutputPWMA_FAULT0 = 29|0x100U, /*!< XBARA_OUT29 output assigned to PWMA fault 0 */
    kXbaraOutputPWMA_FAULT1 = 30|0x100U, /*!< XBARA_OUT30 output assigned to PWMA fault 1 */
    kXbaraOutputPWMA_FAULT2 = 31|0x100U, /*!< XBARA_OUT31 output assigned to PWMA fault 2 */
    kXbaraOutputPWMA_FAULT3 = 32|0x100U, /*!< XBARA_OUT32 output assigned to PWMA fault 3 */
    kXbaraOutputPWMA_FORCE = 33|0x100U, /*!< XBARA_OUT33 output assigned to PWMA external output force */
    kXbaraOutputFTM0_TRIG2 = 34|0x100U, /*!< XBARA_OUT34 output assigned to FTM0 hardware trigger 2 */
    kXbaraOutputFTM1_TRIG2 = 35|0x100U, /*!< XBARA_OUT35 output assigned to FTM1 hardware trigger 2 */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputFTM3_TRIG2 = 37|0x100U, /*!< XBARA_OUT37 output assigned to FTM3 hardware trigger 2 */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputSIM_XOR_FTM1_CH1_FTM1_CH2 = 42|0x100U, /*!< XBARA_OUT42 output assigned to SIM XOR of FTM1_CH1 and FTM1_CH0 pins and XBARA output 42 */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputFTM0_FAULT3 = 49|0x100U, /*!< XBARA_OUT49 output assigned to FTM0 fault 3 */
    kXbaraOutputFTM1_FAULT1 = 50|0x100U, /*!< XBARA_OUT50 output assigned to FTM1 fault 1 */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputFTM3_FAULT3 = 52|0x100U, /*!< XBARA_OUT52 output assigned to FTM3 fault 3 */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV46F128VLH15) || defined(CPU_MKV46F256VLH15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputDAC_12B_SYNC = 15|0x100U, /*!< XBARA_OUT15 output assigned to DAC synchronisation trigger */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputPWMA0_EXTA = 20|0x100U, /*!< XBARA_OUT20 output assigned to PWMA channel 0 external control A */
    kXbaraOutputPWMA1_EXTA = 21|0x100U, /*!< XBARA_OUT21 output assigned to PWMA channel 1 external control A */
    kXbaraOutputPWMA2_EXTA = 22|0x100U, /*!< XBARA_OUT22 output assigned to PWMA channel 2 external control A */
    kXbaraOutputPWMA3_EXTA = 23|0x100U, /*!< XBARA_OUT23 output assigned to PWMA channel 3 external control A */
    kXbaraOutputPWMA0_EXT_SYNC = 24|0x100U, /*!< XBARA_OUT24 output assigned to PWMA channel 0 external synchronization */
    kXbaraOutputPWMA1_EXT_SYNC = 25|0x100U, /*!< XBARA_OUT25 output assigned to PWMA channel 1 external synchronization */
    kXbaraOutputPWMA2_EXT_SYNC = 26|0x100U, /*!< XBARA_OUT26 output assigned to PWMA channel 2 external synchronization */
    kXbaraOutputPWMA3_EXT_SYNC = 27|0x100U, /*!< XBARA_OUT27 output assigned to PWMA channel 3 external synchronization */
    kXbaraOutputPWMA_EXT_CLK = 28|0x100U, /*!< XBARA_OUT28 output assigned to PWMA external clock */
    kXbaraOutputPWMA_FAULT0 = 29|0x100U, /*!< XBARA_OUT29 output assigned to PWMA fault 0 */
    kXbaraOutputPWMA_FAULT1 = 30|0x100U, /*!< XBARA_OUT30 output assigned to PWMA fault 1 */
    kXbaraOutputPWMA_FAULT2 = 31|0x100U, /*!< XBARA_OUT31 output assigned to PWMA fault 2 */
    kXbaraOutputPWMA_FAULT3 = 32|0x100U, /*!< XBARA_OUT32 output assigned to PWMA fault 3 */
    kXbaraOutputPWMA_FORCE = 33|0x100U, /*!< XBARA_OUT33 output assigned to PWMA external output force */
    kXbaraOutputFTM0_TRIG2 = 34|0x100U, /*!< XBARA_OUT34 output assigned to FTM0 hardware trigger 2 */
    kXbaraOutputFTM1_TRIG2 = 35|0x100U, /*!< XBARA_OUT35 output assigned to FTM1 hardware trigger 2 */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputRESERVED37 = 37|0x100U, /*!< XBARA_OUT37 output is reserved. */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputSIM_XOR_FTM1_CH1_FTM1_CH2 = 42|0x100U, /*!< XBARA_OUT42 output assigned to SIM XOR of FTM1_CH1 and FTM1_CH0 pins and XBARA output 42 */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputFTM0_FAULT3 = 49|0x100U, /*!< XBARA_OUT49 output assigned to FTM0 fault 3 */
    kXbaraOutputFTM1_FAULT1 = 50|0x100U, /*!< XBARA_OUT50 output assigned to FTM1 fault 1 */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputRESERVED52 = 52|0x100U, /*!< XBARA_OUT52 output is reserved. */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#elif defined(CPU_MKV46F128VLL15) || defined(CPU_MKV46F256VLL15)
    kXbaraOutputDMAMUX18 = 0|0x100U, /*!< XBARA_OUT0 output assigned to DMAMUX slot 18 */
    kXbaraOutputDMAMUX19 = 1|0x100U, /*!< XBARA_OUT1 output assigned to DMAMUX slot 19 */
    kXbaraOutputDMAMUX20 = 2|0x100U, /*!< XBARA_OUT2 output assigned to DMAMUX slot 20 */
    kXbaraOutputDMAMUX21 = 3|0x100U, /*!< XBARA_OUT3 output assigned to DMAMUX slot 21 */
    kXbaraOutputXB_OUT4 = 4|0x100U, /*!< XBARA_OUT4 output assigned to XBAROUT4 output pin */
    kXbaraOutputXB_OUT5 = 5|0x100U, /*!< XBARA_OUT5 output assigned to XBAROUT5 output pin */
    kXbaraOutputXB_OUT6 = 6|0x100U, /*!< XBARA_OUT6 output assigned to XBAROUT6 output pin */
    kXbaraOutputXB_OUT7 = 7|0x100U, /*!< XBARA_OUT7 output assigned to XBAROUT7 output pin */
    kXbaraOutputXB_OUT8 = 8|0x100U, /*!< XBARA_OUT8 output assigned to XBAROUT8 output pin */
    kXbaraOutputXB_OUT9 = 9|0x100U, /*!< XBARA_OUT9 output assigned to XBAROUT9 output pin */
    kXbaraOutputXB_OUT10 = 10|0x100U, /*!< XBARA_OUT10 output assigned to XBAROUT10 output pin */
    kXbaraOutputXB_OUT11 = 11|0x100U, /*!< XBARA_OUT11 output assigned to XBAROUT11 output pin */
    kXbaraOutputADCA_TRIG = 12|0x100U, /*!< XBARA_OUT12 output assigned to ADC converter A trigger */
    kXbaraOutputADCB_TRIG = 13|0x100U, /*!< XBARA_OUT13 output assigned to ADC converter B trigger */
    kXbaraOutputRESERVED14 = 14|0x100U, /*!< XBARA_OUT14 output is reserved. */
    kXbaraOutputDAC_12B_SYNC = 15|0x100U, /*!< XBARA_OUT15 output assigned to DAC synchronisation trigger */
    kXbaraOutputCMP0 = 16|0x100U, /*!< XBARA_OUT16 output assigned to CMP0 window/sample */
    kXbaraOutputCMP1 = 17|0x100U, /*!< XBARA_OUT17 output assigned to CMP1 window/sample */
    kXbaraOutputCMP2 = 18|0x100U, /*!< XBARA_OUT18 output assigned to CMP2 window/sample */
    kXbaraOutputCMP3 = 19|0x100U, /*!< XBARA_OUT19 output assigned to CMP3 window/sample */
    kXbaraOutputPWMA0_EXTA = 20|0x100U, /*!< XBARA_OUT20 output assigned to PWMA channel 0 external control A */
    kXbaraOutputPWMA1_EXTA = 21|0x100U, /*!< XBARA_OUT21 output assigned to PWMA channel 1 external control A */
    kXbaraOutputPWMA2_EXTA = 22|0x100U, /*!< XBARA_OUT22 output assigned to PWMA channel 2 external control A */
    kXbaraOutputPWMA3_EXTA = 23|0x100U, /*!< XBARA_OUT23 output assigned to PWMA channel 3 external control A */
    kXbaraOutputPWMA0_EXT_SYNC = 24|0x100U, /*!< XBARA_OUT24 output assigned to PWMA channel 0 external synchronization */
    kXbaraOutputPWMA1_EXT_SYNC = 25|0x100U, /*!< XBARA_OUT25 output assigned to PWMA channel 1 external synchronization */
    kXbaraOutputPWMA2_EXT_SYNC = 26|0x100U, /*!< XBARA_OUT26 output assigned to PWMA channel 2 external synchronization */
    kXbaraOutputPWMA3_EXT_SYNC = 27|0x100U, /*!< XBARA_OUT27 output assigned to PWMA channel 3 external synchronization */
    kXbaraOutputPWMA_EXT_CLK = 28|0x100U, /*!< XBARA_OUT28 output assigned to PWMA external clock */
    kXbaraOutputPWMA_FAULT0 = 29|0x100U, /*!< XBARA_OUT29 output assigned to PWMA fault 0 */
    kXbaraOutputPWMA_FAULT1 = 30|0x100U, /*!< XBARA_OUT30 output assigned to PWMA fault 1 */
    kXbaraOutputPWMA_FAULT2 = 31|0x100U, /*!< XBARA_OUT31 output assigned to PWMA fault 2 */
    kXbaraOutputPWMA_FAULT3 = 32|0x100U, /*!< XBARA_OUT32 output assigned to PWMA fault 3 */
    kXbaraOutputPWMA_FORCE = 33|0x100U, /*!< XBARA_OUT33 output assigned to PWMA external output force */
    kXbaraOutputFTM0_TRIG2 = 34|0x100U, /*!< XBARA_OUT34 output assigned to FTM0 hardware trigger 2 */
    kXbaraOutputFTM1_TRIG2 = 35|0x100U, /*!< XBARA_OUT35 output assigned to FTM1 hardware trigger 2 */
    kXbaraOutputRESERVED36 = 36|0x100U, /*!< XBARA_OUT36 output is reserved. */
    kXbaraOutputFTM3_TRIG2 = 37|0x100U, /*!< XBARA_OUT37 output assigned to FTM3 hardware trigger 2 */
    kXbaraOutputPDB0_IN_CH_12 = 38|0x100U, /*!< XBARA_OUT38 output assigned to PDB0 trigger option 12 */
    kXbaraOutputRESERVED39 = 39|0x100U, /*!< XBARA_OUT39 output is reserved. */
    kXbaraOutputRESERVED40 = 40|0x100U, /*!< XBARA_OUT40 output is reserved. */
    kXbaraOutputPDB1_IN_CH_12 = 41|0x100U, /*!< XBARA_OUT41 output assigned to PDB1 trigger option 12 */
    kXbaraOutputSIM_XOR_FTM1_CH1_FTM1_CH2 = 42|0x100U, /*!< XBARA_OUT42 output assigned to SIM XOR of FTM1_CH1 and FTM1_CH0 pins and XBARA output 42 */
    kXbaraOutputRESERVED43 = 43|0x100U, /*!< XBARA_OUT43 output is reserved. */
    kXbaraOutputENC_PHA = 44|0x100U, /*!< XBARA_OUT44 output assigned to ENC quadrature waveform phase A */
    kXbaraOutputENC_PHB = 45|0x100U, /*!< XBARA_OUT45 output assigned to ENC quadrature waveform phase B */
    kXbaraOutputENC_INDEX = 46|0x100U, /*!< XBARA_OUT46 output assigned to ENC refresh/reload */
    kXbaraOutputENC_HOME = 47|0x100U, /*!< XBARA_OUT47 output assigned to ENC home position */
    kXbaraOutputENC_CAP_Trigger = 48|0x100U, /*!< XBARA_OUT48 output assigned to ENC clear/snapshot */
    kXbaraOutputFTM0_FAULT3 = 49|0x100U, /*!< XBARA_OUT49 output assigned to FTM0 fault 3 */
    kXbaraOutputFTM1_FAULT1 = 50|0x100U, /*!< XBARA_OUT50 output assigned to FTM1 fault 1 */
    kXbaraOutputRESERVED51 = 51|0x100U, /*!< XBARA_OUT51 output is reserved. */
    kXbaraOutputFTM3_FAULT3 = 52|0x100U, /*!< XBARA_OUT52 output assigned to FTM3 fault 3 */
    kXbaraOutputRESERVED53 = 53|0x100U, /*!< XBARA_OUT53 output is reserved. */
    kXbaraOutputRESERVED54 = 54|0x100U, /*!< XBARA_OUT54 output is reserved. */
    kXbaraOutputRESERVED55 = 55|0x100U, /*!< XBARA_OUT55 output is reserved. */
    kXbaraOutputRESERVED56 = 56|0x100U, /*!< XBARA_OUT56 output is reserved. */
    kXbaraOutputRESERVED57 = 57|0x100U, /*!< XBARA_OUT57 output is reserved. */
    kXbaraOutputEWM_IN = 58|0x100U, /*!< XBARA_OUT58 output assigned to EWM input */
    kXbarbOutputAOI_IN0 = 0|0x200U, /*!< XBARB_OUT0 output assigned to AOI input0 */
    kXbarbOutputAOI_IN1 = 1|0x200U, /*!< XBARB_OUT1 output assigned to AOI input1 */
    kXbarbOutputAOI_IN2 = 2|0x200U, /*!< XBARB_OUT2 output assigned to AOI input2 */
    kXbarbOutputAOI_IN3 = 3|0x200U, /*!< XBARB_OUT3 output assigned to AOI input3 */
    kXbarbOutputAOI_IN4 = 4|0x200U, /*!< XBARB_OUT4 output assigned to AOI input4 */
    kXbarbOutputAOI_IN5 = 5|0x200U, /*!< XBARB_OUT5 output assigned to AOI input5 */
    kXbarbOutputAOI_IN6 = 6|0x200U, /*!< XBARB_OUT6 output assigned to AOI input6 */
    kXbarbOutputAOI_IN7 = 7|0x200U, /*!< XBARB_OUT7 output assigned to AOI input7 */
    kXbarbOutputAOI_IN8 = 8|0x200U, /*!< XBARB_OUT8 output assigned to AOI input8 */
    kXbarbOutputAOI_IN9 = 9|0x200U, /*!< XBARB_OUT9 output assigned to AOI input9 */
    kXbarbOutputAOI_IN10 = 10|0x200U, /*!< XBARB_OUT10 output assigned to AOI input10 */
    kXbarbOutputAOI_IN11 = 11|0x200U, /*!< XBARB_OUT11 output assigned to AOI input11 */
    kXbarbOutputAOI_IN12 = 12|0x200U, /*!< XBARB_OUT12 output assigned to AOI input12 */
    kXbarbOutputAOI_IN13 = 13|0x200U, /*!< XBARB_OUT13 output assigned to AOI input13 */
    kXbarbOutputAOI_IN14 = 14|0x200U, /*!< XBARB_OUT14 output assigned to AOI input14 */
    kXbarbOutputAOI_IN15 = 15|0x200U, /*!< XBARB_OUT15 output assigned to AOI input15 */
#else
    #error "No valid CPU defined!"
#endif
} xbar_output_signal_t;


#endif /* __FSL_XBAR_SIGNALS_H__ */

/*******************************************************************************
 * EOF
 ******************************************************************************/

