#******************************************************************************
#
# Freescale Semiconductor Inc.
# (c) Copyright 2004-2008 Freescale Semiconductor, Inc.
# ALL RIGHTS RESERVED.
#
#**************************************************************************//*!
#
# @file		makefile.csm
# @author	b35258
# @version	0.0.2.0
# @date		Oct-20-2012
# 
# @brief	This makefile is preconfigured for CodeWarrior compiler
# 
#******************************************************************************/

# ---------------------------------------------------------
# Compiler Setup
# ---------------------------------------------------------
CODEWARRIOR_PATH    = c:/Freescale/CW MCU v10.6
COMPILER_PATH       = $(CODEWARRIOR_PATH)/MCU/S12lisa_Tools/Build_Tools
COMPILER_EXE_FILE   = mwccs12lisa.exe

# ---------------------------------------------------------
# Linker Setup
# ---------------------------------------------------------
LINKER_PATH         = $(COMPILER_PATH)
LINKER_EXE_FILE     = linker.exe

# ---------------------------------------------------------
# Assembler Setup
# ---------------------------------------------------------
ASSEMBLER_PATH         = $(COMPILER_PATH)
ASSEMBLER_EXE_FILE     = as12lisa.exe

SYS_INCDIR				= -I- -I"$(CODEWARRIOR_PATH)/MCU/S12lisa_Support/s12lisac/include" 

LINKER_CONFIG_FILE  = S12zvm.prm
LINKER_CONFIG_PATH  = src/S12ZVM_system/startup_CW

# System source files path
SYSTEM_SRC_PATH     =  $(LINKER_CONFIG_PATH)
LIBRARY_FILE        = lib/cw10x/MC9S12ZVM_AMMCLIB_v1.0.2.UC.a

CFLAGS  = -c -v -g -model small -lang c99 -allow_macro_redefs -opt level=2 -opt speed -inline auto -DSWLIBS_DEFAULT_IMPLEMENTATION=SWLIBS_DEFAULT_IMPLEMENTATION_F16 -o $(OBJDIR) $(INCDIR)
ASFLAGS = 
LDFLAGS = -v -B -M -Env"TEXTPATH=$(OUTDIR)" $(LINKER_FILE) -Add{$(OBJS) $(LIBRARY_PATH)/$(LIBRARY_FILE)} -O$(OUTDIR)/$(OUTPUT_FILE_NAME).elf -WmsgSd1100 -WmsgSd1912