/*Read me
 * This code has been tested on Freescale's MTRCKTSBNZVM128 (Motor Control kit), which contains:
 * -S12ZVMx12EVB Rev D
 * -LINIX 45ZWN24-90-B 
 * 
 * Please refer to "config_me.h" (Sources/Drivers in this project) to configure the working mode of this software
 * The availabe options are the following
 * -Complementary or independent mode
 * -Select signals routing to either motor (Power FETs) or GPIOs
 * -Select rotation direction
 * Among other possible parameters modifications (PWM modulo, Duty cycle, Dead time)
 * */
#include <hidef.h>      /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCU_init.h"   /* CPMU and PIM initialisation routine */
#include "config_me.h"  /* Configuration header */
#include "PMF.h"		/* GDU and PMF initialisation routines*/

/* Global variables */
unsigned char commutation_state = 0;
#if PMF_MODE == INDEPENDENT_LS_FIX
const unsigned char MaskVal [6] = {PWM0_PWM3_ACTIVE, PWM0_PWM5_ACTIVE, PWM2_PWM5_ACTIVE,
					   	     	   PWM1_PWM2_ACTIVE, PWM1_PWM4_ACTIVE, PWM3_PWM4_ACTIVE};
const unsigned char Outctl[6] = {PMFOUTC_OUTCTL3_MASK, PMFOUTC_OUTCTL5_MASK, PMFOUTC_OUTCTL5_MASK, 
								 PMFOUTC_OUTCTL1_MASK, PMFOUTC_OUTCTL1_MASK, PMFOUTC_OUTCTL3_MASK};
#elif PMF_MODE == INDEPENDENT_HS_FIX
const unsigned char MaskVal [6] = {PWM0_PWM3_ACTIVE, PWM0_PWM5_ACTIVE, PWM2_PWM5_ACTIVE,
					   	     	   PWM1_PWM2_ACTIVE, PWM1_PWM4_ACTIVE, PWM3_PWM4_ACTIVE};
const unsigned char Outctl[6] = {PMFOUTC_OUTCTL0_MASK, PMFOUTC_OUTCTL0_MASK, PMFOUTC_OUTCTL2_MASK, 
								 PMFOUTC_OUTCTL2_MASK, PMFOUTC_OUTCTL4_MASK, PMFOUTC_OUTCTL4_MASK};
#elif PMF_MODE == COMPLEMENTARY_BIPOLAR
const unsigned char MaskVal [6] = {PWM0_PWM1_PWM2_PWM3_ACTIVE, PWM0_PWM1_PWM4_PWM5_ACTIVE, PWM2_PWM3_PWM4_PWM5_ACTIVE,
								   PWM0_PWM1_PWM2_PWM3_ACTIVE, PWM0_PWM1_PWM4_PWM5_ACTIVE, PWM2_PWM3_PWM4_PWM5_ACTIVE};
const unsigned char Inv [6] = {PMFCFG3_PINVB_MASK, PMFCFG3_PINVC_MASK, PMFCFG3_PINVC_MASK,
							   PMFCFG3_PINVA_MASK, PMFCFG3_PINVA_MASK, PMFCFG3_PINVB_MASK};
#elif PMF_MODE == COMPLEMENTARY_UNIPOLAR_LS_FIX
const unsigned char MaskVal [6] = {PWM0_PWM1_PWM3_ACTIVE, PWM0_PWM1_PWM5_ACTIVE, PWM2_PWM3_PWM5_ACTIVE, 
								   PWM1_PWM2_PWM3_ACTIVE, PWM1_PWM4_PWM5_ACTIVE, PWM3_PWM4_PWM5_ACTIVE};
const unsigned char Outctl[6] = {0x0C, 0x30, 0x30, 
								 0x03, 0x03, 0x0C};
#elif PMF_MODE == COMPLEMENTARY_UNIPOLAR_HS_FIX
const unsigned char MaskVal [6] = {PWM0_PWM2_PWM3_ACTIVE, PWM0_PWM4_PWM5_ACTIVE, PWM2_PWM4_PWM5_ACTIVE, 
								   PWM0_PWM1_PWM2_ACTIVE, PWM0_PWM1_PWM4_ACTIVE, PWM2_PWM3_PWM4_ACTIVE};
const unsigned char Outctl[6] = {0x03, 0x03, 0x0C, 
								 0x0C, 0x30, 0x30};
#elif PMF_MODE == PMF_OUTC_ONLY
const unsigned char MaskVal [6] = {0, 0, 0, 
								   0, 0, 0};
const unsigned char Outctl[6] = {0x1C, 0x34, 0x31, 
								 0x13, 0x07, 0x0D};
#endif
const unsigned char BLDCPattern[2][6] = {{0, 2, 1, 4, 5, 3}, {3, 5, 4, 1, 2, 0}};

/* Macro definitions */
#if PMF_MODE != COMPLEMENTARY_BIPOLAR
	#if ROUTE == MOTOR
	#define COMMUTE			commutation_state = BLDCPattern[rotdir][HALL - 1]; /* Read Hall sensors and obtain pattern */\
							PMFCFG2_MSK = MaskVal[commutation_state]; /* Mask PWM channels */\
							PMFOUTC_OUTCTL = Outctl[commutation_state]; /* Mask software control active channels */\
							TIM0TCTL2_OL0 = 1;/* Toggle on output compare */\
							TIM0CFORC_FOC0 = 1; /* Force commutation */\
							TIM0TCTL2_OL0 = 0; /* Disable Toggle on OC to avoid undesired commutations */
	#else
	#define COMMUTE			++commutation_state;  /* increment and obtain pattern */\
							commutation_state %= 6; /* keep variable from 0-5*/\
							PMFCFG2_MSK = MaskVal[commutation_state]; /* Mask PWM channels */\
							PMFOUTC_OUTCTL = Outctl[commutation_state]; /* Mask software control active channels */\
							TIM0TCTL2_OL0 = 1;/* Toggle on output compare */\
							TIM0CFORC_FOC0 = 1; /* Force commutation */\
							TIM0TCTL2_OL0 = 0; /* Disable Toggle on OC to avoid undesired commutations */
	#endif
#else
	#if ROUTE == MOTOR
	#define COMMUTE			commutation_state = BLDCPattern[rotdir][HALL - 1]; /* Read Hall sensors and obtain pattern */\
							PMFCFG2_MSK = MaskVal[commutation_state]; /* Mask PWM channels */\
							PMFCFG3_PINVx = Inv[commutation_state]; /* Invert PWM channels */\
							PMFENCA_LDOKA;\
							PMFENCA_LDOKA = 1;	/* PMF external global load OK signal, reloads double buffered registers */
	#else
	#define COMMUTE			++commutation_state;  /* increment and obtain pattern */\
							commutation_state %= 6; /* keep variable from 0-5*/\
							PMFCFG2_MSK = MaskVal[commutation_state]; /* Mask PWM channels */\
							PMFCFG3_PINVx = Inv[commutation_state]; /* Invert PWM channels */\
							PMFENCA_LDOKA;\
							PMFENCA_LDOKA = 1;	/* PMF external global load OK signal, reloads double buffered registers */						
	#endif
#endif
							
void main(void) {
	
	/* Initialise modules */
#if ROUTE == MOTOR
	MCU_init(CPU_12_5MHZ, PWM_MOTOR);
	init_TIM1_motor;
	ENCE;
#else
	MCU_init(CPU_12_5MHZ, PWM_GPIO);
	init_TIM1_gpio;
	ENCE;
#endif
	init_PMF(PWM_MODULO, DC);
	init_GDU();
	EnableInterrupts;
	COMMUTE;

	for(;;) {
		__RESET_WATCHDOG();	/* feeds the dog */ 
	} /* loop forever */
}


#pragma CODE_SEG __NEAR_SEG NON_BANKED
/* Commutation routine */
interrupt VectorNumber_Vtim0ch1 void timch0_ISR(){

	/* Read hall and commute */
#if ROUTE == MOTOR
	COMMUTE;
#else
	TIM0TC1 += 25000;
	COMMUTE;
#endif
	TIM0TFLG1 = TIM0TFLG1_C1F_MASK;
}

interrupt VectorNumber_Vpmfra void PMFreloadA_ISR(void)
{
	volatile char tmp;

	tmp = PMFFQCA;
	PMFFQCA = PMFFQCA_PWMRFA_MASK;		/* Clear flag */
}
#pragma CODE_SEG DEFAULT
