/*
 * PMF.h
 *
 *  Created on: Mar 12, 2015
 *      Author: B52932
 */

#ifndef PMF_H_
#define PMF_H_

#include "config_me.h" 

#if PMF_MODE == INDEPENDENT_HS_FIX  || PMF_MODE == INDEPENDENT_LS_FIX	/* Phase A | Phase B | Phase C |HALL CBA*/
#define PWM0_PWM3_ACTIVE 0x36											/*  +Vdbc  |  -Vdbc  |   NC    |   001  */
#define PWM0_PWM5_ACTIVE 0x1E											/*  +Vdbc  |    NC   |  -Vdbc  |   011  */
#define PWM2_PWM5_ACTIVE 0x1B											/*    NC   |  +Vdbc  |  -Vdbc  |   010  */
#define PWM1_PWM2_ACTIVE 0x39											/*  -Vdbc  |  +Vdbc  |    NC   |   110  */
#define PWM1_PWM4_ACTIVE 0x2D											/*  -Vdbc  |    NC   |  +Vdbc  |   100  */
#define PWM3_PWM4_ACTIVE 0x27											/*    NC   |  -Vdbc  |  +Vdbc  |   101  */ 
#elif PMF_MODE == COMPLEMENTARY_BIPOLAR
#define PWM0_PWM1_PWM2_PWM3_ACTIVE 0x30	/*  +Vdbc  |  -Vdbc  |   NC    |   001  */
#define PWM0_PWM1_PWM4_PWM5_ACTIVE 0x0C	/*  +Vdbc  |    NC   |  -Vdbc  |   011  */
#define PWM2_PWM3_PWM4_PWM5_ACTIVE 0x03	/*    NC   |  +Vdbc  |  -Vdbc  |   010  */
#define PWM0_PWM1_PWM2_PWM3_ACTIVE 0x30 /*  -Vdbc  |  +Vdbc  |    NC   |   110  */
#define PWM0_PWM1_PWM4_PWM5_ACTIVE 0x0C	/*  -Vdbc  |    NC   |  +Vdbc  |   100  */
#define PWM2_PWM3_PWM4_PWM5_ACTIVE 0x03	/*    NC   |  -Vdbc  |  +Vdbc  |   101  */
#elif PMF_MODE == COMPLEMENTARY_UNIPOLAR_LS_FIX
#define PWM0_PWM1_PWM3_ACTIVE 0x34	/*  +Vdbc  |  -Vdbc  |   NC    |   001  */
#define PWM0_PWM1_PWM5_ACTIVE 0x1C	/*  +Vdbc  |    NC   |  -Vdbc  |   011  */
#define PWM2_PWM3_PWM5_ACTIVE 0x13	/*    NC   |  +Vdbc  |  -Vdbc  |   010  */
#define PWM1_PWM2_PWM3_ACTIVE 0x31  /*  -Vdbc  |  +Vdbc  |    NC   |   110  */
#define PWM1_PWM4_PWM5_ACTIVE 0x0D	/*  -Vdbc  |    NC   |  +Vdbc  |   100  */
#define PWM3_PWM4_PWM5_ACTIVE 0x07	/*    NC   |  -Vdbc  |  +Vdbc  |   101  */
#elif PMF_MODE == COMPLEMENTARY_UNIPOLAR_HS_FIX
#define PWM0_PWM2_PWM3_ACTIVE 0x32	/*  +Vdbc  |  -Vdbc  |   NC    |   001  */
#define PWM0_PWM4_PWM5_ACTIVE 0x0E	/*  +Vdbc  |    NC   |  -Vdbc  |   011  */
#define PWM2_PWM4_PWM5_ACTIVE 0x0B	/*    NC   |  +Vdbc  |  -Vdbc  |   010  */
#define PWM0_PWM1_PWM2_ACTIVE 0x38  /*  -Vdbc  |  +Vdbc  |    NC   |   110  */
#define PWM0_PWM1_PWM4_ACTIVE 0x2C	/*  -Vdbc  |    NC   |  +Vdbc  |   100  */
#define PWM2_PWM3_PWM4_ACTIVE 0x23	/*    NC   |  -Vdbc  |  +Vdbc  |   101  */
#endif

/* Prototypes */
void init_PMF(int pwm_modulo, int dutycycle);
void init_GDU(void);

#endif /* PMF_H_ */
