*********************************************************************************
*                                               Copyright (c) Freescale 2015    *
* File Name: MC33PT20000_VFM_65V_6C_EOI_DIAG.dfi                                *
* Current Revision: 1.0                                                         *
* Purpose: PT2000 example - 1 Bank diagnostic + End of Injection + Peak and hold*
*                                                                               *
* REV  AUTHOR           DATE             DESCRIPTION OF CHANGE                  *
* ---  ------           --------         ---------------------                  *
* 1.0  Pierre Calmes    2015/03/19       - initial coding                       *
*                                                                               *
*********************************************************************************

*********************************************************************************
* Freescale reserves  the right to make  changes without  further notice to any *
* product herein to improve  reliability, function,  or design.  Freescale does *
* not  assume  any  liability  arising  out of  the application  or use  of any *
* product, circuit,  or software described herein;  neither does  it convey any *
* license under its patent rights nor the rights of others.  Freescale products *
* are not designed, intended,  or authorized for use as  components  in systems *
* intended for  surgical implant into the body,  or other applications intended *
* to support life,  or for any other  application  in which the failure  of the *
* Freescale product could create a situation where  personal injury or death may*
* occur.  Should Buyer purchase or use Freescale products for any such intended *
* or unauthorized  application,  Buyer shall indemnify and  hold  Freescale and *
* its officers, employees, subsidiaries, affiliates,  and distributors harmless *
* against all claims costs, damages, and expenses, and reasonable attorney  fees*
* arising  out of,  directly or indirectly,  any claim  of personal  injury  or *
* death  associated  with  such unintended  or unauthorized use,  even if  such *
* claim  alleges  that  Freescale   was  negligent   regarding   the  design  or*
* manufacture  of the part.  Freescale and the  Freescale logo  are registered  *
* trademarks of Freescale Ltd.                                                  *
*********************************************************************************
* This microcore will control DCDC and Fuel Pump will check all diagnostics 

* Note: The data that defines the profiles are shared between the two microcores.


#define  HSBatB4 hs7;
#define  LSB4 ls7;

#define  LSDCDC ls8;
*ucore0 cur5 use for Fuel pump
*ucore1 cur6 use for DCDC

 #include "dram3.def";

 

*################## STATUS REGISTER ##############
* This bit must be set to 1 if the Iboost current is never reached during the boost phase
#define PeakErrorBitSR0 b5;
* This bit must be set to 1 the sequencer is currently executing the Automatic interrupt routine
#define AutoIrqBitSR0 b6;
* This bit must be set to 1 the sequencer is currently executing the Idle Diag interrupt routine
#define IdleIrqBitSR0 b7;
* This bit must be set to 1 if start pin stays high longer than 10ms
#define HoldErrorBitSR0 b8;

*################## FLAGS ##############
* This flag is sent to the DCDC sequencer. It must be active for the whole period the boost voltage is used
* When the boost voltage is used, the DCDC must be deactivated
* flag = 0 => boost voltage is used, DCDC must be deactivated
* flag = 1 => boost voltage not used, DCDC can be active
#define BstFlag b0;


*################## CONTROL REGISTER ##############
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define AutoDiagResetBitCR0 b6;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define IdleDiagResetBitCR0 b7;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define PeakResetBitCR0 b5;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define HoldResetBitCR0 b8;

*################## ALU registers  ################
#define IRQ_stat_Reg0 r0;

 *##########################################################################################################################
 *                                      FUEL PUMP CONTROL                                                                  #
 *##########################################################################################################################
 
 
*********************************************************************************************************            
*                                        AUTOMATIC INTERRUPT                                            *            
********************************************************************************************************* 

irq_auto:       stos off off off;                           * Disable drivers
                endiaga diagoff;                            * Disable automatic diagnostic
                stirq low;                                  * Set the low IRQB pin
                stsrb high AutoIrqBitSR0;                   * Set status register bit 6 when automatic diagnosis interrupt trig

auto_waitEnable:jcrr auto_waitEnable AutoDiagResetBitCR0 low;  * the sequencer is stuck here until the bit of the control register is set to '1' b6
                ldjr1 restore0;                             * Load restore to jr1 to do a jump far               
                jmpf jr1;                                   * Jump to restore

                
*********************************************************************************************************            
*                                        SOFTWARE INTERRUPT                                             *            
********************************************************************************************************* 
irq_sw:         stos off off off;                           * Disable drivers
                endiaga diagoff;                            * Disable automatic diagnostic
                stirq low;                                  * Set low the IRQB pin
                                
*######### Check which interrupt occurred PeakErr 2 or HoldError 0 or Idle Diag Fail 1  #################
check_irq:      cp irq IRQ_stat_Reg0;                       * copy the irq status registers to a temp ALU reg
                                                            * This register contains also the sw irq ID
                ldirh 0Ch rst;                              * load MSB in ir reg: 0x0C00 in immediate register, to use as mask for irq status                                        
                and IRQ_stat_Reg0;                          * extract the sw id from irq status register (bits 11-10)
                jarr Peak_waitEN0 all0;                     * if the sw id is 0 => Iboost never reached => go to Boost_waitEN
                                                            * Else => error detected in idle diag=> go to next line => seq stuck until micro write 1 in control register b8                                                                                                              
                ldirh 08h rst;                              * load MSB in ir reg: 0x0800 in immediate register, to use as mask for irq status  
                and IRQ_stat_Reg0;                          * extract the sw id from irq status register (bits 11-10)
                jarr Idle_waitEnable0 all0;                 * if the sw id is 0 => Means IRQ = b01 => Idle diagnostics fails
                                                            * Else => Hold error => go to next line => idle diag fail                                                      

                                                        
Hold_waitEN0:   stsrb high HoldErrorBitSR0;                 * Start pin stays higher longer than 10ms
                jcrr Hold_waitEN0 HoldResetBitCR0 low;      * Wait here until control bit register b4 is write to 1   
                jmpr restore0;
                
Idle_waitEnable0: stsrb high IdleIrqBitSR0;                     * IDle diag fail we set status b7 high to let user know which error occured
                jcrr Idle_waitEnable0 IdleDiagResetBitCR0 low;  * Wait here until control bit register b7 is write to 1 
                jmpr restore0;

                
Peak_waitEN0:  stsrb high PeakErrorBitSR0;              * Iboost never reached, let user know by setting status register bit b5               
                jcrr Peak_waitEN0 PeakResetBitCR0 low;  * Wait here until control bit register b5 is write to 1

                   
                
restore0:       stirq high;                             * Set high IRQB pin
                rstreg all;                             * Reset a) control registers
                                                        *       b) status regsiter
                                                        *       c) err_seq register (status of automatic diagnosis  
                                                        *       d) re-enables irq generation from automatic diagnosis
                iret restart rst;                       * Clear interrupt queue and restart from init phase
                
*********************************************************************************************************            
*                                                INIT PHASE                                             *            
********************************************************************************************************* 
* ### Initialization phase ###
init0:      stgn gain19.25 sssc;                        * Set the gain of the opamp of the current measure block 5 
            ldjr1 eoact0;                               * Load the eoinj line label Code RAM address into the register jr1 
            ldjr2 idle0;                                * Load the idle line label Code RAM address into the register jr2
            stirq high;
            cwef jr1 _start row1;                       * If the start signal goes low, go to eoinj phase       
            
            
*********************************************************************************************************            
*                                                IDLE PHASE                                             *            
*********************************************************************************************************            
* ### Idle phase- the uPC loops here until start signal is present ###              
idle0:      stoc on sssc;
            cwer CheckStart start row2;
WaitLoop:   wait row2;                        * uPC is stuck here for almost the whole idle time
CheckStart: joslr act7_start start7;                    * Perform an actuation 
            jmpr WaitLoop;


*********************************************************************************************************            
*                                                SHORTCUT DEFINITION                                    *            
*********************************************************************************************************
act7_start: dfsct HSBatB4 LSB4 undef;                   * Set the 3 shortcuts: VBAT, VBOOST, LS2
            stoc off sssc;                              * Disable Offset Compensation
            dfcsct dac5h;                               * use current feedback5H, 5H is used because 5L is used by End of Injection on Bank3
            stab 0;                                     * Set the base address to 0 for Injector 1
            jmpr idle_diag1;                            * Jump to launch phase
            
*********************************************************************************************************            
*                                    PRE-ACTUATION DIAG PHASE                                           *            
********************************************************************************************************* 
* All Vds should be high due to bias
* All HSs Vsrc should be high as well
idle_diag1:     bias all on;                            * Enable all biasing structures, kept ON even during actuation
                jocr idle_diag_fail1 _sc1v;             * Error detected if Vds of shortcut1 (HS) is low
                jocr idle_diag_fail1 _sc2v;             * Error detected if Vds of shortcut2 (LS) is low
                jocr idle_diag_fail1 _sc1s;             * Error detected if Vsrc of shortcut1 (HS) is low
                jmpr peak0;                             * Jump to actuation phase if no failure detected in idle phase
               
idle_diag_fail1:reqi 1;                                 * Go to software subroutine is fault detected in idle phase HSBat error

*********************************************************************************************************            
*                                                 PEAK PHASE                                           *            
********************************************************************************************************* 

* ### Launch phase enable boost ###

peak0:      ldcd rst _ofs keep keep Tpeak_tot c1;       * Load the length of the total peak phase in counter 1
            load Ipeak dac56h56n _ofs;                  * Load the peak current threshold in the current DAC
            ldcd rst _ofs keep keep injMaxTPeak c3;     * Start Boost Counter in case ipeak never reached
            
            cwer hold0 tc1 row2;                        * Define Wait Table if actuation longer than injMaxTPeak go to eoinj    
            cwer peak_err0 tc3 row5;                    * If current is nto reached before injMaxTPeak go to eoinj  
            cwer peak_on0 tc2 row3;                     * Jump to peak_on when tc2 reaches end of count
            cwer peak_off0 ocur row4;                   * Jump to peak_off when current is over threshold
            
peak_first: stos on on keep;                            * Turn VBAT on, BOOST off, LS on
            endiags on on on off;                       * Enable diag on VDS LS and HS and on VSRC HS
            wait row1245;                                   * Wait here until injMasTpeak is reach means error occured or Ipeak reached
            
peak_on0:   stos on on keep;                            * Turn VBAT on, BOOST off, LS on
            wait row124;                                * Wait for one of the previously defined conditions  
            
peak_off0:  ldcd rst _ofs keep keep Tpeak_off c2;       * Load in the counter 2 the length of the peak_off phase
            stos off on keep;                           * Turn VBAT off, BOOST off, LS on
            wait row123;                                * Wait for one of the previously defined conditions  
    
peak_err0:  reqi 0;                                     * Go to software subroutine is fault detected in Boost phase, did not reach Ipeak on time 
            

*********************************************************************************************************            
*                                                 HOLD PHASE                                            *            
********************************************************************************************************* 
            
* ### Hold phase on Vbat ###    
hold0:      ldcd rst _ofs keep keep Thold_tot c1;       * Load the length of the total hold phase in counter 2 
            load Ihold dac56h56n _ofs;                  * Load the hold current threshold in the DAC 
            cwer hold_error0 tc1 row2;                  * Jump to eoinj phase when tc1 reaches end of count
            cwer hold_on0 tc2 row3;                     * Jump to hold_on when tc2 reaches end of count
            cwer hold_off0 ocur row4;                   * Jump to hold_off when current is over threshold

hold_off0:  ldcd rst _ofs keep keep Thold_off c2;       * Load the length of the hold_off phase in counter 2
            stos off on keep;                           * Turn VBAT off, BOOST off, LS on
            wait row123;            
            
hold_on0:   stos on on keep;                            * Turn VBAT on, BOOST off, LS on
            wait row124;                                * Wait for one of the previously defined conditions
            
hold_error0: reqi 2;                                    * If Start high is longer than Thold_tot go to sw interrupt

*********************************************************************************************************            
*                                     END OF INJECTION PHASE                                            *            
********************************************************************************************************* 
eoact0:     stos off off keep;                          * Turn VBAT off, LS off
            endiaga diagoff;                            * Disable auto diag
            jmpf jr2;                                   * Jump back to idle phase


    
            
*########################################################################################################       
*                       Channel 3 Ucore 1                                                               #
*########################################################################################################        

*********************************************************************************************************            
*                                            DCDC control in hysteric mode                              *            
*********************************************************************************************************   

* ### Initialization phase ###
init1:      sl56dac dac6;                               * DAC6 is used for DCDC
            stgn gain19.25 sssc;                        * Set the gain of the opamp of the current measure block 56
            dfsct undef ls8 undef;                      * NEW on the PT2000, shortcut2 is used for DCDC auto regulation
            stos keep off keep;
            load Iboost_L dac_sssc _ofs;                * Load Isense56_high current threshold in DAC 56L
            load Iboost_H dac56h56n _ofs;               * Load Isense56_high current threshold in DAC 56H
            stdm null;                                  * Set the boost voltage DAC access mode
            cwer dcdc_idle _f0 row1;                    * Wait table entry for Vboost under Vboost_low threshold condition
            cwer dcdc_on _vb row2;                      * Wait table entry for Vboost under Vboost_low threshold condition
            cwer dcdc_off vb row3;                      * Wait table entry for Vboost over Vboost_high threshold condition

* ### Asynchronous phase ###  
dcdc_on:    load Vboost_H dac56h56n _ofs;               * Load the upper Vboost threshold in vboost_dac register
            stdcctl async;                              * Enable asynchronous mode
            wait row13;                                 * Wait for one of the previously defined conditions

* ### Synchronous phase ### 
dcdc_off:   load Vboost_L dac56h56n _ofs;               * Load the upper Vboost threshold in vboost_dac register
            stdcctl sync;                               * Enable synchronous mode
            stos keep off keep;
            wait row12;                                 * Wait for one of the previously defined conditions
            
* ### Idle phase ### 
dcdc_idle:  stdcctl sync;                               * Enable synchronous mode
            stos keep off keep;
            jocr dcdc_idle _f0;                         * jump to previous line while flag 0 is low
            jmpr dcdc_on;                               * force the DC-DC converter on when flag 0 goes high

* ### End of Channel 3 - uCore0 code ###
