/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY

  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : memory_update_protocol_wildcard_testflash.c
  DEPARTMENT     : AISG
  AUTHOR         : Pradip Singh
  AUTHOR'S EMAIL : pradip.singh@freescale.com
  -----------------------------------------------------------------------------
  REVISION HISTORY
  AUTHOR       			     Date D/M/Y                DESCRIPTION              
  ---------------------- 	----------              --------------------- 
  Pradip Singh (b09147) 	 27/7/2015               Initial Version
  --------------------- 	 ----------             ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE :  Implement C functions for clock configuration. 
  ---------------------------------------------------------------------------*/

/*=============================================================================
  INCLUDE FILES
  ===========================================================================*/
#include "mem_map.h"
/*=============================================================================
  LOCAL CONSTANTS
  ===========================================================================*/

/*=============================================================================
  LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
  ===========================================================================*/
extern struct HSM_CMD_struct HSM_CMD;
/*=============================================================================
  LOCAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTION PROTOTYPES
  ===========================================================================*/

/*=============================================================================
  GLOBAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTIONS
  ===========================================================================*/

/*=============================================================================
  FUNCTION: host_pll_fxosc_setup

  DESCRIPTION:
  This function configures the PLL clock for FXOSC reference clock for MPC5748G

  ARGUMENTS PASSED:
  None
  
  RETURN VALUE:
  None
  
  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/
void host_pll_fxosc_setup()
{  
    MC_CGM.AC5_SC.B.SELCTL = 1;
    /* select FXOSC as reference for PLL */

    /* Configure PLL Dividers - 160MHz from 40Mhz xtal oscillator */
    PLLDIG.PLL0DV.B.RFDPHI1 = 2;
    /* divide by 8 */
    PLLDIG.PLL0DV.B.RFDPHI = 1;
    /* divide by 4 */     
    PLLDIG.PLL0DV.B.PREDIV = 1;
    /* divide by 1 */
    PLLDIG.PLL0DV.B.MFD = 16;
    /* divide by 16 */

    PLLDIG.PLL0FD.B.MFN = 0;
    /* fractional loop division factor = 0 */

    PLLDIG.PLL0CR.B.LOLIE = 1;
    /* loss of lock interrupt enable */
    PLLDIG.PLL0CAL3.R = 0x09C3C000;
    /* denominator of fractional loop division factor*/
    PLLDIG.PLL0FD.B.SMDEN = 1;
    /* sigma delta modulation disabled */

    MC_ME.DRUN_MC.B.XOSCON=1;
    /* crystal on */
    MC_ME.DRUN_MC.B.PLL0ON=1;
    /* Enable the PLL */
    MC_ME.DRUN_MC.B.SYSCLK=2;
    /* Select PLL as sysclk for cores */

    /* enter the drun mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;
    /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;
    /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);
    /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);
    /* Check DRUN mode has been entered */   
    while(PLLDIG.PLL0SR.B.LOCK ==0);
    /* waiting for PLL to lock */
}
/*=============================================================================
  FUNCTION: host_pll_firc_setup

  DESCRIPTION:
  This function configures the PLL clock for FIRC reference clock

  ARGUMENTS PASSED:
  None
  
  RETURN VALUE:
  None
  
  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/

void host_pll_firc_setup()
{  
    /* select FIRC as source for PLL(16MHz)
    MC_CGM.AC5_SC.B.SELCTL = 0;

    /* Configure PLL Dividers - 160MHz from 16Mhz FIRC */
    /* divide by 8 */
    PLLDIG.PLL0DV.B.RFDPHI1 = 2;
    /* divide by 4 */     
    PLLDIG.PLL0DV.B.RFDPHI = 1;
    /* divide by 1 */
    PLLDIG.PLL0DV.B.PREDIV = 1;
    /* divide by 40 */
    PLLDIG.PLL0DV.B.MFD = 40;

    /* fractional loop division factor = 0 */
    PLLDIG.PLL0FD.B.MFN = 0;

    /* Loss-of-lock flag */	
    PLLDIG.PLL0SR.B.LOLF = 1;
    /* loss of lock interrupt enable */
    PLLDIG.PLL0CR.B.LOLIE = 1;
    /* denominator of fractional loop division factor */
    PLLDIG.PLL0CAL3.R = 0x09C3C000;
    /* sigma delta modulation disabled */
    PLLDIG.PLL0FD.B.SMDEN = 1;

    /* FIRC on */
    MC_ME.DRUN_MC.B.IRCON=1;
    /* Enable the PLL */
    MC_ME.DRUN_MC.B.PLL0ON=1;
    /* Select PLL as sysclk for cores */
    MC_ME.DRUN_MC.B.SYSCLK=2;

    /* enter the drun mode, to update the configuration */
    /* Mode & Key */
    MC_ME.MCTL.R = 0x30005AF0;
    /* Mode & Key inverted */
    MC_ME.MCTL.R = 0x3000A50F;
    /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_MTRANS == 1);
    /* Check DRUN mode has been entered */   
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3); 
    /* waiting for PLL to lock */
    while(PLLDIG.PLL0SR.B.LOCK ==0);
}

