#**************************************************************************/
#* FILE NAME: ctr0VLEFlashZ4.s 	           COPYRIGHT (c) Freescale 2015   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* This is a generic base template for init of a VLE Flash Project        */
#=========================================================================*/
#*   This software is part of the "MPC5748G" Host application for HSM sw. */
#*========================================================================*/
#* REV             DATE              DESCRIPTION OF CHANGE                */
#* ---          ----------           ---------------------                */
#* 0.1          07/27/2015             Initial Version                    */
#**************************************************************************/

##------- Reset Configuration Half Word -------------------------------------   
    .section .rcw
    
    .LONG 0x005A0002       # MPC5748G - e200 Core Watchdog OFF, External Boot OFF, VLE ON
    .LONG 0x00000000
    .LONG 0x00000000
    .LONG 0x00000000
    .LONG __start_Z4
    .LONG 0x00000000
    .LONG 0x00000000
    
    .section    ".init", "vax"
    .vle
    .globl      __start_Z4
    
__start_Z4:

   # Initialise core registers
    e_li r0, 0x0
    e_li r1, 0x0
    e_li r2, 0x0
    e_li r3, 0x0
    e_li r4, 0x0
    e_li r5, 0x0
    e_li r6, 0x0
    e_li r7, 0x0
    e_li r8, 0x0
    e_li r9, 0x0
    e_li r10, 0x0
    e_li r11, 0x0
    e_li r12, 0x0
    e_li r13, 0x0
    e_li r14, 0x0
    e_li r15, 0x0
    e_li r16, 0x0
    e_li r17, 0x0
    e_li r18, 0x0
    e_li r19, 0x0
    e_li r20, 0x0
    e_li r21, 0x0
    e_li r22, 0x0
    e_li r23, 0x0
    e_li r24, 0x0
    e_li r25, 0x0
    e_li r26, 0x0
    e_li r27, 0x0
    e_li r28, 0x0
    e_li r29, 0x0
    e_li r30, 0x0
    e_li r31, 0x0

    e_lis     r6,0xFC05
	e_or2i    r6,0x0010
	e_li      r7,0xC520
	se_stw    r7,0x0(r6)
	e_li      r7,0xD928
	se_stw    r7,0x0(r6) # Disengage soft-lock

     e_lis     r6,0xFC05
	e_or2i    r6,0x0000
	e_lis     r7,0x7f00
	e_or2i    r7,0x10A
	se_stw    r7,0x0(r6) # WEN = 0

   e_lis     r6,0xFC05
	e_or2i    r6,0x4010
	e_li      r7,0xC520
	se_stw    r7,0x0(r6)
	e_li      r7,0xD928
	se_stw    r7,0x0(r6) # Disengage soft-lock


     e_lis     r6,0xFC05
	e_or2i    r6,0x4000
	e_lis     r7,0x7f00
	e_or2i    r7,0x10A
	se_stw    r7,0x0(r6) # WEN = 0

   e_lis     r6,0xFC05
	e_or2i    r6,0x8010
	e_li      r7,0xC520
	se_stw    r7,0x0(r6)
	e_li      r7,0xD928
	se_stw    r7,0x0(r6) # Disengage soft-lock


     e_lis     r6,0xFC05
	e_or2i    r6,0x8000
	e_lis     r7,0x7f00
	e_or2i    r7,0x10A
	se_stw    r7,0x0(r6) # WEN = 0
	
 # init count register
 se_li   r0,0
 # init Special Purpose Registers (SPR)
 mtspr   ctr, r0
 mtspr   lr, r0
 mtcr    r0
 mtsrr0  r0
 mtsrr1  r0
 mtcsrr0 r0
 mtcsrr1 r0

 #### Enable Exception Recognition
  mfmsr   r3
  e_or2i  r3,0x1200
  mtmsr   r3
	
##------- Initialise SRAM ECC -----------------------------------------------

  e_lis      r4,_CORE0_SRAM_ADDR@h      # base address of the RAM
  e_or2i     r4,_CORE0_SRAM_ADDR@l

  e_lis      r2,_SRAM_SIZE@h
  e_or2i     r2,_SRAM_SIZE@l
  e_srwi     r2,r2,6             # divide by 64
  mtctr      r2
  
init_sram_loop:
  e_stmw     r16,0(r4)           # write all 16 registers to SRAM
  e_add2i.   r4,64               # inc the ram ptr
  e_bdnz     init_sram_loop      # loop for entire SRAM

	e_lis		r11, __SP_INIT@h    # Initialize stack pointer r1 to
	e_or2i		r11, __SP_INIT@l    # value in linker command file. 
	mr		r1,r11			

	e_lis		r13, _SDA_BASE_@h   # Initialize r13 to sdata base
	e_or2i		r13, _SDA_BASE_@l   # (provided by linker).    

	e_lis		r2, _SDA2_BASE_@h   # Initialize r2 to sdata2 base
	e_or2i		r2, _SDA2_BASE_@l   # (provided by linker).
	
	e_addi		r0,r0,0				# Clear r0.
	e_stwu		r0,-64(r1)			# Terminate stack.
##--------- Initialised Data - ".data" --------------------------------------
DATACOPY:
    e_lis       r9, __DATA_SIZE@h      # Load upper SRAM load size (# of bytes) into R9
    e_or2i      r9, __DATA_SIZE@l       # Load lower SRAM load size into R9                                     
    e_cmp16i    r9,0                    # Compare to see if equal to 0                                  
    e_beq       ROMCPYEND               # Exit cfg_ROMCPY if size is zero (no data to initialise)
                                        
    mtctr       r9                      # Store no. of bytes to be moved in counter
                                        
    e_lis       r10, __DATA_ROM_ADDR@h  # Load address of first SRAM load into R10
    e_or2i      r10, __DATA_ROM_ADDR@l  # Load lower address of SRAM load into R10
    e_subi      r10,r10, 1              # Decrement address to prepare for ROMCPYLOOP

    e_lis       r5, __DATA_SRAM_ADDR@h  # Load upper SRAM address into R5 (from linker file)
    e_or2i      r5, __DATA_SRAM_ADDR@l  # Load lower SRAM address into R5 (from linker file)
    e_subi      r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

DATACPYLOOP:
    e_lbzu      r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
    e_stbu      r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
    e_bdnz      DATACPYLOOP             # Branch if more bytes to load from ROM

ROMCPYEND:

##---------------------------------------------------------------------------       
    e_lis       sp, __SP_INIT@h     # Initialize stack pointer r1 to
    e_or2i      sp, __SP_INIT@l     # value in linker command file.
    
##--------- Start of Main Code-----------------------------------------------
	e_bl main
##---------------------------------------------------------------------------    
