/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY

  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : verifymac_testflash.c
  DEPARTMENT     : AISG
  -----------------------------------------------------------------------------
  REVISION HISTORY
            Date D/M/Y                     DESCRIPTION              
            ----------                 ---------------------
            27/7/2015                    Initial Version
       --------------------- 	       ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE : To verify the verify mac command. 
  ---------------------------------------------------------------------------*/

/*=============================================================================
  INCLUDE FILES
  ===========================================================================*/
#include "common.h"
#include "hsm.h"
/*=============================================================================
  LOCAL CONSTANTS
  ===========================================================================*/
#pragma alignvar (4)
uint8_t cmacKey[16] = {
    0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6,
    0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C};
#pragma alignvar (4)
uint8_t messageLength[8] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80};

#pragma alignvar (4)
uint8_t cmacMessage[16] = {
    0x6B, 0xC1, 0xBE, 0xE2, 0x2E, 0x40, 0x9F, 0x96,
    0xE9, 0x3D, 0x7E, 0x11, 0x73, 0x93, 0x17, 0x2A};

#pragma alignvar (4)
uint8_t mac[16];

#pragma alignvar (4)
uint8_t macRef[16] = {
    0x07, 0x0A, 0x16, 0xB4, 0x6B, 0x4D, 0x41, 0x44,
    0xF7, 0x9B, 0xDD, 0x9D, 0xD0, 0x4A, 0x28, 0x7C};

/*=============================================================================
  LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
  ===========================================================================*/
extern struct HSM_CMD_struct HSM_CMD;
/*=============================================================================
  LOCAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTION PROTOTYPES
  ===========================================================================*/
extern void host_pll_fxosc_setup();
extern void host_pll_firc_setup();
/*=============================================================================
  GLOBAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTIONS
  ===========================================================================*/
void generatemac_test();
/*=============================================================================
  FUNCTION: verifymac_test

  DESCRIPTION:
  This function is for verifying verify_mac command 

  ARGUMENTS PASSED:
  None
  
  RETURN VALUE:
  None
  
  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/
void generatemac_test(void)
{
    uint32_t messageLengthVerifStat = 0x7F;
    uint32_t error1 = 0;
    uint32_t i=0;

/* load cmacKey in RAM Key */
    while(HSM.HSM2HTS.B.BUSY == 1);
    /* cmacKey is loaded to RAM KEY */
    HSM_load_plain_key((uint32_t) &cmacKey);									
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  										
    hsm_done();

/* verify mac */
    /* prepares data structure for verify mac command */
    HSM_generate_mac((uint32_t)&messageLength,
	    (uint32_t)&cmacMessage,
	    (uint32_t)&mac);  
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  										
    hsm_done();

    for(i=0;i<16;i++)
    {
	if(mac[i]!=macRef[i])
	{
	    while(1);
	}
    }  
}

/*=============================================================================
  FUNCTION: main

  DESCRIPTION:
  This is the main function/entry point for the application 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/

void main(void)
{   
#ifdef FXOSCPLLSRC
    host_pll_fxosc_setup();
#else
    host_pll_firc_setup();

#endif
    generatemac_test();
    while(1);
}

