/*
 * S12ZVMEVB.h
 *
 *  Created on: Aug 28, 2013
 *      Author: B18253
 */
#include "derivative.h" /* include peripheral declarations */


#ifndef S12ZVMEVB_H_
#define S12ZVMEVB_H_

/* Function Prototypes */
void initCPMU(void);
void initGPIO(void);
void initSCI(void);
void initTIM(void);
void initADC(void);

/* EVB definitions */
#define LED1		PTS_PTS4
#define LED2		PTS_PTS5

#define BUTTON1		PTP_PTP1
#define BUTTON2		PTP_PTP2

#define HALL_SUPPLY	PTP_PTP0
#define HALL_A		PTT_PTT1
#define HALL_B		PTT_PTT2
#define HALL_C		PTT_PTT3

#define POT1		PTADL_PTADL4

#define DDRP_CONFIG		0x01		/* Port P pin 0 as output (EVDD) */
#define DDRS_CONFIG		0x30		/* Port S pins 4 & 5 are outputs */
#define MODRR0_CONFIG	0x08		/* SCI1RR = 1: port SCI1 available on pins PS2 and PS3 */
#define MODRR2_CONFIG	0x02		/* TIM0 input capture channel 1 is connected to logically XORed input signals of pins PT3-1 */


#define CPMU_REFDIV		3			/* 4MHz osc. to 1 MHz reference clock (fref) */
#define CPMU_SYNDIV		24			/* 24 for 50 MHz VCO output [fvco = 2 * fref * (SYNDIV + 1)] */
#define	CPMU_POSTDIV	1			/* 1 for 25MHz PLL frequency (fpll = fvco / (POSTDIV + 1) */
#define CPMU_REFFRQ 	0			/* 0 for reference clock frequency in range 1 to 2 MHz */
#define	CPMU_VCOFRQ		1			/* 1 for VCO output frequency in range 48 to 80 MHz */
									/* bus clock frequency is 12.5MHz */

#define	SCI_BAUDRATE	1302		/* fbus = 12.5MHz, baud_rate = 9600 : fbus/baud_rate = 12.5MHz / 9600 = 1302 */  

#define ADC_PRESCALER	0			/* fADC = fbus / (2* (PRS +1)) = 6.25MHz */ 		

#define TIM_PRESCALER	7 			/* TIMER module time base = fbus / 128 = 97.656KHz */	
#define TIM_CH0_PERIOD	9800		/* Number of bus clock cycles in 100 milliseconds */


#endif /* S12ZVMEVB_H_ */
