/* ###################################################################
**     Filename    : main.c
**     Project     : ramISR
**     Processor   : MC56F82748VLH
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2014-10-23, 18:00, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Pins1.h"
#include "GPIOE0.h"
#include "BitIoLdd1.h"
#include "TU1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Init_Config.h"
#include "PDD_Includes.h"

#include "pclib.h"

volatile Frac16 pf16DesiredValue;
volatile Frac16 pf16MeasuredValue;
volatile Frac16 pf16Error;
volatile Frac16 pf16OutControlLoop;

/* Controller parameters */
PCLIB_CONTROL_PIANDLPFILTER_PARAMS_T pudtControllerParam;

const Int16 testArray[] = { /* test array for section .p_flash_ROM_data */
0 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 , 9 , 10, 11, 12, 13, 14, 15,
};

void main(void)
{
	/* Write your local variable definition here */

	/*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
	PE_low_level_init();
	/*** End of Processor Expert internal initialization.                    ***/
	//GPIOE_PER |= 2; //enable PWMA_0A pin

	/* Write your code here */

	/* Controller parameters initialization */ 
	pudtControllerParam.f16Coeff_b0 = FRAC16(0.5); 
	pudtControllerParam.f16Coeff_b1 = FRAC16(0.032);
	pudtControllerParam.f16Coeff_b2 = FRAC16(0.3);
	pudtControllerParam.f16Coeff_a1 = FRAC16(-0.1);
	pudtControllerParam.f16Coeff_a2 = FRAC16(0.2);
	pudtControllerParam.f16Delay_x1 = FRAC16(0.2); pudtControllerParam.f16Delay_x2 = FRAC16(0.4);
	pudtControllerParam.f16Delay_y1 = FRAC16(0.3); pudtControllerParam.f16Delay_y2 = FRAC16(0.5);
	/* Initializing Error */
	pf16Error = 0;
	/* Initialization of control loop output */
	pf16OutControlLoop = 0;
	/* Desired value initialization */
	pf16DesiredValue = FRAC16(0.5);
	/* Measured value initialization */
	pf16MeasuredValue = 0;

	for(;;) {
	  GPIOA_IESR = testArray[0]; /* prevent deadstrip of testArray */
	}
}

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
