/* ###################################################################
**     Filename    : Events.c
**     Project     : ramISR
**     Processor   : MC56F82748VLH
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2014-10-23, 18:00, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file Events.c
** @version 01.03
** @brief
**         This is user's event module.
**         Put your event handler code here.
*/         
/*!
**  @addtogroup Events_module Events module documentation
**  @{
*/         
/* MODULE Events */

#include "Init_Config.h"
#include "Cpu.h"
#include "Events.h"
#include "pclib.h"

extern Frac16 pf16MeasuredValue;
extern Frac16 pf16DesiredValue;
extern Frac16 pf16Error;
extern Frac16 pf16OutControlLoop;
extern PCLIB_CONTROL_PIANDLPFILTER_PARAMS_T pudtControllerParam;

/* User includes (#include below this line is not maintained by Processor Expert) */


#pragma interrupt saveall 
void PIT_100k_OnInterrupt(void)
{
	static pf16ErrorK;
	PWMA_SM0STS |= 1<<12; // clear PWMA SM0 Reload Flag

  /* Write your code here ... */
	GPIOE_DR |= 1;
	pf16MeasuredValue = ADC_RSLT0;
	pf16ErrorK = pf16DesiredValue - pf16MeasuredValue;/* Error calculation */
	pf16OutControlLoop = PCLIB_ControllerPIANDLPFILTERAsm(pf16Error, &pudtControllerParam);
	GPIOE_DR = 0;
}


/* END Events */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
