## ###################################################################
##
##     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
##
##     Filename  : FLASH_SDM.cmd
##
##     Project   : ramISR
##
##     Processor : MC56F82748VLH
##
##     Compiler  : CodeWarrior DSP C Compiler
##
##     Date/Time : 2014-10-29, 21:09, # CodeGen: 35
##
##     Abstract  :
##
##     This file is used by the linker. It describes files to be linked,
##     memory ranges, stack size, etc. For detailed description about linker
##     command files see CodeWarrior documentation. This file is generated by default.
##     You can switch off generation by setting the property "Generate linker file = no"
##     in the "Build options" tab of the CPU bean and then modify this file as needed.
##
##     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
##     All Rights Reserved.
##     http: www.freescale.com
##     mail: support@freescale.com
##
## ###################################################################

MEMORY {
        .p_Interrupts     (RWX): ORIGIN = 0x00000000, LENGTH = 0x000000DE
        .p_reserved_FCF   (RWX): ORIGIN = 0x00000200, LENGTH = 0x00000008
        .p_Code           (RWX): ORIGIN = 0x00000208, LENGTH = 0x00007AF8 #PDB mapped flash (pFlash)
        .p_ramFuncCode    (RWX): ORIGIN = 0x00007D00, LENGTH = 0x00000300 #pFlash subarea for ram-code storage
        .p_ramFuncSpace   (RWX): ORIGIN = 0x0000F000, LENGTH = 0x00001000 #PDB mapped 8Kb RAM
		#------------------------------------------------------------------------------------------
		#--   Flash area start from 0x0208(flash_start) with length 0x7DF8(flash_length)         --
		#--   assume length of .p_ramFuncCode equals code_length                                 --
		#--   the setting for .p_Code and .p_ramFuncCode lists below                             --
		#--   .p_Code        (RWX): ORIGIN=flash_start      , LENGTH=flash_length - code_length  --
		#--   .p_ramFuncCode (RWX): ORIGIN=flash_start+LENGTH(.p_Code), LENGTH=code_length       --
		#------------------------------------------------------------------------------------------

        # p_flash_ROM_data mirrors x_Data, mapping to origin and length
        # the "X" flag in "RX" tells the debugger flash p-memory.
        # the p-memory flash is directed to the address determined by AT
        # in the data_in_p_flash_ROM section definition
        .p_flash_ROM_data (RX) : ORIGIN = 0x00000000, LENGTH = 0x00001000
        .x_Data           (RW) : ORIGIN = 0x00000000, LENGTH = 0x00001000
        .x_internal_ROM   (RW) : ORIGIN = 0x000040DE, LENGTH = 0x00000122

        # I/O registers area for on-chip peripherals
        .x_Peripherals    (RW) : ORIGIN = 0xC000, LENGTH = 0
}

KEEP_SECTION { interrupt_vectors.text }
KEEP_SECTION { reserved_FCF.text }

SECTIONS {
        .at_of_p_ramFuncSpace :
		{
		  WRITEH(0X2); # dummy insertion, prevent warning 
		  __pROM_data_start = .;
		} > .p_ramFuncCode

        # AT sets the download address
        # the download stashes the data just after the program code
        # as determined by our saved pROM data start variable
        .data_in_p_flash_ROM : AT(__pROM_data_start)
        {
              # the data sections flashed to pROM
              # save data start so we can copy data later to xRAM

              __xRAM_data_start = .;
              # .data sections
              * (.const.data.char)         # used if "Emit Separate Char Data Section" enabled
              * (.const.data)

              * (fp_state.data)
              * (rtlib.data)
              * (.data.char)               # used if "Emit Separate Char Data Section" enabled
              * (.data)

              # save data end and calculate data block size
              . = ALIGN(2);
              __xRAM_data_end = .;
              __data_size = __xRAM_data_end - __xRAM_data_start;
              __ramFunc_code_start = __pROM_data_start + __data_size;
        } > .p_flash_ROM_data          # this section is designated as p-memory
                                       # with X flag in the memory map
                                       # the start address and length map to
                                       # actual internal xRAM

        .ramFunctions : AT(__ramFunc_code_start)                       
        {
          . = . + __data_size;

          F_p_ramfunctions_start = .;                                   

          #---- select function "PIT_100k_OnInterrupt()"                ----# 
          OBJECT(FPIT_100k_OnInterrupt, Events_c.obj)
          #---- select library  "PCLIB_ControllerPIANDLPFILTERFAsm()"   ----# 
          OBJECT(FPCLIB_ControllerPIANDLPFILTERFAsm, 56800Ex_PCLIB.lib)
          #---- routine of INTERRUPT_SAVEALL, INTERRUPT_RESTOREALL      ----# 
          * (rtlib.text)                                                

          . = ALIGN(2);                                                 
          F_p_ramfunctions_end = .;                                    

          __ramFunctions_size = F_p_ramfunctions_end - F_p_ramfunctions_start;
          __ramFunctions_LdAddr = __ramFunc_code_start + __data_size;
        
        } > .p_ramFuncSpace                                           


        .interrupt_vectors :
        {
          F_vector_addr = .;
          # interrupt vectors
          * (interrupt_vectors.text)
        } > .p_Interrupts

        .reserved_FCF :
        {
          F_FCF_addr = .;
          # reserved FCF - Flash Configuration Field
          * (reserved_FCF.text)
        } > .p_reserved_FCF

        .ApplicationCode :
        {

              F_Pcode_start_addr = .;

              # .text sections
              * (.text)
              * (rtlib.text)
              * (startup.text)
              * (fp_engine.text)
              * (ll_engine.text)
              * (user.text)
              * (.data.pmem)

              F_Pcode_end_addr = .;

              # save address where for the data start in pROM
              . = ALIGN(2);
              #__pROM_data_start = .;

        } > .p_Code


        .ApplicationData :
        {
              # save space for the pROM data copy
              . = __xRAM_data_start + __data_size + __ramFunctions_size;

              # .bss sections
              * (rtlib.bss.lo)
              * (rtlib.bss)
              . = ALIGN(4);
              F_Xbss_start_addr = .;
              _START_BSS = .;
              * (.bss.char)         # used if "Emit Separate Char Data Section" enabled
              * (.bss)
              . = ALIGN(2);         # used to ensure proper functionality of the zeroBSS hardware loop utility
              _END_BSS   = .;
              F_Xbss_length = _END_BSS - _START_BSS;

              /* Setup the HEAP address */
              . = ALIGN(4);
              _HEAP_ADDR = .;
              _HEAP_SIZE = 0x00000100;
              _HEAP_END = _HEAP_ADDR + _HEAP_SIZE;
              . = _HEAP_END;

              /* SETUP the STACK address */
              _min_stack_size = 0x00000200;
              _stack_addr = _HEAP_END;
              _stack_end  = _stack_addr + _min_stack_size;
              . = _stack_end;

              /* EXPORT HEAP and STACK runtime to libraries */
              F_heap_addr   = _HEAP_ADDR;
              F_heap_end    = _HEAP_END;
              F_Lstack_addr = _HEAP_END;
              F_StackAddr = _HEAP_END;
              F_StackEndAddr = _stack_end - 1;

              # runtime code __init_sections uses these globals:

              F_Ldata_size     = __data_size;
              F_Ldata_RAM_addr = __xRAM_data_start;
              F_Ldata_ROM_addr = __pROM_data_start;

              F_Livt_size     = __ramFunctions_size;
              F_Livt_RAM_addr = F_p_ramfunctions_start;
              F_Livt_ROM_addr = __ramFunctions_LdAddr;

              F_xROM_to_xRAM   = 0x0000;
              F_pROM_to_xRAM   = 0x0001;
              F_pROM_to_pRAM   = 0x0001;

              F_start_bss   = _START_BSS;
              F_end_bss     = _END_BSS;

              __DATA_END=.;

        } > .x_Data

}
