/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES* LOSS OF USE, DATA, OR PROFITS* OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file     PCLIB_Controller2P2ZAsm.h
*
* @author    B37570 , B36378
* 
* @version   1.0.00.0
* 
* @date      Jan-26-2011
* 			Updated September 2013
* 
* @brief     2P2Z Control algorithm implemented in assembler
*
*******************************************************************************
*
* 2P2Z  algorithm implemented in assembler.
*
******************************************************************************/

#ifndef __PCLIB_CONTROL_2P2Z_ASM_H__
#define __PCLIB_CONTROL_2P2Z_ASM_H__


/******************************************************************************
* Includes
******************************************************************************/

#include "56800E_types.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/

#define PCLIB_Controller2P2ZAsm(f16Error, pudtControlStruct)		\
        PCLIB_Controller2P2ZFAsm(f16Error, pudtControlStruct)


/* Digital parameters */
typedef struct _pclib_control_2p2z_params_t
{ 
	Frac16 f16Coeff_b0;
	Frac16 f16Coeff_b1;
	Frac16 f16Coeff_b2;
	Frac16 f16Coeff_a1;
	Frac16 f16Coeff_a2;
	Frac16 f16Delay_x1;
	Frac16 f16Delay_x2;
	Frac16 f16Delay_y1;
	Frac16 f16Delay_y2;
} PCLIB_CONTROL_2P2Z_PARAMS_T;  

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/***************************************************************************//*!
*
* Digital Control Equation:
* 
* @brief:
* 
* 	The s-domain transfer function equation for 2-pole 2-zero control law is
*
*
*	y[s]	 (s-Z1)*(s-Z2)
*	---- =  ----------------
*	x[s]	 (s-P1)*(s-P2)
*
*	
*	y[s] is output and x[s] is input to the system. This control law has two 
*	poles P1, and P2 and 2 zeros Z1, and Z2. The value or the placement of these
*	poles and zeros in the bode plot decide the stability and performance of 
*	the control loop and system.
*	  
*  z-domain controller Gc(z) at Ts sampling frequency using tustin method.
*
*	y[n]	 (b2*z^-2 + b1*z^-1 + b0)
*	---- = ------------------------------
*	x[n]	  (1-a2*z^-2 - a1*z^-1)
*
*	y[n] - a1*y[n]*z^-1 - a2y[n]*z^-2 = b0*x[n] + b1*x[n]*z^-1 + b2*x[n]*z^-2
*
*	y[n]	  = y[n]			Present output 
*	y[n]*z^-1 = y[n-1] 			Previous control output
*	y[n]*z^-2 = y[n-2]			Previous to previous output
*	x[n]	  = x[n]			Present error
*	x[n]*z^-1 = x[n-1]			Previous error
*	x[n]*z^-2 = x[n-2]			Previous to previous error
*	
*	b0, b1, b2, a1, and a2 are the control coefficient and are function of 
*	Z1, Z2, P1, P2 and sampling frequency Ts. 
*	
*	y[n] = a2*y[n-2] + a1*y[n-1] + b2*x[n-2] + b1*x[n-1] + b0*x[n] 
*	
*	
* Software implementation:
*	
* @brief    This assembly macro implements a second order control law using a 
*           2-pole, 2-zero control algorithm. The above mentioned previous and previous to
*			previous output are known as delay variables and it is stored in buffer.
*           
* @param    f16Error
*           This error defined as f16Error = f16Required - f16Actual
*			It is user input and user has to make sure error is defined as 
*			fraction and its value should be -1<= f16Error =<1
*
* @param    ptr
*            PCLIB_CONTROL_2P2Z_PARAMS_T * const pudtControlSturct
*           - Pointer to a structure of 2P2Z controller parameters
*             the PCLIB_CONTROL_2P2Z_PARAMS_T data type is defined in the header
*			  file GFLIB_Controller2P2ZAsm.h 
*			  
*			
*			- control coefficients (b0, b1, b2, a1, and a2)
*				 f16Coeff_b0;
*				 f16Coeff_b1;
*				 f16Coeff_b2;
*				 f16Coeff_a1;
*				 f16Coeff_a2;
*			  All the control coefficient value are treated as fraction number
*			  hence user needs to make sure control coefficients digital numbers
*			  are in fraction and lies in between -1 <= control coefficient <=1
*			  If the control coefficient is more than one, then it needs to be
*			  Normalized to highest value.
*			  
*			 
*			- Delay variables (x(n-1), x(n-2), y(n-1), and y(n-2)
*			f16Delay_x1;
*			f16Delay_x2;
*			f16Delay_y1;
*			f16Delay_y2;
*			 buffers stores control delay.
*			  The previous values of control output and its errors are known as
*			  Delay variables and used in calculating the present control output.The Delay 
*			  buffer values should be initialised to zero at power on reset. This is to 
*			  make sure the control loop calculation should not have any 
*			  undefined parameters or variable values even at very first 
*			  execution of 2P2Z digital control loop library. 
*			  
*
* @return   Y0 - y(n) 
*           1) action value y(n) in range [-1,1]
*		
* @remarks 	-It is Saturation dependent. 
* 			For best results,
*			Disable saturation before calling the function.
*
*           -Difference equation:
*			PCLIB_Controller2P2Z output is not saturated/limited to any limit
*			values. Hence user needs to do the saturation/clamping out side. 
*			
*****************************************************************************/ 
asm Frac16 PCLIB_Controller2P2ZFAsm(
	Frac16 f16Error, 
	PCLIB_CONTROL_2P2Z_PARAMS_T * const pudtControlStruct);
	

/******************************************************************************
* Inline functions
******************************************************************************/	
#endif /* __PCLIB_CONTROL_2P2Z_ASM_H__ */

