/**
  Copyright (c) 2010 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Szk_ff_Power_Management.h
  \brief    	
  \author   	Freescale Semiconductor
  \author         SASD Automotive     
  \author   	R11515
  \version    
  \date     	
  \warning    (If needed)

  * History:
  
*/

#ifndef _SZK_FF_TPM_H
#define _SZK_FF_TPM_H

/*
 **************************************************************
 * Defines, Macros and Typedefs 
 **************************************************************/
/* Constant Macros */
#define TPM_BUSCLK                     ((UINT8)1u)
#define TPM_EXTERNAL                   ((UINT8)3u) /* External = RFM Crystal */

/* Function Macros */
#define macroTriggerTPMStart() (TPM1SC_CLKSA = SET)

/* Enums */

/* TypeDefs */

/*
 **************************************************************
 * Declarations 
 **************************************************************/
/* Extern */

/* Globals */

/* Static Globals */

/*
 **************************************************************
 * Function Prototypes 
 **************************************************************/
 /*
 *******************************************************************************
 *
 * Function:          vfnConfigureTPMWait()
 *
 */
/*!
 * \brief    This function configures the TPM to wait x number of intervals.
 *           Since its intended use is inside u8fnPreChargeVReg, timing interval
 *           does not meet TPM interval (DUT is going in and out of STOP4 mode).
 * \param    u8Interval210usec - number of intervals to wait
 * \return   void
 *
 *****************************************************************************/
void vfnConfigureTPMWait(UINT8 u8Interval210usec);
/*
 *******************************************************************************
 *
 * Function:          u16fnDxLFOTimerCalc()
 *
 */
/*!
 * \brief    This function returns the amount of timer counts elapsed from 
 *           the initial trigger to the second one. It configures the TPM for
 *           input capture utilizing LFO as trigger, and Dx as clock. 
 * \param    u8TPM1C0SCSettings: It allows the calling function to set ELS0 to 
 *           either trigger on raising, falling, or raising and falling edges.
 * \return   timer count between trigger events (either 500usec or 1msec appart).
 *
 *****************************************************************************/
UINT16 u16fnDxLFOTimerCalc(UINT8 u8TPM1C0SCSettings);

/*
 *******************************************************************************
 *
 * Function:          vfnWaitMSec()
 *
 */
/*!
 * \brief    This function waits x number of msec using TPM.
 * \param    u8MSec - number of msec to wait
 * \return   void
 *
 *****************************************************************************/
void vfnWaitMSec(UINT8 u8MSec);
#endif /* _FILENAME_H */
/*
 ******************************************************************************
 *
 *  End of file.
 *
 ******************************************************************************
 */