/*************************************************************************//**
 * @file mcu_init_flash.c                                                    
 * @copyright Freescale 2014 All Rights Reserved                             
 * @version 1.2                                                              
 * @brief This file provides functions to initialize MPC5746M MCU.
 * @date 12-Oct-12
 * @author C.Hillier                                                        */
/*===========================================================================*
 * UPDATE HISTORY                                                            *
 * REV      AUTHOR      DATE       	DESCRIPTION OF CHANGE                    *
 * ---   -----------  ---------    	---------------------                    * 
 * 1.0   D.McMenamin  13-Sep-12     Initial Public Release                   *
 *                                                                           *
 * 1.1   C.Hillier    24-Oct-12     Adapted for Matterhorn                   *
 *                                                                           *
 * 1.2   C.Hillier    14-Oct-12     Build for tester (50MHz/40MHz options)   *
 *                                                                           *
 *===========================================================================*
 * COPYRIGHT:                                                                *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby        *
 *  granted a copyright license to use, modify, and distribute the           *
 *  SOFTWARE so long as this entire notice is retained without alteration    *
 *  in any modified and/or redistributed versions, and that such modified    *
 *  versions are clearly identified as such. No licenses are granted by      *
 *  implication, estoppel or otherwise under any patentsor trademarks        *
 *  of Freescale Semiconductor, Inc. This software is provided on an         *
 *  "AS IS" basis and without warranty.                                      *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, Freescale             *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,       *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A         *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD     *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY        *
 *  ACCOMPANYING WRITTEN MATERIALS.                                          *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, IN NO EVENT           *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER       *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,     *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER            *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.     *
 *                                                                           *
 *  Freescale Semiconductor assumes no responsibility for the                *
 *  maintenance and support of this software                                 *
 *                                                                           *
 ****************************************************************************/

#include "project.h"
#include "Zipwire.h"

#define XOSC_40MHZ 1

// define mc_mode_init as a section
// see also linker file
#pragma ghs section text=".mc_mode_init"
#pragma ghs section data="mc_mode_init_data"

/**************************************************************************//**
 * @brief MPC5777M Matterhorn PLL and Clock Configuration                     
 * @brief Configure the Mode and Clock Tree                                  */
/******************************************************************************/
void MC_MODE_INIT(void){

   MC_RGM.DES.R = 0xFFFF;
   MC_RGM.FES.R = 0xFFFF;
   MC_ME.ME.R = 0x000005FF;

    
/* ^^^^^^^ Set up peripheral run modes ^^^^^^^ */
   /* Enable the modes Required */
   MC_ME.ME.R = 0x0000800F;

   /* Add ME.PCTL[x].R initializations here */

   /* Setting RUN Configuration Register ME_RUN_PC[0] */
   MC_ME.RUN_PC[0].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[1].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[2].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[3].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[4].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[5].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[6].R=0x000000FE;              /* Peripheral ON in every mode */
   MC_ME.RUN_PC[7].R=0x000000FE;              /* Peripheral ON in every mode */

   
/*! Configure System clock dividers */
/*! Full speed Core 0 / 1 = 300MHz.  PLL1 = 600MHz.   */
/*! ~~~~~~~~~ */
/*! These settings do not agree with the recommendation in ERR004242.  Specifically,
 "In addition, software must take extra care to ensure not only that the final
 system clock divider values are compatible but also that the intermediate values are compatible.
 In order to simplify this, it is recommended that only simple division factor relationships
 are used (e.g., powers of 2 if possible)... */
/*! Powers of 2 are not possible since we have to support 300MHz, 200MHz based on the same
 PLL clock.   */
/*! ~~~~~~~~~ */   

 

   /*! Enable and configure Aux clocks */
   MC_CGM.AC0_SC.B.SELCTL=2;        /*! PLL0 PHI for Aux Clock 0 */

   MC_CGM.AC0_DC0.R=0x80040000;     /*! Aux Clock 0 divider 0 (peripheral clock) */
                                      /*! -> Divide by = 4 + 1.  400MHz/5 = 80MHz */
   MC_CGM.AC0_DC1.R=0x80180000;     /*! Aux Clock 0 divider 1 (SDADC clock) */
                                      /*! -> Divide by 24 + 1.  400MHz / 25 = 16MHz */   
   MC_CGM.AC0_DC2.R=0x801B0000;     /*! Aux Clock 0 divider 2 (SARADC clock) */
                                      /*! -> Divide by 24 + 1.  400MHz / 28 = 14.6MHz */
   MC_CGM.AC0_DC3.R=0x80030000;     /*! Aux Clock 0 divider 3 (DSPI_CLK0) */
                                      /*! -> Divide by 3 + 1.  400MHz / 4 = 100MHz */   
   MC_CGM.AC0_DC4.R=0x80030000;     /*! Aux Clock 0 divider 4 (DSPI_CLK1/LIN_CLK) */
                                      /*! -> Divide by 3 + 1.  400MHz / 4 = 100MHz */

   //LFAST DIVIDER COMES FROM AUX CLOCK SELECTOR 11
   #if(CONFIGURED_AS_MASTER)
   //MC_CGM.AC1_SC.B.SELCTL=5;	      /*! Input from LFAST-SysClk Pin */
   //No divider, as we want the clock exactly as it is
   MC_CGM.AC1_SC.B.SELCTL=5;	      /*! PLL0 PHI for Aux Clock 0 */
   MC_CGM.AC1_DC0.R=0x80000000;     
   #else
   MC_CGM.AC1_SC.B.SELCTL=2;	      /*! PLL0 PHI for Aux Clock 0 */
   MC_CGM.AC1_DC0.R=0x80130000;     /*! Aux Clock 1 divider 0 (LFAST) */
   #endif
   MC_CGM.AC2_DC0.R=0x80090000;     /*! Aux Clock 2 divider 0 (FlexRay) */
                                      /*! -> Divide by 9 + 1.  400MHz / 10 = 40MHz */
   MC_CGM.AC2_DC1.R=0x80090000;     /*! Aux Clock 2 divider 1 (SENT) */
                                      /*! -> Divide by 9 + 1.  400MHz / 10 = 40MHz */
   MC_CGM.AC5_DC0.R=0x80090000;         /*! Aux Clock 5 divider 0 (PSI5) */
                                        /*! -> Divide by 9 + 1.  400MHz / 10 = 40MHz */
   MC_CGM.AC5_DC1.R=0x80090000;         /*! Aux Clock 5 divider 1 (PSI5) */
                                        /*! -> Divide by 9 + 1.  400MHz / 10 = 40MHz */
   MC_CGM.AC5_DC2.R=0x80090000;         /*! Aux Clock 5 divider 2 (PSI5) */
                                        /*! -> Divide by 9 + 1.  400MHz / 10 = 40MHz */

   /*! CAN Clock Runs from XOSC by Default */
   MC_CGM.AC8_DC0.R=0x80070000;    /* Aux Clock 8 divider 0 (CAN Clock) */
                                   /* CAN Clock Clock Divide by 8 */

   MC_CGM.AC9_SC.B.SELCTL=1;       /* XOSC */   
   MC_CGM.AC9_DC0.R=0x80030000;    /* Aux Clock 8 divider 0 (RTI/PIT?) */
                                   /* XClock Clock Divide by 4 */
   

   MC_CGM.AC9_SC.B.SELCTL=2;       /* Select PLL0 PHI */   
   MC_CGM.AC10_DC0.R=0x800F0000;   /* Aux Clock 10 divider 0 (ENET) */
                                   /* Divide by 15 + 1.  400MHz / 16 = 25MHz */
/*! Set the PRAMC Flow Through disable   */
/*! SRAM requires additional wait state  */
/*! Note:  Do not change the FT_DIS bit while accessing System RAM.
   Relocate code programming the FT_DIS bit to another memory area
   (e.g. local Core memory).            */
/*! Also, set the FT_DIS bit after programming clock dividers and before
   setting PLLs and executing the Mode Entry change  */
   PRAMC.PRCR1.B.FT_DIS = 1;

   
/*! ~~~~~~~~~~~~~~~~~~~~~~ Set up XOSC,PLL0, PLL1 ~~~~~~~~~~~~~~~~~~~~~~ */

 /*! Route XOSC to the PLL's - IRC is default */
   MC_CGM.AC3_SC.B.SELCTL=1;                  /*! Connect XOSC to PLL0 */
   //MC_CGM.AC4_SC.B.SELCTL=1;                  /*! Connect XOSC to PLL1 */
   
/*! Configure PLL0 Dividers - 400MHz from 40MHz XOSC */
   PLLDIG.PLL0DV.B.RFDPHI = 1;   // divide 800MHz / 2 = 400MHz (pll out)
   PLLDIG.PLL0DV.B.PREDIV = 4;   // divide 40MHz / 4 for 10MHz (input to phase det)
   PLLDIG.PLL0DV.B.MFD = 40;     // multiply 10MHz * 80 = 800MHz (VCO)
   
 /*! Put PLL0 into Normal mode*/
   PLLDIG.PLL0CR.B.CLKCFG = 3;

 
/*! ~~~~~~~~~~~~~~~~~~~~~~~ Configure PCS ~~~~~~~~~~~~~~~~~~~~~~~~~ */   
/*! Progressive Clock Switching (PCS) to prevent glitches - 0.05 rate, 70 steps */

   MC_CGM.PCS_SDUR.R = 100;
   MC_ME.DRUN_MC.B.PWRLVL=3;            
//            MC_ME.DRUN_MC.B.PWRLVL=0;            

 /*! PLL1 PCS switch */
   MC_CGM.PCS_DIVC4.B.INIT = 851;
   MC_CGM.PCS_DIVC4.B.RATE = 12;
   MC_CGM.PCS_DIVS4.R = 31671;
   MC_CGM.PCS_DIVE4.R = 31671;

 /*! PLL0 PCS switch */
   MC_CGM.PCS_DIVC2.B.INIT = 851;
   MC_CGM.PCS_DIVC2.B.RATE = 12;
   MC_CGM.PCS_DIVS2.R = 31671;
   MC_CGM.PCS_DIVE2.R = 31671;
   
   /*! Set the System Clock */
   MC_ME.DRUN_MC.R = 0x30130070;    /*! Enable XOSC and PLLs - PLL1 is sysclk, PWRLVL = 3 */
   
/*! ^^^^^^^^^^^^^^^^^^^ Perform Mode Entry change ^^^^^^^^^^^^^^^^^ */
/*! Mode change Re-enter the drun mode, to start cores, clock tree & PLL1 */
   MC_ME.MCTL.R = 0x30005AF0;                                  /*! Mode & Key */
   MC_ME.MCTL.R = 0x3000A50F;                         /*! Mode & Key inverted */

   while(MC_ME.GS.B.S_MTRANS == 1);          /*! Wait for mode entry complete */
   while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);       /*! Check DRUN mode entered */
   
/*! ~~~~~~~~~~ Setup SYSCLK0 & SYSCLK1 port pin monitors ~~~~~~~~~~~~~~~~~~~~ */   
   
/* Set Up clock selectors to allow clock out to be viewed */
//! See Note above.  this code has to be located here for SYSCLK0 and SYSCLK1 to
//! appear on port pins PF18 and PA15.
   
   MC_CGM.AC6_SC.B.SELCTL=2;        /*! Select PLL0-sysclk0 */
   MC_CGM.AC6_DC0.R=0x80090000;     /*! AC2 divider 0 (SYSCLK0) Divide by 10 */

   /*! Configure Pins for Clock out */
   SIUL2.MSCR_IO[15].R = 0x22800001;   /*! PA15 as Sysclk1 */
   SIUL2.MSCR_IO[88].R = 0x22800001;   /*! PF8 as Sysclk0 */

/*! ~~~~~~~~~~~~~~~~~~~~ Perform Mode Entry change ~~~~~~~~~~~~~~~~~~~~ */   
   /* Set the System Clock - the following line of code is redundant and should be removed*/
   MC_ME.DRUN_MC.R = 0x30130070;    /*! Enable XOSC and PLLs - PLL1 is sysclk, PWRLVL = 3 */
   
   /*! Mode change Re-enter the drun mode, to start cores, clock tree & PLL1 */
   MC_ME.MCTL.R = 0x30005AF0;                                  /*! Mode & Key */
   MC_ME.MCTL.R = 0x3000A50F;                         /*! Mode & Key inverted */
                                        
   while(MC_ME.GS.B.S_MTRANS == 1);          /*! Wait for mode entry complete */
   while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);       /*! Check DRUN mode entered */

}

