/*************************************************************************//**
 * @file main.c
 * @copyright Freescale 2014 All Rights Reserved
 * @version 0.2                             
 * @brief This file contains the main function for the McKinley RunIDD
          Software. The configuration settings required should be set in the
          project.h file.
 * @date 15-Dec-14
 * @author S.Becerra                                                        */
/*===========================================================================*
 * UPDATE HISTORY                                                            *
 * REV      AUTHOR      DATE       	DESCRIPTION OF CHANGE                    *
 * ---   -----------  ---------    	---------------------                    *
 * 0.1   D.McMenamin  10-Nov-11     Initial version: Cores, DMA and GTM      *
 *                                                                           *
 * 0.2   D.McMenamin  30-Jan-12     Modified to add in Peripheral code       *
 *                                                                           *
 * 0.3   S.Becerra    15-Dec-14     Modified to run Zipwire test case only   *
 *                                                                           *
 *===========================================================================*
 * COPYRIGHT:                                                                *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby        *
 *  granted a copyright license to use, modify, and distribute the           *
 *  SOFTWARE so long as this entire notice is retained without alteration    *
 *  in any modified and/or redistributed versions, and that such modified    *
 *  versions are clearly identified as such. No licenses are granted by      *
 *  implication, estoppel or otherwise under any patentsor trademarks        *
 *  of Freescale Semiconductor, Inc. This software is provided on an         *
 *  "AS IS" basis and without warranty.                                      *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, Freescale             *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,       *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A         *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD     *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY        *
 *  ACCOMPANYING WRITTEN MATERIALS.                                          *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, IN NO EVENT           *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER       *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,     *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER            *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.     *
 *                                                                           *
 *  Freescale Semiconductor assumes no responsibility for the                *
 *  maintenance and support of this software                                 *
 *                                                                           *
 ****************************************************************************/

#define _MAIN_

#include "project.h"
#include "Zipwire.h"
#include "SIPI_API.h"
#include "SIPI_HSSL_Header_v4.h"

extern void MC_MODE_INIT(void);
extern void LFAST_Configure(unsigned char master);
extern unsigned char sipi_app_note_read(void);
extern unsigned char sipi_app_note_write(void);
extern unsigned char sipi_app_note_multiple_read_no_dma(void);
extern unsigned char sipi_app_note_multiple_write_no_dma(void);
extern unsigned char sipi_app_note_multiple_write_dma(void);
extern unsigned char sipi_app_note_stream_write(void);
extern unsigned char sipi_app_note_ID(void);
extern unsigned char sipi_app_note_event(void);



void user_testcase(void);

CHANNEL_t test_channel_structure;

/************************************ Main ***********************************/
int main(){

  MC_MODE_INIT();              /* Configure Clocks and Modules Via Mode Entry */
  user_testcase();

}

void user_testcase(void)
{
  int result;
 
  test_channel_structure.Number = 1;
  test_channel_structure.Timeout = 0xFF;
  LFAST_Configure(CONFIGURED_AS_MASTER);
  
  result = SIPI_reset();
  while(result > 0);
  
  SIPI_init_channel(test_channel_structure, 0, 0, 0);
  
  result = sipi_app_note_event(); 
  while(result > 0);
  
  result = sipi_app_note_ID(); 
  while(result > 0);
  
  result = sipi_app_note_read();
  while(result > 0);
  
  result = sipi_app_note_write();
  while(result > 0);

  result = sipi_app_note_multiple_read_no_dma();
  while(result > 0);

  result = sipi_app_note_multiple_write_no_dma();
  while(result > 0);
  
  do{
    result = sipi_app_note_multiple_write_dma();
  }while(result > 0);
  
  result = sipi_app_note_stream_write(); // Stream only available with CH2
  while(result > 0);
  
  while(1);
}
