/*************************************************************************//**
 * @file SIPI_API.h                                                    
 * @copyright Freescale 2014 All Rights Reserved                             
 * @version 1.1                                                              
 * @brief This file defines all the data types and constants for SIPI_API
 * @date 15-Dec-14
 * @author S.Becerra                                                        */
/*===========================================================================*
 * UPDATE HISTORY                                                            *
 * REV      AUTHOR      DATE       	DESCRIPTION OF CHANGE                    *
 * ---   -----------  ---------    	---------------------                    *
 * 1.0   B04629       24-Nov-14     Initial version                          *
 *                                                                           *
 * 1.1   S.Becerra    15-Dec-14     Added constants                          *
 *                                                                           *
 *===========================================================================*
 * COPYRIGHT:                                                                *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby        *
 *  granted a copyright license to use, modify, and distribute the           *
 *  SOFTWARE so long as this entire notice is retained without alteration    *
 *  in any modified and/or redistributed versions, and that such modified    *
 *  versions are clearly identified as such. No licenses are granted by      *
 *  implication, estoppel or otherwise under any patentsor trademarks        *
 *  of Freescale Semiconductor, Inc. This software is provided on an         *
 *  "AS IS" basis and without warranty.                                      *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, Freescale             *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,       *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A         *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD     *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY        *
 *  ACCOMPANYING WRITTEN MATERIALS.                                          *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, IN NO EVENT           *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER       *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,     *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER            *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.     *
 *                                                                           *
 *  Freescale Semiconductor assumes no responsibility for the                *
 *  maintenance and support of this software                                 *
 *                                                                           *
 ****************************************************************************/

#ifndef _SIPI_API_H_
#define _SIPI_API_H_

#include "LFAST.h"
/**************************************************************************/
/*                   Module: SIPI API Structures                          */
/**************************************************************************/

/* CSR0 */
#define CSR0_RAR    0x00000080
#define CSR0_ACKR   0x00000008

/* CSR1 */
#define CSR1_RAR    0x00000080
#define CSR1_ACKR   0x00000008

/* CSR2 */
#define CSR2_RAR    0x00000080
#define CSR2_ACKR   0x00000008

/* CSR3 */
#define CSR3_RAR    0x00000080
#define CSR3_ACKR   0x00000008

/* ERR */
#define ERR_TOE0    0x00000004
#define ERR_TIDE0   0x00000002
#define ERR_ACKE0   0x00000001
#define ERR_TOE1    0x00000400
#define ERR_TIDE1   0x00000200 
#define ERR_ACKE1   0x00000100
#define ERR_TOE2    0x00040000
#define ERR_TIDE2   0x00020000
#define ERR_ACKE2   0x00010000
#define ERR_TOE3    0x04000000
#define ERR_TIDE3   0x02000000
#define ERR_ACKE3   0x01000000

/* MCR */
#define MCR_TEN     0x00000008
#define MCR_INIT    0x00000004
#define MCR_MOEN    0x00000002
#define MCR_SR      0x00000001

/* CCR0 */
#define CCR0_TC     0x00010000
#define CCR0_WL     0x000000C0
#define CCR0_WL_1   0x00000040
#define CCR0_WL_2   0x00000080
#define CCR0_WL_3   0x000000C0
#define CCR0_CHEN   0x00000020
#define CCR0_ST     0x00000010
#define CCR0_IDT    0x00000008
#define CCR0_RRT    0x00000004
#define CCR0_WRT    0x00000002

/* CCR1 */
#define CCR1_TC     0x00010000
#define CCR1_WL     0x000000C0
#define CCR1_WL_1   0x00000040
#define CCR1_WL_2   0x00000080
#define CCR1_WL_3   0x000000C0
#define CCR1_CHEN   0x00000020
#define CCR1_ST     0x00000010
#define CCR1_IDT    0x00000008
#define CCR1_RRT    0x00000004
#define CCR1_WRT    0x00000002

/* CCR2 */
#define CCR2_TC     0x00010000
#define CCR2_WL     0x000000C0
#define CCR2_WL_1   0x00000040
#define CCR2_WL_2   0x00000080
#define CCR2_WL_3   0x000000C0
#define CCR2_CHEN   0x00000020
#define CCR2_ST     0x00000010
#define CCR2_IDT    0x00000008
#define CCR2_RRT    0x00000004
#define CCR2_WRT    0x00000002

/* CCR3 */
#define CCR3_TC     0x00010000
#define CCR3_WL     0x000000C0
#define CCR3_WL_1   0x00000040
#define CCR3_WL_2   0x00000080
#define CCR3_WL_3   0x000000C0
#define CCR3_CHEN   0x00000020
#define CCR3_ST     0x00000010
#define CCR3_IDT    0x00000008
#define CCR3_RRT    0x00000004
#define CCR3_WRT    0x00000002

/** DATA_TEMPLATE structure should contain write Address and Data pointers for SIPI_write command,read Address pointer and Data size for SIPI_read. */

typedef struct
{
	uint32_t Data;
	uint32_t Address;
	uint16_t Size;
} DATA_TEMPLATE_t;


/** CHANNEL structure should be utilised as a 4 element array in the application (for SIPI channels 1-4). */

typedef struct
{
	uint8_t Number;
	uint8_t Timeout;
}CHANNEL_t;

#endif
