/* -----------------------------------------------------------------------------
Copyright 2018 NXP.  This software is owned or controlled by NXP and may only be used strictly in accordance with the applicable license terms.  
By expressly accepting such terms or by downloading, installing, activating and/or otherwise using the software, you are agreeing that you have read, 
and that you agree to comply with and are bound by, such license terms.  If you do not agree to be bound by the applicable license terms, 
then you may not retain, install, activate or otherwise use the software.

 Warning: 	Example Code - Subject to change without notice

 File Name:   main.c for BIST example code

 Description: MPC5777M

 Notes:

 Documentation:
	- MPC5777M RM: 
	- MPC5777M Functional Safety Manual




-----------------------------------------------------------------------------
 Revision	Author				Date		     Description
 0.10		Andrew Turner	25/02/15    Initial release
 1.00		Andrew Ruf		02/12/19	Updating online configurations
----------------------------------------------------------------------------- */

#include "../headers/project.h"
#include "../headers/MPC5777m.h"



/* Configure Online BIST for Medium or DIAGNOSTIC online BIST sequence using pre-processor directive */

#define KEYOFF 
//#define DIAGNOSTIC 

/* --------------------------- Function Prototypes --------------------------------------------------*/
extern void irq_cnfg(void);	// External Prototype in: "MPC57xx__Interrupt_Init.c"
extern void BIST_mode_change(void);	// External Prototype in: "mcu_init.c"
extern void MC_MODE_INIT(void);



/* ------------------- Functions Constants/Variables/Defines ---------------------------------------- */
unsigned int Offline_LBIST_Result; 			/*Results from LBS register stored here        */
unsigned int Offline_MBIST_Result_low, Offline_MBIST_Result_KEYOFF, Offline_MBIST_Result_high;
unsigned int Online_LBIST_Result;
unsigned int Online_MBIST_Result_low, Online_MBIST_Result_KEYOFF, Online_MBIST_Result_high;




void main(void){

volatile int i=0;


/*******************************************************************************************************
 *      ______   ________   ______  ________  ______   ______   __    __         ______  
 *     /      \ |        \ /      \|        \|      \ /      \ |  \  |  \       /      \ 
 *    |  $$$$$$\| $$$$$$$$|  $$$$$$\\$$$$$$$$ \$$$$$$|  $$$$$$\| $$\ | $$      |  $$$$$$\
 *    | $$___\$$| $$__    | $$   \$$  | $$     | $$  | $$  | $$| $$$\| $$      | $$__| $$
 *     \$$    \ | $$  \   | $$        | $$     | $$  | $$  | $$| $$$$\ $$      | $$    $$
 *     _\$$$$$$\| $$$$$   | $$   __   | $$     | $$  | $$  | $$| $$\$$ $$      | $$$$$$$$
 *    |  \__| $$| $$_____ | $$__/  \  | $$    _| $$_ | $$__/ $$| $$ \$$$$      | $$  | $$
 *     \$$    $$| $$     \ \$$    $$  | $$   |   $$ \ \$$    $$| $$  \$$$      | $$  | $$
 *      \$$$$$$  \$$$$$$$$  \$$$$$$    \$$    \$$$$$$  \$$$$$$  \$$   \$$       \$$   \$$
           
									SELF - OFFLINE TEST COMPLETION CHECK                                                                          
 *********************************************************************************************************/
while(i==0){
/*  This area is simply a hold point to prevent the code running on to the
	Online sequence without stopping in the debugger 
	This hold point would be removed in application usage 
	The user code at this point should inspect the MEMU System RAM table*/

/*  TO CONTINUE WITH THE ONLINE BIST TESTING PLEASE SET THE PROGRAM COUNTER OUTSIDE THE WHILE LOOP       */
SIUL2.GPDO[0].B.PDO = ~SIUL2.GPDO[0].B.PDO;																
}	

/* SET PC at line below  **********************************************************************************/
if(MC_RGM.FES.B.F_ST_DONE == 1){ /*Detect if Self test has completed in Functional Reset Status register  */

/* OFFLINE RESULTS CHECK --- OFFLINE RESULTS CHECK --- OFFLINE RESULTS CHECK ---OFFLINE RESULTS CHECK --- */

/*DETECT IF OFFLINE LOGIC BIST HAS COMPLETED by reading LBIST END FLAG Register (LBE)        */
if (STCU2.LBE.R !=0)
{
/*At least one off line logic BIST partition has completed self test 						 */
/*Store results from LBIST STATUS REGISTER (LBS) register  for later analysis                */
Offline_LBIST_Result = STCU2.LBS.R;
}
/*DETECT IF OFFLINE MEMORY BIST HAS COMPLETED - Read Offline MBIST End Flags (MBEx) registers*/
if ((STCU2.MBEL.R || STCU2.MBEM.R || STCU2.MBEH.R) !=0)
{
/*At least one off line MEMORY BIST partition has completed  self test  */
/*Store results from Offline MBIST status registers (MBSx) registers  for later analysis*/	
Offline_MBIST_Result_low = STCU2.MBSL.R;
Offline_MBIST_Result_KEYOFF = STCU2.MBSM.R;
Offline_MBIST_Result_high = STCU2.MBSH.R;
}



/* ONLINE RESULTS CHECK --- ONLINE RESULTS CHECK --- ONLINE RESULTS CHECK ---ONLINE RESULTS CHECK --- */
/* Read On-Line LBIST END Flag register (LBESW)to determine if we have completed On-line LBIST */
if (STCU2.LBESW.R !=0)
{
/*At least one On line logic BIST partition has completed self test*/
/*Store results from LBSSW register  for later analysis*/
Online_LBIST_Result = STCU2.LBSSW.R;
}
/* Read On-Line MBIST END Flag registers (MBExSW) to determine if we have completed On-line MBIST */
if (STCU2.MBELSW.R!=0 || STCU2.MBEMSW.R!=0 || STCU2.MBEHSW.R!=0)
{
/*At least one On line Memory BIST partition has completed self test*/
/*Store results from LBSSW register  for later analysis*/
Online_MBIST_Result_low = STCU2.MBSLSW.R;
Online_MBIST_Result_KEYOFF = STCU2.MBSMSW.R;
Online_MBIST_Result_high = STCU2.MBSHSW.R;
  
}
  /* Clear Reset Status registers  MC_RGM.DES, MC_RGM.FES */
    MC_RGM.DES.R = 0x0180C73B;
    MC_RGM.FES.R = 0x0180846F;
}

/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\       $$$$$$$\  
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$  __$$\ 
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ |  $$ |
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$$$$$$\ |
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$  __$$\ 
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |  $$ |
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      $$$$$$$  |
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|      \_______/ 
                                  
								MPC5777M Standard initialization
 *********************************************************************************************************/



MC_MODE_INIT();	/* Standard MPC5777M Initialization sequence -- Set Program counter here with debugger
					to continue with ONLINE BIST test */

////  SECTION C- MODE Change which configures PLLs and System clock dividers for ONLINE BIST ///////////

/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\        $$$$$$\  
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$  __$$\ 
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ /  \__|
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$ |      
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$ |      
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |  $$\ 
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      \$$$$$$  |
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|       \______/ 
 *                                                                                       
                           BIST MODE CHANGE AND DISABLE PERIPHERALS                                            
 *********************************************************************************************************/

BIST_mode_change(); // Example to reconfigure PLLS to 200MHz for MBIST execution



/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\       $$$$$$$\  
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$  __$$\ 
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ |  $$ |
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$ |  $$ |
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$ |  $$ |
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |  $$ |
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      $$$$$$$  |
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|      \_______/ 
            
                                   Unlock STCU using keys                               
 *********************************************************************************************************/
/* Do not step through or halt the sequence from this point!! The STCU keys will time out if this happens*/
/* Write on-line unlock keys to the STCU */
STCU2.SKC.R = 0x753F924E;   
STCU2.SKC.R = 0x8AC06DB1;



/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\       $$$$$$$$\ 
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$  _____|
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ |      
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$$$$\    
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$  __|   
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |      
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      $$$$$$$$\ 
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|      \________|                
 *********************************************************************************************************/

/* MBIST Config - MBIST Will run first */

/* Configure MBIST Control registers */ 
STCU2.MB_CTRL[0].R = 0x91000000;        /* MBIST CTRL00 Run concurrently, next in sequence is MBIST 1 */
STCU2.MB_CTRL[1].R = 0x92000000;        /* MBIST CTRL01 Run concurrently, next in sequence is MBIST 2 */ 
STCU2.MB_CTRL[2].R = 0x93000000;        /* MBIST CTRL02 Run concurrently, next in sequence is MBIST 3 */
STCU2.MB_CTRL[3].R = 0x94000000;        /* MBIST CTRL03 Run concurrently, next in sequence is MBIST 4 */
STCU2.MB_CTRL[4].R = 0x95000000;        /* MBIST CTRL04 Run concurrently, next in sequence is MBIST 5 */
STCU2.MB_CTRL[5].R = 0x96000000;        /* MBIST CTRL05 Run concurrently, next in sequence is MBIST 6 */
STCU2.MB_CTRL[6].R = 0x97000000;        /* MBIST CTRL06 Run concurrently, next in sequence is MBIST 7 */
STCU2.MB_CTRL[7].R = 0x98000000;        /* MBIST CTRL07 Run concurrently, next in sequence is MBIST 8 */
STCU2.MB_CTRL[8].R = 0x99000000;        /* MBIST CTRL08 Run concurrently, next in sequence is MBIST 9 */
STCU2.MB_CTRL[9].R = 0x9A000000;        /* MBIST CTRL09 Run concurrently, next in sequence is MBIST 10 */
STCU2.MB_CTRL[10].R = 0x9B000000;       /* MBIST CTRL10 Run concurrently, next in sequence is MBIST 11 */
STCU2.MB_CTRL[11].R = 0x9C000000;       /* MBIST CTRL11 Run concurrently, next in sequence is MBIST 12 */
STCU2.MB_CTRL[12].R = 0x9D000000;       /* MBIST CTRL12 Run concurrently, next in sequence is MBIST 13 */
STCU2.MB_CTRL[13].R = 0x9E000000;       /* MBIST CTRL13 Run concurrently, next in sequence is MBIST 14 */
STCU2.MB_CTRL[14].R = 0x9F000000;       /* MBIST CTRL14 Run concurrently, next in sequence is MBIST 15 */
STCU2.MB_CTRL[15].R = 0xA0000000;       /* MBIST CTRL15 Run concurrently, next in sequence is MBIST 16 */
STCU2.MB_CTRL[16].R = 0xA1000000;       /* MBIST CTRL16 Run concurrently, next in sequence is MBIST 17 */
STCU2.MB_CTRL[17].R = 0xA2000000;       /* MBIST CTRL17 Run concurrently, next in sequence is MBIST 18 */
STCU2.MB_CTRL[18].R = 0xA3000000;       /* MBIST CTRL18 Run concurrently, next in sequence is MBIST 19 */
STCU2.MB_CTRL[19].R = 0xA4000000;       /* MBIST CTRL19 Run concurrently, next in sequence is MBIST 20 */
STCU2.MB_CTRL[20].R = 0xA5000000;       /* MBIST CTRL20 Run concurrently, next in sequence is MBIST 21 */

/* Write key 2 to service the watchdog */
STCU2.SKC.R = 0x8AC06DB1; 

STCU2.MB_CTRL[21].R = 0xA6000000;       /* MBIST CTRL21 Run concurrently, next in sequence is MBIST 22 */
STCU2.MB_CTRL[22].R = 0xA7000000;       /* MBIST CTRL22 Run concurrently, next in sequence is MBIST 23 */
STCU2.MB_CTRL[23].R = 0xA8000000;       /* MBIST CTRL23 Run concurrently, next in sequence is MBIST 24 */
STCU2.MB_CTRL[24].R = 0xA9000000;       /* MBIST CTRL24 Run concurrently, next in sequence is MBIST 25 */
STCU2.MB_CTRL[25].R = 0xAA000000;       /* MBIST CTRL25 Run concurrently, next in sequence is MBIST 26 */
STCU2.MB_CTRL[26].R = 0xAB000000;       /* MBIST CTRL26 Run concurrently, next in sequence is MBIST 27 */
STCU2.MB_CTRL[27].R = 0xAC000000;       /* MBIST CTRL27 Run concurrently, next in sequence is MBIST 28 */
STCU2.MB_CTRL[28].R = 0xAD000000;       /* MBIST CTRL28 Run concurrently, next in sequence is MBIST 29 */
STCU2.MB_CTRL[29].R = 0xAE000000;       /* MBIST CTRL29 Run concurrently, next in sequence is MBIST 30 */
STCU2.MB_CTRL[30].R = 0xAF000000;       /* MBIST CTRL30 Run concurrently, next in sequence is MBIST 31 */
STCU2.MB_CTRL[31].R = 0xB0000000;       /* MBIST CTRL31 Run concurrently, next in sequence is MBIST 32 */
STCU2.MB_CTRL[32].R = 0xB1000000;       /* MBIST CTRL32 Run concurrently, next in sequence is MBIST 33 */
STCU2.MB_CTRL[33].R = 0xB2000000;       /* MBIST CTRL33 Run concurrently, next in sequence is MBIST 34 */
STCU2.MB_CTRL[34].R = 0xB3000000;       /* MBIST CTRL34 Run concurrently, next in sequence is MBIST 35 */
STCU2.MB_CTRL[35].R = 0xB4000000;       /* MBIST CTRL35 Run concurrently, next in sequence is MBIST 36 */
STCU2.MB_CTRL[36].R = 0xB5000000;       /* MBIST CTRL36 Run concurrently, next in sequence is MBIST 37 */
STCU2.MB_CTRL[37].R = 0xB6000000;       /* MBIST CTRL37 Run concurrently, next in sequence is MBIST 38 */
STCU2.MB_CTRL[38].R = 0x37000000;       /* MBIST CTRL38 Run concurrently, next in sequence is MBIST 39 - 
										This is set to sequential so that the next group runs sequentially 
										to this group */


/* Write key 2 to service the watchdog */
STCU2.SKC.R = 0x8AC06DB1; 

/*Group 2- Partitions 39 to 77. Overlyay RAM, IOP RAM, HSM RAM and DMA RAM*/

STCU2.MB_CTRL[39].R = 0xB8000000;       /* MBIST CTRL39 Run concurrently, next in sequence is MBIST 40 */
STCU2.MB_CTRL[40].R = 0xB9000000;       /* MBIST CTRL40 Run concurrently, next in sequence is MBIST 41 */
STCU2.MB_CTRL[41].R = 0xBA000000;       /* MBIST CTRL41 Run concurrently, next in sequence is MBIST 42 */
STCU2.MB_CTRL[42].R = 0xBB000000;       /* MBIST CTRL42 Run concurrently, next in sequence is MBIST 43 */
STCU2.MB_CTRL[43].R = 0xBC000000;       /* MBIST CTRL43 Run concurrently, next in sequence is MBIST 44 */
STCU2.MB_CTRL[44].R = 0xBD000000;       /* MBIST CTRL44 Run concurrently, next in sequence is MBIST 45 */
STCU2.MB_CTRL[45].R = 0xBE000000;       /* MBIST CTRL45 Run concurrently, next in sequence is MBIST 46 */
STCU2.MB_CTRL[46].R = 0xBF000000;       /* MBIST CTRL46 Run concurrently, next in sequence is MBIST 47 */
STCU2.MB_CTRL[47].R = 0xC0000000;       /* MBIST CTRL47 Run concurrently, next in sequence is MBIST 48 */
STCU2.MB_CTRL[48].R = 0xC1000000;       /* MBIST CTRL48 Run concurrently, next in sequence is MBIST 49 */
STCU2.MB_CTRL[49].R = 0xC2000000;       /* MBIST CTRL49 Run concurrently, next in sequence is MBIST 50 */
STCU2.MB_CTRL[50].R = 0xC3000000;       /* MBIST CTRL50 Run concurrently, next in sequence is MBIST 51 */
STCU2.MB_CTRL[51].R = 0xC4000000;       /* MBIST CTRL51 Run concurrently, next in sequence is MBIST 52 */
STCU2.MB_CTRL[52].R = 0xC5000000;       /* MBIST CTRL52 Run concurrently, next in sequence is MBIST 53 */
STCU2.MB_CTRL[53].R = 0xC6000000;       /* MBIST CTRL53 Run concurrently, next in sequence is MBIST 54 */
STCU2.MB_CTRL[54].R = 0xC7000000;       /* MBIST CTRL54 Run concurrently, next in sequence is MBIST 55 */
STCU2.MB_CTRL[55].R = 0xC8000000;       /* MBIST CTRL55 Run concurrently, next in sequence is MBIST 56 */
STCU2.MB_CTRL[56].R = 0xC9000000;       /* MBIST CTRL56 Run concurrently, next in sequence is MBIST 57 */
STCU2.MB_CTRL[57].R = 0xCA000000;       /* MBIST CTRL57 Run concurrently, next in sequence is MBIST 58 */

/* Write key 2 to service the watchdog */
STCU2.SKC.R = 0x8AC06DB1; 

STCU2.MB_CTRL[58].R = 0xCB000000;       /* MBIST CTRL58 Run concurrently, next in sequence is MBIST 59 */
STCU2.MB_CTRL[59].R = 0xCC000000;       /* MBIST CTRL59 Run concurrently, next in sequence is MBIST 60 */
STCU2.MB_CTRL[60].R = 0xCD000000;       /* MBIST CTRL60 Run concurrently, next in sequence is MBIST 61 */
STCU2.MB_CTRL[61].R = 0xCE000000;       /* MBIST CTRL61 Run concurrently, next in sequence is MBIST 62 */
STCU2.MB_CTRL[62].R = 0xCF000000;       /* MBIST CTRL62 Run concurrently, next in sequence is MBIST 63 */
STCU2.MB_CTRL[63].R = 0xD0000000;       /* MBIST CTRL63 Run concurrently, next in sequence is MBIST 64 */
STCU2.MB_CTRL[64].R = 0xD1000000;       /* MBIST CTRL64 Run concurrently, next in sequence is MBIST 65 */
STCU2.MB_CTRL[65].R = 0xD2000000;       /* MBIST CTRL65 Run concurrently, next in sequence is MBIST 66 */
STCU2.MB_CTRL[66].R = 0xD3000000;       /* MBIST CTRL66 Run concurrently, next in sequence is MBIST 67 */
STCU2.MB_CTRL[67].R = 0xD4000000;       /* MBIST CTRL67 Run concurrently, next in sequence is MBIST 68 */
STCU2.MB_CTRL[68].R = 0xD5000000;       /* MBIST CTRL68 Run concurrently, next in sequence is MBIST 69 */
STCU2.MB_CTRL[69].R = 0xD6000000;       /* MBIST CTRL69 Run concurrently, next in sequence is MBIST 70 */
STCU2.MB_CTRL[70].R = 0xD7000000;       /* MBIST CTRL70 Run concurrently, next in sequence is MBIST 71 */
STCU2.MB_CTRL[71].R = 0xD8000000;       /* MBIST CTRL71 Run concurrently, next in sequence is MBIST 72 */
STCU2.MB_CTRL[72].R = 0xD9000000;       /* MBIST CTRL72 Run concurrently, next in sequence is MBIST 73 */
STCU2.MB_CTRL[73].R = 0xDA000000;       /* MBIST CTRL73 Run concurrently, next in sequence is MBIST 74 */
STCU2.MB_CTRL[74].R = 0xDB000000;       /* MBIST CTRL74 Run concurrently, next in sequence is MBIST 75 */
STCU2.MB_CTRL[75].R = 0xDC000000;       /* MBIST CTRL75 Run concurrently, next in sequence is MBIST 76 */
STCU2.MB_CTRL[76].R = 0xDD000000;       /* MBIST CTRL76 Run concurrently, next in sequence is MBIST 77 */
STCU2.MB_CTRL[77].R = 0x00000000;       /* LBIST Partition 0 to run sequentially*/

/* Write key 2 to service the watchdog */
STCU2.SKC.R = 0x8AC06DB1; 

/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\       $$$$$$$$\ 
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$  _____|
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ |      
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$$$$\    
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$  __|   
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |      
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      $$ |      
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|      \__|      
 *                              
 * 				 Configure MBIST recoverable/unrecoverable fault handling                                                                          
 *********************************************************************************************************/


STCU2.MBUFML.R = 0x0;           /* Configure all faults as recoverable in this example */
STCU2.MBUFMM.R = 0x0;           /* Configure all faults as recoverable in this example */
STCU2.MBUFMH.R = 0x0;           /* Configure all faults as recoverable in this example */




/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\        $$$$$$\  
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$  __$$\ 
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ /  \__|
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$ |$$$$\ 
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$ |\_$$ |
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |  $$ |
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      \$$$$$$  |
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|       \______/ 
 *                            
 * 								 On-line LBIST partition configuration                                                                                      
 *********************************************************************************************************/


/* Configure Online LBIST partition coverage 					*/
/* Configure LBIST for 90% coverage using KEYOFF #define 		*/
/*                              OR  			                */
/*Configure LBIST for 94% coverage using DIAGNOSTIC #define     */



/* LBIST0 HSM Config */
#ifdef KEYOFF
STCU2.LB[0].LB_CTRL.R = 0x01035507;       /* LBIST CTRL0 Run sequentially, next in sequence is LBIST 1 */
STCU2.LB[0].LB_PCS.R = 0x00000580;        /* LBIST 0 pattern count */ 
STCU2.LB[0].LB_MISRELSW.R = 0xC600B837;   /* LBIST MISREL Expected Low */
STCU2.LB[0].LB_MISREHSW.R = 0x9CC36E3F;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[0].LB_CTRL.R = 0x01035507;       /* LBIST CTRL0 Run sequentially, next in sequence is LBIST 1 */
STCU2.LB[0].LB_PCS.R = 0x00003380;        /* LBIST 0 pattern count */ 
STCU2.LB[0].LB_MISRELSW.R = 0xE29FCE36;   /* LBIST MISREL Expected Low */
STCU2.LB[0].LB_MISREHSW.R = 0x50EA7D46;   /* LBIST MISREH Expected High */
#endif

/* LBIST1 IOP Core Config */
#ifdef KEYOFF
STCU2.LB[1].LB_CTRL.R = 0x02035507;       /* LBIST CTRL1 Run sequentially, next in sequence is LBIST 2 */
STCU2.LB[1].LB_PCS.R = 0x000004C0;        /* LBIST 1 pattern count */
STCU2.LB[1].LB_MISRELSW.R = 0x3E7EB360;   /* LBIST MISREL Expected Low */
STCU2.LB[1].LB_MISREHSW.R = 0x93067DD8;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[1].LB_CTRL.R = 0x02035507;       /* LBIST CTRL1 Run sequentially, next in sequence is LBIST 2 */
STCU2.LB[1].LB_PCS.R = 0x00002780;        /* LBIST 1 pattern count */
STCU2.LB[1].LB_MISRELSW.R = 0x91150D56;   /* LBIST MISREL Expected Low */
STCU2.LB[1].LB_MISREHSW.R = 0xB8D517BE;   /* LBIST MISREH Expected High */
#endif

/* LBIST2 Peripheral Shell Config */
#ifdef KEYOFF
STCU2.LB[2].LB_CTRL.R = 0x03035507;       /* LBIST CTRL2 Run sequentially, next in sequence is LBIST 3 */
STCU2.LB[2].LB_PCS.R = 0x00000500;        /* LBIST 2 pattern count */
STCU2.LB[2].LB_MISRELSW.R = 0x893E9D7B;   /* LBIST MISREL Expected Low */
STCU2.LB[2].LB_MISREHSW.R = 0x3ED132E8;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[2].LB_CTRL.R = 0x03035507;       /* LBIST CTRL2 Run sequentially, next in sequence is LBIST 3 */
STCU2.LB[2].LB_PCS.R = 0x00003700;        /* LBIST 2 pattern count */
STCU2.LB[2].LB_MISRELSW.R = 0x5743B0A7;   /* LBIST MISREL Expected Low */
STCU2.LB[2].LB_MISREHSW.R = 0x9BA96D5F;   /* LBIST MISREH Expected High */
#endif

/* LBIST3 Computational Shell Config */
#ifdef KEYOFF
STCU2.LB[3].LB_CTRL.R = 0x04035507;       /* LBIST CTRL3 Run sequentially, next in sequence is LBIST 4 */
STCU2.LB[3].LB_PCS.R = 0x00000600;        /* LBIST 3 pattern count */
STCU2.LB[3].LB_MISRELSW.R = 0xA20CC2AA;   /* LBIST MISREL Expected Low */
STCU2.LB[3].LB_MISREHSW.R = 0x8DC58C7A;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[3].LB_CTRL.R = 0x04035507;       /* LBIST CTRL3 Run sequentially, next in sequence is LBIST 6 */
STCU2.LB[3].LB_PCS.R = 0x00015F90;        /* LBIST 3 pattern count */
STCU2.LB[3].LB_MISRELSW.R = 0x50134C34;   /* LBIST MISREL Expected Low */
STCU2.LB[3].LB_MISREHSW.R = 0xFE483402;   /* LBIST MISREH Expected High */
#endif

/*LBIST4 Computational Shell Config*/
#ifdef KEYOFF
STCU2.LB[4].LB_CTRL.R = 0x05035507;       /* LBIST CTRL4 Run next set sequentially, next in sequence is LBIST 5*/
STCU2.LB[4].LB_PCS.R = 0x00000400;        /* LBIST 4 pattern count */
STCU2.LB[4].LB_MISRELSW.R = 0xB3B30934;   /* LBIST MISREL Expected Low */
STCU2.LB[4].LB_MISREHSW.R = 0xCE7C169E;   /* LBIST MISREH Expected High */
#endif  

#ifdef DIAGNOSTIC
STCU2.LB[4].LB_CTRL.R = 0x05035507;       /* LBIST CTRL4 Run next set sequentially, next in sequence is LBIST 5*/
STCU2.LB[4].LB_PCS.R = 0x000022C0;        /* LBIST 4 pattern count */
STCU2.LB[4].LB_MISRELSW.R = 0x0AEB4740;   /* LBIST MISREL Expected Low */
STCU2.LB[4].LB_MISREHSW.R = 0x6B5DFBFA;   /* LBIST MISREH Expected High */
#endif  

/* Write key 2 to service the watchdog */
STCU2.SKC.R = 0x8AC06DB1;

/* LBIST5 Peripheral Shell Masters Config */
#ifdef KEYOFF
STCU2.LB[5].LB_CTRL.R = 0x06035507;       /* LBIST CTRL5 Run sequentially, next in sequence is LBIST 5 */
STCU2.LB[5].LB_PCS.R = 0x00000580;        /* LBIST 5 pattern count */
STCU2.LB[5].LB_MISRELSW.R = 0x7D0928BE;   /* LBIST MISREL Expected Low */
STCU2.LB[5].LB_MISREHSW.R = 0xB6F928C2;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[5].LB_CTRL.R = 0x06035507;       /* LBIST CTRL5 Run sequentially, next in sequence is LBIST 5 */
STCU2.LB[5].LB_PCS.R = 0x00002040;        /* LBIST 5 pattern count */
STCU2.LB[5].LB_MISRELSW.R = 0x5B67E29B;   /* LBIST MISREL Expected Low */
STCU2.LB[5].LB_MISREHSW.R = 0x745F8AF8;   /* LBIST MISREH Expected High */
#endif


/* LBIST6 GTM Config */
#ifdef KEYOFF
STCU2.LB[6].LB_CTRL.R = 0x07035507;       /* LBIST CTRL6 Run sequentially, next in sequence is LBIST 6 */
STCU2.LB[6].LB_PCS.R = 0x00000DC0;        /* LBIST 6 pattern count */
STCU2.LB[6].LB_MISRELSW.R = 0x23E0020A;   /* LBIST MISREL Expected Low */
STCU2.LB[6].LB_MISREHSW.R = 0xBE153224;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[6].LB_CTRL.R = 0x07035507;       /* LBIST CTRL6 Run sequentially, next in sequence is LBIST 6 */
STCU2.LB[6].LB_PCS.R = 0x00007080;        /* LBIST 6 pattern count */
STCU2.LB[6].LB_MISRELSW.R = 0xFEF2D48F;   /* LBIST MISREL Expected Low */
STCU2.LB[6].LB_MISREHSW.R = 0xAB2BB9EB;   /* LBIST MISREH Expected High */
#endif

/* LBIST7 Safety Core Config */
#ifdef KEYOFF
STCU2.LB[7].LB_CTRL.R = 0x08035507;       /* LBIST CTRL7 Run sequentially, next in sequence is LBIST 7*/
STCU2.LB[7].LB_PCS.R = 0x00000380;        /* LBIST 7 pattern count */
STCU2.LB[7].LB_MISRELSW.R = 0x3D71D224;   /* LBIST MISREL Expected Low */
STCU2.LB[7].LB_MISREHSW.R = 0xB784129E;   /* LBIST MISREH Expected High */ 
#endif

#ifdef DIAGNOSTIC
STCU2.LB[7].LB_CTRL.R = 0x08035507;       /* LBIST CTRL7 Run sequentially, next in sequence is LBIST 7*/
STCU2.LB[7].LB_PCS.R = 0x00003600;        /* LBIST 7 pattern count */
STCU2.LB[7].LB_MISRELSW.R = 0xE5F27EC4;   /* LBIST MISREL Expected Low */
STCU2.LB[7].LB_MISREHSW.R = 0x48F4CECC;   /* LBIST MISREH Expected High */ 
#endif

/* LBIST8 Checker Core Config */
#ifdef KEYOFF
STCU2.LB[8].LB_CTRL.R = 0x09035507;       /* LBIST CTRL8 Run sequentially, next in sequence is LBIST 8 */
STCU2.LB[8].LB_PCS.R = 0x00000580;        /* LBIST 8 pattern count */
STCU2.LB[8].LB_MISRELSW.R = 0x0A44C59A;   /* LBIST MISREL Expected Low */
STCU2.LB[8].LB_MISREHSW.R = 0x13537D8B;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[8].LB_CTRL.R = 0x09035507;       /* LBIST CTRL8 Run sequentially, next in sequence is LBIST 8 */
STCU2.LB[8].LB_PCS.R = 0x00015F90;        /* LBIST 8 pattern count */
STCU2.LB[8].LB_MISRELSW.R = 0x7B9639AD;   /* LBIST MISREL Expected Low */
STCU2.LB[8].LB_MISREHSW.R = 0xDC67DA80;   /* LBIST MISREH Expected High */
#endif

/* LBIST9 Computational Core Config */
#ifdef KEYOFF
STCU2.LB[9].LB_CTRL.R = 0x7F035507;       /* LBIST CTRL9 Run concurrently, next in sequence is LBIST 9 */
STCU2.LB[9].LB_PCS.R = 0x00000580;        /* LBIST 9 pattern count */
STCU2.LB[9].LB_MISRELSW.R = 0x67F6D810;   /* LBIST MISREL Expected Low */
STCU2.LB[9].LB_MISREHSW.R = 0xD6C246F3;   /* LBIST MISREH Expected High */
#endif

#ifdef DIAGNOSTIC
STCU2.LB[9].LB_CTRL.R = 0x7F035507;       /* LBIST CTRL9 Run concurrently, next in sequence is LBIST 9 */
STCU2.LB[9].LB_PCS.R = 0x000106F4;        /* LBIST 9 pattern count */
STCU2.LB[9].LB_MISRELSW.R = 0x2DEF31DC;   /* LBIST MISREL Expected Low */
STCU2.LB[9].LB_MISREHSW.R = 0x51A946A1;   /* LBIST MISREH Expected High */
#endif

/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\       $$\   $$\ 
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      $$ |  $$ |
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |      $$ |  $$ |
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |      $$$$$$$$ |
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$  __$$ |
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |  $$ |
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      $$ |  $$ |
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|      \__|  \__|
 *        
 *                           Configure LBIST STCU2 Fault handling                                                                                                                                                                      
 *********************************************************************************************************/
/* Configure LBIST recoverable/unrecoverable fault handling  */
STCU2.LBUFM.R = 0x0;                  /* Configure all faults as recoverable in this example */
/*  Configure LBIST error recoverable/unrecoverable fault handling  */
STCU2.ERR_FM.R = 0x0;                  /* Configure all faults as recoverable in this example */
/*  Configure LBIST RESET management register  */
/* Set Global function Reset to occur at end of LBIST 9 */
STCU2.LBRMSW.R = 0x200; 

/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\       $$$$$$\ 
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |      \_$$  _|
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |        $$ |  
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |        $$ |  
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |        $$ |  
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |        $$ |  
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      $$$$$$\ 
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|      \______|
 *                              
 *  				Configure Watchdog Time out and  PMOS MBIST test                                                                        
 *********************************************************************************************************/

/* Set Watchdog timeout Config */
STCU2.WDG.R = 0xFFFFFFFF;                  /* Watchdog time out to Max value */ 

/* Configure pointer to point to first MBIST partition and configure PMOST Test				 */
#ifdef DIAGNOSTIC
STCU2.CFG.R = 0x10000010;      /*MBIST PMOS TEST is enabled for The Full online test sequence*/
#endif

#ifdef KEYOFF
STCU2.CFG.R = 0x10000000;      /*MBIST PMOS TEST is disabled for The Full online test sequence*/
#endif

/*******************************************************************************************************
 *     $$$$$$\  $$$$$$$$\  $$$$$$\ $$$$$$$$\ $$$$$$\  $$$$$$\  $$\   $$\          $$$$$\ 
 *    $$  __$$\ $$  _____|$$  __$$\\__$$  __|\_$$  _|$$  __$$\ $$$\  $$ |         \__$$ |
 *    $$ /  \__|$$ |      $$ /  \__|  $$ |     $$ |  $$ /  $$ |$$$$\ $$ |            $$ |
 *    \$$$$$$\  $$$$$\    $$ |        $$ |     $$ |  $$ |  $$ |$$ $$\$$ |            $$ |
 *     \____$$\ $$  __|   $$ |        $$ |     $$ |  $$ |  $$ |$$ \$$$$ |      $$\   $$ |
 *    $$\   $$ |$$ |      $$ |  $$\   $$ |     $$ |  $$ |  $$ |$$ |\$$$ |      $$ |  $$ |
 *    \$$$$$$  |$$$$$$$$\ \$$$$$$  |  $$ |   $$$$$$\  $$$$$$  |$$ | \$$ |      \$$$$$$  |
 *     \______/ \________| \______/   \__|   \______| \______/ \__|  \__|       \______/  
 *  						
 *  								 Execute Online BIST                    
 *********************************************************************************************************/


/* Start the BIST sequence */
STCU2.RUNSW.R = 0x00000301;

while(STCU2.RUNSW.B.RUNSW == 1);


/***
 *    $$$$$$$\  $$$$$$$$\  $$$$$$\  $$$$$$$$\ $$$$$$$$\        $$$$$$\   $$$$$$\   $$$$$$\  $$\   $$\ $$$$$$$\   $$$$$$\  
 *    $$  __$$\ $$  _____|$$  __$$\ $$  _____|\__$$  __|      $$  __$$\ $$  __$$\ $$  __$$\ $$ |  $$ |$$  __$$\ $$  __$$\ 
 *    $$ |  $$ |$$ |      $$ /  \__|$$ |         $$ |         $$ /  $$ |$$ /  \__|$$ /  \__|$$ |  $$ |$$ |  $$ |$$ /  \__|
 *    $$$$$$$  |$$$$$\    \$$$$$$\  $$$$$\       $$ |         $$ |  $$ |$$ |      $$ |      $$ |  $$ |$$$$$$$  |\$$$$$$\  
 *    $$  __$$< $$  __|    \____$$\ $$  __|      $$ |         $$ |  $$ |$$ |      $$ |      $$ |  $$ |$$  __$$<  \____$$\ 
 *    $$ |  $$ |$$ |      $$\   $$ |$$ |         $$ |         $$ |  $$ |$$ |  $$\ $$ |  $$\ $$ |  $$ |$$ |  $$ |$$\   $$ |
 *    $$ |  $$ |$$$$$$$$\ \$$$$$$  |$$$$$$$$\    $$ |          $$$$$$  |\$$$$$$  |\$$$$$$  |\$$$$$$  |$$ |  $$ |\$$$$$$  |
 *    \__|  \__|\________| \______/ \________|   \__|          \______/  \______/  \______/  \______/ \__|  \__| \______/ 
 *                                                                                                                        
 *                                                                                                                        
 *                                                                                                                        
 */




/* Debugger should not reach into this function due to functional RESET at the end of LBIST partition 9*/
while(1){
SIUL2.GPDO[0].B.PDO = ~SIUL2.GPDO[0].B.PDO;	
for(i=0;i<50000;i++);
} 

}   


                                                                              


