/*
 * File:        tower.h
 * Purpose:     Kinetis tower CPU card definitions
 *
 * Notes:
 */

#ifndef __TOWER_H__
#define __TOWER_H__

#include "mcg.h"

/********************************************************************/

/* Global defines to use for TWR-K65F180M */
#define DEBUG_PRINT

#if (defined(TWR_K65F180M))
  #define MCU_MK65F180

  /*
   * Input Clock Info
   */
  #define CLK0_FREQ_HZ        16000000
  #define CLK0_TYPE           CRYSTAL

  /*
   * PLL Configuration Info
   */
  //#define NO_PLL_INIT

   /* Normal Run Clock Divider values */
   #define CORE_CLK_DIV            0
   #define BUS_CLK_DIV             1
   #define FLEXBUS_CLK_DIV         1
   #define FLASH_CLK_DIV           4

   /* High Speed Run Clock Divider values */
   #define CORE_CLK_DIV_HS            0
   #define BUS_CLK_DIV_HS             2
   #define FLEXBUS_CLK_DIV_HS         2
   #define FLASH_CLK_DIV_HS           6
/* The expected PLL output frequency is:
 * PLL out = (((CLKIN/PRDIV) x VDIV))
 * where the CLKIN can be either CLK0_FREQ_HZ or CLK1_FREQ_HZ.
 * 
 * For more info on PLL initialization refer to the mcg driver files.
 */

  #define PLL0_PRDIV      2    // divider reference by 2 = 8MHz
  #define PLL0_VDIV       30   // multiply reference by 30 = 240MHz 


  #define PLL0_PRDIV_HS      2         //divide reference by 6 : 12/2= 8 MHz
  #define PLL0_VDIV_HS       45        //multiply reference by 60 : 8 * 45 = 360 MHz

  /*
   * System Bus Clock Info
   */
  #define REF_CLK             XTAL16
  #define CORE_CLK_MHZ        PLL120      /* system/core frequency in MHz */

  /* Serial Port Info */
  #define TERM_PORT           UART2_BASE_PTR	/* OSJTAG serial port or TWR-SER COM port */
  #define TERMINAL_BAUD       115200
  //#define TERMINAL_BAUD       19200
  #define TERM_PORT_NUM       2
  #undef  HW_FLOW_CONTROL
#elif (defined(TWR_K64F120M))
  #define MCU_MK65F180

  /*
   * Input Clock Info
   */
  #define CLK0_FREQ_HZ        50000000
  #define CLK0_TYPE           CANNED_OSC

  /*
   * PLL Configuration Info
   */
//   #define NO_PLL_INIT


   
      /* Normal Run Clock Divider values */
   #define CORE_CLK_DIV            0
   #define BUS_CLK_DIV             1
   #define FLEXBUS_CLK_DIV         1
   #define FLASH_CLK_DIV           4

   /* High Speed Run Clock Divider values */
   #define CORE_CLK_DIV_HS            0
   #define BUS_CLK_DIV_HS             2
   #define FLEXBUS_CLK_DIV_HS         2
   #define FLASH_CLK_DIV_HS           6
   
/* The expected PLL output frequency is:
 * PLL out = (((CLKIN/PRDIV) x VDIV)/2)
 *
 * For more info on PLL initialization refer to the mcg driver files.
 */
     #define PLL0_PRDIV		5         //divide 1 : 12 MHz
     #define PLL0_VDIV		24        // multiply reference by 20 : 12 * 20 = 240 MHz

     #define PLL0_PRDIV_HS      5         //divide reference by 1 : 12/1= 12 MHz
     #define PLL0_VDIV_HS       36        //multiply reference by 30 : 12 * 30 = 360 MHz
  /*
   * System Bus Clock Info
   */
  #define REF_CLK             XTAL16
  #define CORE_CLK_MHZ        PLL120      /* system/core frequency in MHz */

  /* Serial Port Info */
  #define TERM_PORT           UART2_BASE_PTR	/* OSJTAG serial port or TWR-SER COM port */
  #define TERMINAL_BAUD       115200
  #define TERM_PORT_NUM       2
  #undef  HW_FLOW_CONTROL
#elif (defined(TWR_K60N512))
  #define MCU_MK65F180

  /*
   * Input Clock Info
   */
  #define CLK0_FREQ_HZ        50000000
  #define CLK0_TYPE           CANNED_OSC

  /*
   * PLL Configuration Info
   */
//   #define NO_PLL_INIT


   
      /* Normal Run Clock Divider values */
   #define CORE_CLK_DIV            0
   #define BUS_CLK_DIV             1
   #define FLEXBUS_CLK_DIV         1
   #define FLASH_CLK_DIV           4

   /* High Speed Run Clock Divider values */
   #define CORE_CLK_DIV_HS            0
   #define BUS_CLK_DIV_HS             2
   #define FLEXBUS_CLK_DIV_HS         2
   #define FLASH_CLK_DIV_HS           6
   
/* The expected PLL output frequency is:
 * PLL out = (((CLKIN/PRDIV) x VDIV)/2)
 *
 * For more info on PLL initialization refer to the mcg driver files.
 */
     #define PLL0_PRDIV		5         //divide 1 : 12 MHz
     #define PLL0_VDIV		24        // multiply reference by 20 : 12 * 20 = 240 MHz

     #define PLL0_PRDIV_HS      5         //divide reference by 1 : 12/1= 12 MHz
     #define PLL0_VDIV_HS       36        //multiply reference by 30 : 12 * 30 = 360 MHz
  /*
   * System Bus Clock Info
   */
  #define REF_CLK             XTAL16
  #define CORE_CLK_MHZ        PLL120      /* system/core frequency in MHz */

  /* Serial Port Info */
  #define TERM_PORT           UART3_BASE_PTR	/* OSJTAG serial port or TWR-SER COM port */
  #define TERMINAL_BAUD       115200
  #define TERM_PORT_NUM       3
  #undef  HW_FLOW_CONTROL
#else
  #error "No valid tower CPU card defined"
#endif


#endif /* __TOWER_H__ */
