/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  PFlashSwap.c                                              *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

#ifdef SWAP
/************************************************************************
*
*  Function Name    : PFlashSwapCtl
*  Description      : Execute swap command represented by a control code
*                     
*                     
*  Arguments        : PFLASH_SSD_CONFIG, UINT32, UINT8,
*                     pFLASHCOMMANDSEQUENCE
*                     
*  Return Value     : UINT32
*
*************************************************************************/
UINT32 PFlashSwapCtl(PFLASH_SSD_CONFIG pSSDConfig,UINT32 addr, UINT8 swapcmd,UINT8* currentSwapMode,pFLASHCOMMANDSEQUENCE pFlashCommandSequence)
{
    UINT32 ret;      /* Return code variable */
    addr = WORD2BYTE(addr - pSSDConfig->PFlashBlockBase);
    /* clear RDCOLERR & ACCERR & FPVIOL flag in flash status register. Write 1 to clear*/
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET,FTFx_SSD_FSTAT_ERROR_BITS);
    
    /* passing parameter to the command */
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB0_OFFSET, FTFx_PFLASH_SWAP);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB1_OFFSET, GET_BIT_16_23(addr));
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB2_OFFSET, GET_BIT_8_15(addr));
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB3_OFFSET, GET_BIT_0_7(addr));
    
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB4_OFFSET, swapcmd);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB5_OFFSET, 0xFF);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB6_OFFSET, 0xFF);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB7_OFFSET, 0xFF);

    /* calling flash command sequence function to execute the command */
    ret = pFlashCommandSequence(pSSDConfig);

    if (FTFx_OK == ret)
    {
        *currentSwapMode = REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB5_OFFSET);
    }   
    
    /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }
    return (ret);
}
#endif
/* end of file */
