/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  PFlashSwap.c                                              *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

#ifdef SWAP
/************************************************************************
*
*  Function Name    : PFlashSwap.c
*  Description      : Perform a swap between P-Flash block 0 and
*                     P-Flash block 1
*                     
*                     
*  Arguments        : PFLASH_SSD_CONFIG, UINT32, pFLASHCOMMANDSEQUENCE, 
*                     PSWAP_CALLBACK
*                     
*  Return Value     : UINT32
*
*************************************************************************/
UINT32 PFlashSwap(PFLASH_SSD_CONFIG pSSDConfig, \
                  UINT32 addr, \
                  PFLASH_SWAP_CALLBACK pSwapCallback, \
                  pFLASHCOMMANDSEQUENCE pFlashCommandSequence)
{
    UINT32 ret;      /* Return code */
    UINT8 currentSwapMode;
    BOOL swapContinue;
    
    ret = FTFx_OK;
    currentSwapMode = 0xFF;
    swapContinue = FALSE;
    
    if (NULL_SWAP_CALLBACK == pSwapCallback)
    {
        ret = FTFx_ERR_ACCERR;
        goto EXIT;
    }
     
    /* Report current swap state */
    ret = PFlashSwapCtl(pSSDConfig,addr,FTFx_SWAP_REPORT_STATUS,&currentSwapMode, pFlashCommandSequence);
    
    if (FTFx_OK != ret)
    {
        goto EXIT;
    }
    
    if ((FTFx_SWAP_UNINIT == currentSwapMode) || (FTFx_SWAP_READY == currentSwapMode))
    {
        /* If current swap mode is Uninitialized */
        if (FTFx_SWAP_UNINIT == currentSwapMode)
        {
            /* Initialize Swap to Initialized/READY state */
            ret = PFlashSwapCtl(pSSDConfig, addr, FTFx_SWAP_SET_INDICATOR_ADDR,&currentSwapMode, pFlashCommandSequence);
        }
            /* If current swap mode is Initialized/Ready */
        if (FTFx_SWAP_READY == currentSwapMode)
        {
            /* Initialize Swap to UPDATE state */
            ret = PFlashSwapCtl(pSSDConfig, addr, FTFx_SWAP_SET_IN_PREPARE,&currentSwapMode, pFlashCommandSequence);
        }
        /* Check for the success of command execution */
        if (ret)
        {
            goto EXIT;
        }
       /* Report the current swap state to user via callback */
        swapContinue = pSwapCallback(currentSwapMode);
              
        if (!swapContinue)
        {
            goto EXIT;
        }
               
        /* Report current swap state */
        ret = PFlashSwapCtl(pSSDConfig,addr,FTFx_SWAP_REPORT_STATUS,&currentSwapMode, pFlashCommandSequence);
    }
    if (FTFx_SWAP_UPDATE == currentSwapMode)
    {
        swapContinue = pSwapCallback(currentSwapMode);
        if (!swapContinue)
        {
            goto EXIT;
        }
        /* Report current swap state */
        ret = PFlashSwapCtl(pSSDConfig,addr,FTFx_SWAP_REPORT_STATUS,&currentSwapMode, pFlashCommandSequence);

    }
    
    /* If current swap mode is Update or Update-Erased */
    if  (FTFx_SWAP_UPDATE_ERASED == currentSwapMode) 
    {
        pSwapCallback(currentSwapMode);
        /* Progress Swap to COMPLETE State */
        ret = PFlashSwapCtl(pSSDConfig,addr,FTFx_SWAP_SET_IN_COMPLETE,&currentSwapMode, pFlashCommandSequence);      
    }

EXIT:
    /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}
#endif /* of SWAP */
/* end of file */
