/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  PFlashGetProtection.c                                     *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

/************************************************************************
*
*  Function Name    : PFlashGetProtection.c
*  Description      : This function retrieves current P-Flash protection status. 
*  Arguments        : PFLASH_SSD_CONFIG, UINT32*
*  Return Value     : UINT32
*
*************************************************************************/
UINT32 PFlashGetProtection(PFLASH_SSD_CONFIG pSSDConfig, UINT32* protectStatus)
{
    UINT32 reg0, reg1, reg2, reg3;
   
    reg0=REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FPROT0_OFFSET);
    reg1=REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FPROT1_OFFSET);
    reg2=REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FPROT2_OFFSET);
    reg3=REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FPROT3_OFFSET);
              
    *protectStatus = (UINT32)((UINT32)(reg0 << 24 ) | (UINT32)(reg1 << 16 ) | (UINT32)(reg2 << 8 ) | reg3); 
                   
    /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

  return(FTFx_OK);
}
/* end of file */
