/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashEraseResume.c                                        *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

/************************************************************************
*
*  Function Name    : FlashEraseResume.c
*  Description      : This function is used to resume a previous suspended
*                     operation of flash erase sector command.
*  Arguments        : PFLASH_SSD_CONFIG
*  Return Value     : UINT32
*
*************************************************************************/
UINT32 FlashEraseResume(PFLASH_SSD_CONFIG pSSDConfig)

{
    UINT16 i;
    i = 0;
    /* check ERSSUSP bit of the flash configuration register */
    if(0x0 != REG_BIT_GET(pSSDConfig->ftfxRegBase + FTFx_SSD_FCNFG_OFFSET, FTFx_SSD_FCNFG_ERSSUSP))
    {

        /* clear CCIF to launch command */
        REG_BIT_SET(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET, FTFx_SSD_FSTAT_CCIF); 
        /* wait for completion of this command */
        while((0x0 == (REG_BIT_GET(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET, FTFx_SSD_FSTAT_CCIF))) \
            ||(++i >RESUME_WAIT_CNT));	
  
    }
      /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(FTFx_OK);
}

/* end of file */
