/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashCommandSequence.c                                    *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"
/************************************************************************
*
*  Function Name    : FlashCommandSequence.c
*  Description      : Perform command write sequence for flash operation
*  Arguments        : PFLASH_SSD_CONFIG, UINT8, UINT8*
*  Return Value     : UINT32
*
*************************************************************************/
UINT32  FlashCommandSequence (PFLASH_SSD_CONFIG pSSDConfig )                                         
   
{
    UINT32 ret;       /* return code variable */
   /* clear CCIF to launch command */
  REG_BIT_SET(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET, FTFx_SSD_FSTAT_CCIF); 
  /* wait for completion of this command */
  while(0x0 == (REG_BIT_GET(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET, FTFx_SSD_FSTAT_CCIF)))
    {
        /* wait till CCIF bit is set */
        /* serve callback function if counter reaches limitation */
        if(NULL_CALLBACK != pSSDConfig->CallBack)
        {
            (pSSDConfig->CallBack)();
        }
    }
    ret = (REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET) & FTFx_SSD_FSTAT_ERROR_BITS);
    return(ret);
}

/* end of file */

