/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2013, All Rights Reserved  *
*************************************************************************

*************************************************************************
*                                                                       *
*        Standard Software Flash Driver For FTFx                        *
*                                                                       *
* FILE NAME     :  CopyToRam.c                                          *
* DATE          :  Nov 28, 2013                                         *
*                                                                       *
* AUTHOR        :  FPT Team                                             *
* E-mail        :  r56611@freescale.com                                 *
*                                                                       *
*************************************************************************/

/************************** CHANGES *************************************
1.0.0       11.28.2013      FPT Team      Initial version                                   
*************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

/************************************************************************
*
*  Function Name    : RelocateFunction
*  Description      : Relocate FlashCommandSequence to another address.
*  Arguments        : UINT32, UINT32, pFLASHCOMMANDSEQUENCE
*  Return Value     : pFLASHCOMMANDSEQUENCE
*
*************************************************************************/

UINT32 RelocateFunction(UINT32 dest, UINT32 size, UINT32 src)
{
    UINT32 temp;
    UINT16 value, i, *pSrc, *pDest;
    temp = PGM2DATA((UINT32)src - OFFSET);
    pSrc = (UINT16 *)temp;
    pDest = (UINT16 *)dest;
    temp = size >>1;
    for (i = 0; i < temp; i++)
    {      
        value = READ16(pSrc);     
        pSrc++ ;
        WRITE16(pDest, value);
        pDest++;
    }
    return ((UINT32)DATA2PGM((UINT32)dest + OFFSET));
}

/* end of file */
