/*
 * File:		dma_channels.h
 * Purpose:		DMA request macros for use on Pioneer processors.
 * 			This file gives default DMA channel assignments
 *			for all of the possible Kinetis module DMA requests.
 *
 *
 * Notes:		There are more DMA requests than DMA channels, so
 *			care should be taken to make sure that DMA channel
 *			assignments are unique for the modules that are 
 *			being used at any time. 
 */

#ifndef _DMA_CHANNELS_H
#define _DMA_CHANNELS_H

/********************************************************************/
/* NOTE: There are more DMA requests than DMA channels, so
 *       care should be taken to make sure that DMA channel
 *	 assignments are unique for the modules that are 
 *	 being used at any time. 
 *	
 *	 It is recommended that you read the appropriate DMAMUX_CHCFGn
 *	 register before updating it to verify it is 0x0. If the
 *	 DMAMUX_CHCFGn register is not zero, then that indicates the 
 *	 selected DMA channel might already be in use by another peripheral
 *	 (a more specific test would be to look for DMAMUX_CHCFGn[ENBL] set).
 *	 The module's DMA configuration routine can return an error
 *	 when this situation is detected.
 */
 
 
/* Default DMA channel assignments and module request macros */

/* UARTs */
#define DMA_CHANNEL_DISABLE	    0
#define DMA_TSI0     			1

#define DMA_UART0RX_CH			2
#define DMA_UART0TX_CH			3

#define DMA_UART1RX_CH			4
#define DMA_UART1TX_CH			5

#define DMA_UART2RX_CH			6
#define DMA_UART2TX_CH			7

#define DMA_UART3RX_CH		    8
#define DMA_UART3TX_CH			9

#define DMA_UART4_TXRX_CH       10

/* I2S/SAI */
#define DMA_I2S0_RX_CH 			12
#define DMA_I2S0_TX_CH			13

/* SPIs */
#define DMA_SPI0RX_CH			14
#define DMA_SPI0TX_CH			15

#define DMA_SPI1TXRX_CH			16

#define DMA_SPI2TXRX_CH			17

/* I2Cs */
#define DMA_I2C0_I2C3_CH		18
#define DMA_I2C1_I2C2_CH    	19

/* FTMs and TPMs */
#define DMA_FTM0CH0_CH			20
#define DMA_FTM0CH1_CH			21
#define DMA_FTM0CH2_CH			22
#define DMA_FTM0CH3_CH			23
#define DMA_FTM0CH4_CH			24
#define DMA_FTM0CH5_CH			25
#define DMA_FTM0CH6_CH			26
#define DMA_FTM0CH7_CH			27

#define DMA_FTM1CH0_TPM1CH0_CH	28
#define DMA_FTM1CH1_TPM1CH1_CH  29

#define DMA_FTM2CH0_TPM2CH0_CH	30
#define DMA_FTM2CH1_TPM2CH1_CH	31

#define DMA_FTM3CH0_CH			32
#define DMA_FTM3CH1_CH			33
#define DMA_FTM3CH2_CH			34
#define DMA_FTM3CH3_CH			35
#define DMA_FTM3CH4_CH			36
#define DMA_FTM3CH5_CH			37
#define DMA_FTM3CH6_CH			38
#define DMA_FTM3CH7_CH			39

/* ADCs */
#define DMA_ADC0_CH				40
#define DMA_ADC1_CH				41

/* HSCMPs */
#define DMA_CMP0_CH			    42
#define DMA_CMP1_CH			    43
#define DMA_CMP2CMP3_CH  	    44

/* 12-bit DAC */
#define DMA_12bDAC0_CH			45
#define DMA_12bDAC1_CH			46

/* CMT */
#define DMA_CMT_CH				47

/* PDB */
#define DMA_PDB_CH				48

/* GPIO Ports */
#define DMA_GPIOPORTA_CH		49
#define DMA_GPIOPORTB_CH	    50
#define DMA_GPIOPORTC_CH		51
#define DMA_GPIOPORTD_CH		52
#define DMA_GPIOPORTE_CH		53

/* Ethernet timers - 1588 */
#define DMA_ENETTMR0_CH			54
#define DMA_ENETTMR1_TPM1_CH	55
#define DMA_ENETTMR2_TPM2_CH	56
#define DMA_ENETTMR3_CH			57

/* LPUART0 */
#define DMA_LPUART0_RX_CH       58
#define DMA_LPUART0_TX_CH       59

/* Always enable */
#define DMA_ALWAYS_EN0_CH       60
#define DMA_ALWAYS_EN1_CH       61
#define DMA_ALWAYS_EN2_CH       62
#define DMA_ALWAYS_EN3_CH       63
 
/********************************************************************/

#endif /* _DMA_CHANNELS_H */
