/*
 * File:		io.c
 * Purpose:		Serial Input/Output routines
 *
 * Notes:       TERMINAL_PORT defined in <board>.h
 */

#include "common.h"
#include "lpuart.h"

/********************************************************************/
char
in_char (void)
{
    return lpuart_getchar(LPTERM_PORT);
}
/********************************************************************/
void
out_char (char ch)
{
    lpuart_putchar(LPTERM_PORT, ch);
}
/********************************************************************/
int
char_present (void)
{
    return lpuart_getchar_present(LPTERM_PORT);
}
/********************************************************************/
