/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS {

// Define Boot Header area Size
   BOOTFLASH_SIZE = 0x20
// Define Boot Header area Base Address
   BOOTFLASH_BASE_ADDR = 0x01000000

// Define Core 2 Flash Allocation
   FLASH_SIZE = 256K - BOOTFLASH_SIZE      
// Define Core 2 Flash Base Address 
   FLASH_BASE_ADDR =  BOOTFLASH_BASE_ADDR + BOOTFLASH_SIZE
        
// Define Core 2 SRAM Allocation  
   C2_SRAM_SIZE =  96K    
// Define Processor 2 SRAM Base Address
   C2_SRAM_BASE_ADDR = 0x40000000    

// Define Core 2 Local Instruction SRAM Allocation  
   C2_LOCALIMEM_SIZE =  16K    
// Define Processor 2 Local Instruction SRAM Base Address
   C2_LOCALIMEM_BASE_ADDR = 0x52000000   
   
// Define Core 2 Local Data SRAM Allocation  
   C2_LOCALDMEM_SIZE =  64K    
// Define Processor 2 Local Data SRAM Base Address
   C2_LOCALDMEM_BASE_ADDR = 0x52800000    

// Stack located at end of SRAM     
// Define Stack Size
   STACK_SIZE = 1K       
       
}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/
MEMORY {
//    bootflash : org = BOOTFLASH_BASE_ADDR, len = BOOTFLASH_SIZE
//    int_flash : org = FLASH_BASE_ADDR,     len = FLASH_SIZE
    int_sram  : org = C2_SRAM_BASE_ADDR,   len = C2_SRAM_SIZE-STACK_SIZE
//    stack_ram : org = (C2_SRAM_BASE_ADDR+C2_SRAM_SIZE-STACK_SIZE)  len = STACK_SIZE
//     stack_ram : org = C2_LOCALDMEM_BASE_ADDR  len = STACK_SIZE

    int_iram  : org = C2_LOCALIMEM_BASE_ADDR,   len = C2_LOCALIMEM_SIZE
    int_dram  : org = C2_LOCALDMEM_BASE_ADDR,   len = C2_LOCALDMEM_SIZE-STACK_SIZE
    stack_ram : org = (C2_LOCALDMEM_BASE_ADDR+C2_LOCALDMEM_SIZE-STACK_SIZE)  len = STACK_SIZE     
}

SECTIONS
{ 
//  .bh               : {} >  bootflash
    
    .init             : {} > int_sram
    .mc_mode_init     : {mcu_init_RAM.o(.vletext)} > int_iram       /* target to Core 2 local RAM */       
    .text             : {} > int_sram       /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */
                                            
    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */

    .xptn_vectors ALIGN(0x1000)   : {} > int_sram   /* Exception Vector Table (IVPR) - align 4K boundary */
    .IVOR4_Handler ALIGN(0x1000)  : {} > .          /* IVOR4 HW Vector Table (IVPR) - align 4K boundary */	
    .isrvectbl    ALIGN(0x1000)   : {} > .          /* ISR Vector Table - must be 4K aligned */
     
    .data             : {} > int_sram       /* Initialised Data                */
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/
    .mc_mode_init_data : {} > int_dram      /* data for mc_mode_init functions */
    
    .heap   ALIGN(16) PAD(1K)         : {} > int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */

 

/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/

/*-------- LABELS USED IN CODE -------------------------------*/
        
/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);

__DATA_SIZE   = SIZEOF(.data);
__SDATA_SIZE  = SIZEOF(.sdata);


/* Labels Used for Initialising SRAM ECC */        
__SRAM_SIZE=128k;
__SRAM_BASE_ADDR =C2_SRAM_BASE_ADDR;

/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
//    __ghs_romstart  = MEMADDR(int_flash);
//    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
//    __ghs_rombootcodestart = MEMADDR(int_flash);
//    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}
