/**************************************************************************/
/* FILE NAME:                              COPYRIGHT (c) Freescale 2008   */
/* MPC56xx_55xx_Dual_PRC0_Interrupt_Init.c        All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This is the interrupt controller configuration file.                   */
/*=========================================================================*/
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1    R. Moran       10/12/2008    Initial Version                    */
/**************************************************************************/
#include "../../headers/project.h"

/*========================================================================*/
/*                      GLOBAL VARIABLES                                  */
/*========================================================================*/

extern const uint32_t IntcIsrVectorTable[];

/*========================================================================*/
/*                      EXTERNAL PROTOTYPES                               */
/*========================================================================*/

extern void e200zX_Interrupt_Setup(void);

/*========================================================================*/
/*                          FUNCTIONS                                     */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : InitINTC                                                */
/* PURPOSE      : This function intializes the INTC for software vector   */
/*                mode.                                                   */
/**************************************************************************/
void InitINTC(void) {   

 vint16_t temp;
    
// Choose software (HVEN=0) or hardware (HVEN=1) vector mode
 INTC_0.BCR.R = 0x00000000;
        
 temp = INTC_0.IACKR[2].R; 	      //read IACKR before enabling interrupts
    
// Set INTC ISR vector table base addr.
 INTC_0.IACKR[2].R = (uint32_t) &IntcIsrVectorTable[0]; 
}


/**************************************************************************/
/* FUNCTION     : enableIrq                                               */
/* PURPOSE      : This function sets INTC's current priority to 0.        */
/*                External interrupts to the core are enabled.            */
/**************************************************************************/
void enableIrq(void) {
    
    // Ensure INTC's current priority is 0
    INTC_0.CPR[2].B.PRI = 0;
    
    // Enable external interrupts
    asm(" wrteei 1");       
}

/**************************************************************************/
/* FUNCTION     : Init_INTC_Priority                                      */
/* PURPOSE      : This function configures the priotrty level for the     */
/*                interrupts. Add configs as required.                    */
/**************************************************************************/



void Init_INTC_Priority(void){
    INTC_0.PSR[69].R = 0x201F;   // set IRQ69 (DMA 16) to interrupt processor 2 and  have a priority of 2
    INTC_0.PSR[228].R = 0x2001; // set IRQ228 (PIT1 chan 2) to interrupt processor 2 and  have a priority of 1

    INTC_0.PSR[229].R = 0x2001; // set IRQ229 (PIT1  3) to interrupt processor 2 and  have a priority of 1
#ifdef Int_Drain  //Only enable SDADC interrupts if using Interrupt drain method
    INTC_0.PSR[545].R = 0x201F;   // set IRQ546 (IRQ 546) SDADC 1 to interrupt processor 2 and  have a priority of 3
#endif
	}

/**************************************************************************/
/* FUNCTION     : xcptn_xmpl                                              */
/* PURPOSE      : This function sets up the necessary functions to raise  */
/*                and handle a SWT Interrupt in hardware vector mode      */
/**************************************************************************/
void xcptn_xmpl(void) {
    
    // Initialise Core IVPR and IVOR Registers
    e200zX_Interrupt_Setup();       
    
    // Initialize INTC for SW vector mode
    InitINTC();               
    
    // Initialise Interrupt Priorities - set in "ISR_Routines.c"
    Init_INTC_Priority();

    // Enable interrupts
    enableIrq();

}


