/** ###################################################################
 **     Filename    : TMR_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the TMR module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void TMR_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file TMR_Init.c
 * @version 1.0
 * @brief This file implements the TMR module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE TMR_Init. */

#include "TMR_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void TMR_Init(void) {

  /* Register 'TMR_0_CTRL' initialization */
  #ifdef TMR_0_CTRL_VALUE_1
  TMR_0_CTRL = TMR_0_CTRL_VALUE_1;
  #endif

  /* Register 'TMR_1_CTRL' initialization */
  #ifdef TMR_1_CTRL_VALUE_1
  TMR_1_CTRL = TMR_1_CTRL_VALUE_1;
  #endif

  /* Register 'TMR_2_CTRL' initialization */
  #ifdef TMR_2_CTRL_VALUE_1
  TMR_2_CTRL = TMR_2_CTRL_VALUE_1;
  #endif

  /* Register 'TMR_3_CTRL' initialization */
  #ifdef TMR_3_CTRL_VALUE_1
  TMR_3_CTRL = TMR_3_CTRL_VALUE_1;
  #endif

  TMR_0_ENBL = 0;

  /* Register 'TMR_0_SCTRL' initialization */
  #ifdef TMR_0_SCTRL_VALUE_1
  TMR_0_SCTRL = TMR_0_SCTRL_VALUE_1;
  #endif

  /* Register 'TMR_1_SCTRL' initialization */
  #ifdef TMR_1_SCTRL_VALUE_1
  TMR_1_SCTRL = TMR_1_SCTRL_VALUE_1;
  #endif

  /* Register 'TMR_2_SCTRL' initialization */
  #ifdef TMR_2_SCTRL_VALUE_1
  TMR_2_SCTRL = TMR_2_SCTRL_VALUE_1;
  #endif

  /* Register 'TMR_3_SCTRL' initialization */
  #ifdef TMR_3_SCTRL_VALUE_1
  TMR_3_SCTRL = TMR_3_SCTRL_VALUE_1;
  #endif

  /* Register 'TMR_0_CNTR' initialization */
  #ifdef TMR_0_CNTR_VALUE
  TMR_0_CNTR = TMR_0_CNTR_VALUE;
  #endif

  /* Register 'TMR_1_CNTR' initialization */
  #ifdef TMR_1_CNTR_VALUE
  TMR_1_CNTR = TMR_1_CNTR_VALUE;
  #endif

  /* Register 'TMR_2_CNTR' initialization */
  #ifdef TMR_2_CNTR_VALUE
  TMR_2_CNTR = TMR_2_CNTR_VALUE;
  #endif

  /* Register 'TMR_3_CNTR' initialization */
  #ifdef TMR_3_CNTR_VALUE
  TMR_3_CNTR = TMR_3_CNTR_VALUE;
  #endif

  /* Register 'TMR_0_HOLD' initialization */
  #ifdef TMR_0_HOLD_VALUE
  TMR_0_HOLD = TMR_0_HOLD_VALUE;
  #endif

  /* Register 'TMR_1_HOLD' initialization */
  #ifdef TMR_1_HOLD_VALUE
  TMR_1_HOLD = TMR_1_HOLD_VALUE;
  #endif

  /* Register 'TMR_2_HOLD' initialization */
  #ifdef TMR_2_HOLD_VALUE
  TMR_2_HOLD = TMR_2_HOLD_VALUE;
  #endif

  /* Register 'TMR_3_HOLD' initialization */
  #ifdef TMR_3_HOLD_VALUE
  TMR_3_HOLD = TMR_3_HOLD_VALUE;
  #endif

  /* Register 'TMR_0_LOAD' initialization */
  #ifdef TMR_0_LOAD_VALUE
  TMR_0_LOAD = TMR_0_LOAD_VALUE;
  #endif

  /* Register 'TMR_1_LOAD' initialization */
  #ifdef TMR_1_LOAD_VALUE
  TMR_1_LOAD = TMR_1_LOAD_VALUE;
  #endif

  /* Register 'TMR_2_LOAD' initialization */
  #ifdef TMR_2_LOAD_VALUE
  TMR_2_LOAD = TMR_2_LOAD_VALUE;
  #endif

  /* Register 'TMR_3_LOAD' initialization */
  #ifdef TMR_3_LOAD_VALUE
  TMR_3_LOAD = TMR_3_LOAD_VALUE;
  #endif

  /* Register 'TMR_0_COMP1' initialization */
  #ifdef TMR_0_COMP1_VALUE
  TMR_0_COMP1 = TMR_0_COMP1_VALUE;
  #endif

  /* Register 'TMR_1_COMP1' initialization */
  #ifdef TMR_1_COMP1_VALUE
  TMR_1_COMP1 = TMR_1_COMP1_VALUE;
  #endif

  /* Register 'TMR_2_COMP1' initialization */
  #ifdef TMR_2_COMP1_VALUE
  TMR_2_COMP1 = TMR_2_COMP1_VALUE;
  #endif

  /* Register 'TMR_3_COMP1' initialization */
  #ifdef TMR_3_COMP1_VALUE
  TMR_3_COMP1 = TMR_3_COMP1_VALUE;
  #endif

  /* Register 'TMR_0_CMPLD1' initialization */
  #ifdef TMR_0_CMPLD1_VALUE
  TMR_0_CMPLD1 = TMR_0_CMPLD1_VALUE;
  #endif

  /* Register 'TMR_1_CMPLD1' initialization */
  #ifdef TMR_1_CMPLD1_VALUE
  TMR_1_CMPLD1 = TMR_1_CMPLD1_VALUE;
  #endif

  /* Register 'TMR_2_CMPLD1' initialization */
  #ifdef TMR_2_CMPLD1_VALUE
  TMR_2_CMPLD1 = TMR_2_CMPLD1_VALUE;
  #endif

  /* Register 'TMR_3_CMPLD1' initialization */
  #ifdef TMR_3_CMPLD1_VALUE
  TMR_3_CMPLD1 = TMR_3_CMPLD1_VALUE;
  #endif

  /* Register 'TMR_0_COMP2' initialization */
  #ifdef TMR_0_COMP2_VALUE
  TMR_0_COMP2 = TMR_0_COMP2_VALUE;
  #endif

  /* Register 'TMR_1_COMP2' initialization */
  #ifdef TMR_1_COMP2_VALUE
  TMR_1_COMP2 = TMR_1_COMP2_VALUE;
  #endif

  /* Register 'TMR_2_COMP2' initialization */
  #ifdef TMR_2_COMP2_VALUE
  TMR_2_COMP2 = TMR_2_COMP2_VALUE;
  #endif

  /* Register 'TMR_3_COMP2' initialization */
  #ifdef TMR_3_COMP2_VALUE
  TMR_3_COMP2 = TMR_3_COMP2_VALUE;
  #endif

  /* Register 'TMR_0_CMPLD2' initialization */
  #ifdef TMR_0_CMPLD2_VALUE
  TMR_0_CMPLD2 = TMR_0_CMPLD2_VALUE;
  #endif

  /* Register 'TMR_1_CMPLD2' initialization */
  #ifdef TMR_1_CMPLD2_VALUE
  TMR_1_CMPLD2 = TMR_1_CMPLD2_VALUE;
  #endif

  /* Register 'TMR_2_CMPLD2' initialization */
  #ifdef TMR_2_CMPLD2_VALUE
  TMR_2_CMPLD2 = TMR_2_CMPLD2_VALUE;
  #endif

  /* Register 'TMR_3_CMPLD2' initialization */
  #ifdef TMR_3_CMPLD2_VALUE
  TMR_3_CMPLD2 = TMR_3_CMPLD2_VALUE;
  #endif

  /* Register 'TMR_0_CAPT' initialization */
  #ifdef TMR_0_CAPT_VALUE
  TMR_0_CAPT = TMR_0_CAPT_VALUE;
  #endif

  /* Register 'TMR_1_CAPT' initialization */
  #ifdef TMR_1_CAPT_VALUE
  TMR_1_CAPT = TMR_1_CAPT_VALUE;
  #endif

  /* Register 'TMR_2_CAPT' initialization */
  #ifdef TMR_2_CAPT_VALUE
  TMR_2_CAPT = TMR_2_CAPT_VALUE;
  #endif

  /* Register 'TMR_3_CAPT' initialization */
  #ifdef TMR_3_CAPT_VALUE
  TMR_3_CAPT = TMR_3_CAPT_VALUE;
  #endif

  /* Register 'TMR_0_SCTRL' initialization */
  #if TMR_0_SCTRL_MASK_2
    #if TMR_0_SCTRL_MASK_2 == 0xFFFF
  TMR_0_SCTRL = TMR_0_SCTRL_VALUE_2;
    #elif TMR_0_SCTRL_MASK_2 == TMR_0_SCTRL_VALUE_2
  TMR_0_SCTRL |= TMR_0_SCTRL_VALUE_2;
    #elif TMR_0_SCTRL_VALUE_2 == 0
  TMR_0_SCTRL &= ~TMR_0_SCTRL_MASK_2;
    #else
  TMR_0_SCTRL = (TMR_0_SCTRL & (~TMR_0_SCTRL_MASK_2)) | TMR_0_SCTRL_VALUE_2;
    #endif
  #elif defined(TMR_0_SCTRL_VALUE_2)
  TMR_0_SCTRL = TMR_0_SCTRL_VALUE_2;
  #endif

  /* Register 'TMR_1_SCTRL' initialization */
  #if TMR_1_SCTRL_MASK_2
    #if TMR_1_SCTRL_MASK_2 == 0xFFFF
  TMR_1_SCTRL = TMR_1_SCTRL_VALUE_2;
    #elif TMR_1_SCTRL_MASK_2 == TMR_1_SCTRL_VALUE_2
  TMR_1_SCTRL |= TMR_1_SCTRL_VALUE_2;
    #elif TMR_1_SCTRL_VALUE_2 == 0
  TMR_1_SCTRL &= ~TMR_1_SCTRL_MASK_2;
    #else
  TMR_1_SCTRL = (TMR_1_SCTRL & (~TMR_1_SCTRL_MASK_2)) | TMR_1_SCTRL_VALUE_2;
    #endif
  #elif defined(TMR_1_SCTRL_VALUE_2)
  TMR_1_SCTRL = TMR_1_SCTRL_VALUE_2;
  #endif

  /* Register 'TMR_2_SCTRL' initialization */
  #if TMR_2_SCTRL_MASK_2
    #if TMR_2_SCTRL_MASK_2 == 0xFFFF
  TMR_2_SCTRL = TMR_2_SCTRL_VALUE_2;
    #elif TMR_2_SCTRL_MASK_2 == TMR_2_SCTRL_VALUE_2
  TMR_2_SCTRL |= TMR_2_SCTRL_VALUE_2;
    #elif TMR_2_SCTRL_VALUE_2 == 0
  TMR_2_SCTRL &= ~TMR_2_SCTRL_MASK_2;
    #else
  TMR_2_SCTRL = (TMR_2_SCTRL & (~TMR_2_SCTRL_MASK_2)) | TMR_2_SCTRL_VALUE_2;
    #endif
  #elif defined(TMR_2_SCTRL_VALUE_2)
  TMR_2_SCTRL = TMR_2_SCTRL_VALUE_2;
  #endif

  /* Register 'TMR_3_SCTRL' initialization */
  #if TMR_3_SCTRL_MASK_2
    #if TMR_3_SCTRL_MASK_2 == 0xFFFF
  TMR_3_SCTRL = TMR_3_SCTRL_VALUE_2;
    #elif TMR_3_SCTRL_MASK_2 == TMR_3_SCTRL_VALUE_2
  TMR_3_SCTRL |= TMR_3_SCTRL_VALUE_2;
    #elif TMR_3_SCTRL_VALUE_2 == 0
  TMR_3_SCTRL &= ~TMR_3_SCTRL_MASK_2;
    #else
  TMR_3_SCTRL = (TMR_3_SCTRL & (~TMR_3_SCTRL_MASK_2)) | TMR_3_SCTRL_VALUE_2;
    #endif
  #elif defined(TMR_3_SCTRL_VALUE_2)
  TMR_3_SCTRL = TMR_3_SCTRL_VALUE_2;
  #endif

  /* Register 'TMR_0_CSCTRL' initialization */
  #if TMR_0_CSCTRL_MASK
    #if TMR_0_CSCTRL_MASK == 0xFFFF
  TMR_0_CSCTRL = TMR_0_CSCTRL_VALUE;
    #elif TMR_0_CSCTRL_MASK == TMR_0_CSCTRL_VALUE
  TMR_0_CSCTRL |= TMR_0_CSCTRL_VALUE;
    #elif TMR_0_CSCTRL_VALUE == 0
  TMR_0_CSCTRL &= ~TMR_0_CSCTRL_MASK;
    #else
  TMR_0_CSCTRL = (TMR_0_CSCTRL & (~TMR_0_CSCTRL_MASK)) | TMR_0_CSCTRL_VALUE;
    #endif
  #elif defined(TMR_0_CSCTRL_VALUE)
  TMR_0_CSCTRL = TMR_0_CSCTRL_VALUE;
  #endif

  /* Register 'TMR_1_CSCTRL' initialization */
  #if TMR_1_CSCTRL_MASK
    #if TMR_1_CSCTRL_MASK == 0xFFFF
  TMR_1_CSCTRL = TMR_1_CSCTRL_VALUE;
    #elif TMR_1_CSCTRL_MASK == TMR_1_CSCTRL_VALUE
  TMR_1_CSCTRL |= TMR_1_CSCTRL_VALUE;
    #elif TMR_1_CSCTRL_VALUE == 0
  TMR_1_CSCTRL &= ~TMR_1_CSCTRL_MASK;
    #else
  TMR_1_CSCTRL = (TMR_1_CSCTRL & (~TMR_1_CSCTRL_MASK)) | TMR_1_CSCTRL_VALUE;
    #endif
  #elif defined(TMR_1_CSCTRL_VALUE)
  TMR_1_CSCTRL = TMR_1_CSCTRL_VALUE;
  #endif

  /* Register 'TMR_2_CSCTRL' initialization */
  #if TMR_2_CSCTRL_MASK
    #if TMR_2_CSCTRL_MASK == 0xFFFF
  TMR_2_CSCTRL = TMR_2_CSCTRL_VALUE;
    #elif TMR_2_CSCTRL_MASK == TMR_2_CSCTRL_VALUE
  TMR_2_CSCTRL |= TMR_2_CSCTRL_VALUE;
    #elif TMR_2_CSCTRL_VALUE == 0
  TMR_2_CSCTRL &= ~TMR_2_CSCTRL_MASK;
    #else
  TMR_2_CSCTRL = (TMR_2_CSCTRL & (~TMR_2_CSCTRL_MASK)) | TMR_2_CSCTRL_VALUE;
    #endif
  #elif defined(TMR_2_CSCTRL_VALUE)
  TMR_2_CSCTRL = TMR_2_CSCTRL_VALUE;
  #endif

  /* Register 'TMR_3_CSCTRL' initialization */
  #if TMR_3_CSCTRL_MASK
    #if TMR_3_CSCTRL_MASK == 0xFFFF
  TMR_3_CSCTRL = TMR_3_CSCTRL_VALUE;
    #elif TMR_3_CSCTRL_MASK == TMR_3_CSCTRL_VALUE
  TMR_3_CSCTRL |= TMR_3_CSCTRL_VALUE;
    #elif TMR_3_CSCTRL_VALUE == 0
  TMR_3_CSCTRL &= ~TMR_3_CSCTRL_MASK;
    #else
  TMR_3_CSCTRL = (TMR_3_CSCTRL & (~TMR_3_CSCTRL_MASK)) | TMR_3_CSCTRL_VALUE;
    #endif
  #elif defined(TMR_3_CSCTRL_VALUE)
  TMR_3_CSCTRL = TMR_3_CSCTRL_VALUE;
  #endif

  /* Register 'TMR_0_FILT' initialization */
  #if TMR_0_FILT_MASK
    #if TMR_0_FILT_MASK == 0xFFFF
  TMR_0_FILT = TMR_0_FILT_VALUE;
    #elif TMR_0_FILT_MASK == TMR_0_FILT_VALUE
  TMR_0_FILT |= TMR_0_FILT_VALUE;
    #elif TMR_0_FILT_VALUE == 0
  TMR_0_FILT &= ~TMR_0_FILT_MASK;
    #else
  TMR_0_FILT = (TMR_0_FILT & (~TMR_0_FILT_MASK)) | TMR_0_FILT_VALUE;
    #endif
  #elif defined(TMR_0_FILT_VALUE)
  TMR_0_FILT = TMR_0_FILT_VALUE;
  #endif

  /* Register 'TMR_1_FILT' initialization */
  #if TMR_1_FILT_MASK
    #if TMR_1_FILT_MASK == 0xFFFF
  TMR_1_FILT = TMR_1_FILT_VALUE;
    #elif TMR_1_FILT_MASK == TMR_1_FILT_VALUE
  TMR_1_FILT |= TMR_1_FILT_VALUE;
    #elif TMR_1_FILT_VALUE == 0
  TMR_1_FILT &= ~TMR_1_FILT_MASK;
    #else
  TMR_1_FILT = (TMR_1_FILT & (~TMR_1_FILT_MASK)) | TMR_1_FILT_VALUE;
    #endif
  #elif defined(TMR_1_FILT_VALUE)
  TMR_1_FILT = TMR_1_FILT_VALUE;
  #endif

  /* Register 'TMR_2_FILT' initialization */
  #if TMR_2_FILT_MASK
    #if TMR_2_FILT_MASK == 0xFFFF
  TMR_2_FILT = TMR_2_FILT_VALUE;
    #elif TMR_2_FILT_MASK == TMR_2_FILT_VALUE
  TMR_2_FILT |= TMR_2_FILT_VALUE;
    #elif TMR_2_FILT_VALUE == 0
  TMR_2_FILT &= ~TMR_2_FILT_MASK;
    #else
  TMR_2_FILT = (TMR_2_FILT & (~TMR_2_FILT_MASK)) | TMR_2_FILT_VALUE;
    #endif
  #elif defined(TMR_2_FILT_VALUE)
  TMR_2_FILT = TMR_2_FILT_VALUE;
  #endif

  /* Register 'TMR_3_FILT' initialization */
  #if TMR_3_FILT_MASK
    #if TMR_3_FILT_MASK == 0xFFFF
  TMR_3_FILT = TMR_3_FILT_VALUE;
    #elif TMR_3_FILT_MASK == TMR_3_FILT_VALUE
  TMR_3_FILT |= TMR_3_FILT_VALUE;
    #elif TMR_3_FILT_VALUE == 0
  TMR_3_FILT &= ~TMR_3_FILT_MASK;
    #else
  TMR_3_FILT = (TMR_3_FILT & (~TMR_3_FILT_MASK)) | TMR_3_FILT_VALUE;
    #endif
  #elif defined(TMR_3_FILT_VALUE)
  TMR_3_FILT = TMR_3_FILT_VALUE;
  #endif

  /* Register 'TMR_0_DMA' initialization */
  #if TMR_0_DMA_MASK
    #if TMR_0_DMA_MASK == 0xFFFF
  TMR_0_DMA = TMR_0_DMA_VALUE;
    #elif TMR_0_DMA_MASK == TMR_0_DMA_VALUE
  TMR_0_DMA |= TMR_0_DMA_VALUE;
    #elif TMR_0_DMA_VALUE == 0
  TMR_0_DMA &= ~TMR_0_DMA_MASK;
    #else
  TMR_0_DMA = (TMR_0_DMA & (~TMR_0_DMA_MASK)) | TMR_0_DMA_VALUE;
    #endif
  #elif defined(TMR_0_DMA_VALUE)
  TMR_0_DMA = TMR_0_DMA_VALUE;
  #endif

  /* Register 'TMR_1_DMA' initialization */
  #if TMR_1_DMA_MASK
    #if TMR_1_DMA_MASK == 0xFFFF
  TMR_1_DMA = TMR_1_DMA_VALUE;
    #elif TMR_1_DMA_MASK == TMR_1_DMA_VALUE
  TMR_1_DMA |= TMR_1_DMA_VALUE;
    #elif TMR_1_DMA_VALUE == 0
  TMR_1_DMA &= ~TMR_1_DMA_MASK;
    #else
  TMR_1_DMA = (TMR_1_DMA & (~TMR_1_DMA_MASK)) | TMR_1_DMA_VALUE;
    #endif
  #elif defined(TMR_1_DMA_VALUE)
  TMR_1_DMA = TMR_1_DMA_VALUE;
  #endif

  /* Register 'TMR_2_DMA' initialization */
  #if TMR_2_DMA_MASK
    #if TMR_2_DMA_MASK == 0xFFFF
  TMR_2_DMA = TMR_2_DMA_VALUE;
    #elif TMR_2_DMA_MASK == TMR_2_DMA_VALUE
  TMR_2_DMA |= TMR_2_DMA_VALUE;
    #elif TMR_2_DMA_VALUE == 0
  TMR_2_DMA &= ~TMR_2_DMA_MASK;
    #else
  TMR_2_DMA = (TMR_2_DMA & (~TMR_2_DMA_MASK)) | TMR_2_DMA_VALUE;
    #endif
  #elif defined(TMR_2_DMA_VALUE)
  TMR_2_DMA = TMR_2_DMA_VALUE;
  #endif

  /* Register 'TMR_3_DMA' initialization */
  #if TMR_3_DMA_MASK
    #if TMR_3_DMA_MASK == 0xFFFF
  TMR_3_DMA = TMR_3_DMA_VALUE;
    #elif TMR_3_DMA_MASK == TMR_3_DMA_VALUE
  TMR_3_DMA |= TMR_3_DMA_VALUE;
    #elif TMR_3_DMA_VALUE == 0
  TMR_3_DMA &= ~TMR_3_DMA_MASK;
    #else
  TMR_3_DMA = (TMR_3_DMA & (~TMR_3_DMA_MASK)) | TMR_3_DMA_VALUE;
    #endif
  #elif defined(TMR_3_DMA_VALUE)
  TMR_3_DMA = TMR_3_DMA_VALUE;
  #endif

  /* Register 'TMR_0_CTRL' initialization */
  #ifdef TMR_0_CTRL_VALUE_2
  TMR_0_CTRL = TMR_0_CTRL_VALUE_2;
  #endif

  /* Register 'TMR_1_CTRL' initialization */
  #ifdef TMR_1_CTRL_VALUE_2
  TMR_1_CTRL = TMR_1_CTRL_VALUE_2;
  #endif

  /* Register 'TMR_2_CTRL' initialization */
  #ifdef TMR_2_CTRL_VALUE_2
  TMR_2_CTRL = TMR_2_CTRL_VALUE_2;
  #endif

  /* Register 'TMR_3_CTRL' initialization */
  #ifdef TMR_3_CTRL_VALUE_2
  TMR_3_CTRL = TMR_3_CTRL_VALUE_2;
  #endif

  /* Register 'TMR_0_ENBL' initialization */
  #ifdef TMR_0_ENBL_VALUE
  TMR_0_ENBL = TMR_0_ENBL_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END TMR_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
