/** ###################################################################
 **     Filename    : PIT0_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the PIT0 module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void PIT0_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file PIT0_Init.c
 * @version 1.0
 * @brief This file implements the PIT0 module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE PIT0_Init. */

#include "PIT0_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void PIT0_Init(void) {

  PIT0_CTRL = 0;

  /* Register 'PIT0_MOD' initialization */
  #ifdef PIT0_MOD_VALUE
  PIT0_MOD = PIT0_MOD_VALUE;
  #endif

  /* Register 'PIT0_CTRL' initialization */
  #ifdef PIT0_CTRL_VALUE
  PIT0_CTRL = PIT0_CTRL_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END PIT0_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
