/** ###################################################################
 **     Filename    : MCM_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the MCM module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void MCM_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file MCM_Init.c
 * @version 1.0
 * @brief This file implements the MCM module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE MCM_Init. */

#include "MCM_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void MCM_Init(void) {


  /* Register 'MCM_UPRAMBAR' initialization */
  #ifdef MCM_UPRAMBAR_VALUE
  MCM_UPRAMBAR = MCM_UPRAMBAR_VALUE;
  #endif

  /* Register 'MCM_UFLASHBAR' initialization */
  #ifdef MCM_UFLASHBAR_VALUE
  MCM_UFLASHBAR = MCM_UFLASHBAR_VALUE;
  #endif

  /* Register 'MCM_CPCR' initialization */
  #ifdef MCM_CPCR_VALUE
  MCM_CPCR = MCM_CPCR_VALUE;
  #endif

  /* Register 'MCM_CFISR' initialization */
  #ifdef MCM_CFISR_VALUE
  MCM_CFISR = MCM_CFISR_VALUE;
  #endif

  /* Register 'MCM_CFIER' initialization */
  #ifdef MCM_CFIER_VALUE
  MCM_CFIER = MCM_CFIER_VALUE;
  #endif
            /* Register 'MCM_SRPOSP' initialization */
  #ifdef MCM_SRPOSP_VALUE
  MCM_SRPOSP = MCM_SRPOSP_VALUE;
  #endif

  /* Register 'MCM_RPCR' initialization */
  #ifdef MCM_RPCR_VALUE
  MCM_RPCR = MCM_RPCR_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END MCM_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
