/** ###################################################################
 **     Filename    : I2C_Init.h
 **     Processor   : MC56F82748VLH
 **     Version     : 1.6
 **     Abstract    :
 **          This file implements the I2C module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void I2C_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file I2C_Init.h
 * @version 1.6
 * @brief This file implements the I2C module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE I2C_Init. */


/* ----------------------------------------------------------------------------
   -- I2C_Init module documentation
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Init_module I2C_Init module documentation
 * @{
 */

#ifdef __cplusplus
extern "C" {
#endif

extern void I2C_Init(void);

#ifdef __cplusplus
}
#endif

/*!
 * @}
 */ /* end of group I2C_Init_module */


/* END I2C_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
