/** ###################################################################
 **     Filename    : FTFA_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.8
 **     Abstract    :
 **          This file implements the FTFA module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void FTFA_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file FTFA_Init.c
 * @version 1.8
 * @brief This file implements the FTFA module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE FTFA_Init. */

#include "FTFA_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void FTFA_Init(void) {

  /* Register 'FTFA_FSTAT' initialization */
  #ifdef FTFA_FSTAT_VALUE
  FTFA_FSTAT = FTFA_FSTAT_VALUE;
  #endif

  /* Register 'FTFA_FPROT0' initialization */
  #ifdef FTFA_FPROT0_VALUE
  FTFA_FPROT0 = FTFA_FPROT0_VALUE;
  #endif

  /* Register 'FTFA_FPROT1' initialization */
  #ifdef FTFA_FPROT1_VALUE
  FTFA_FPROT1 = FTFA_FPROT1_VALUE;
  #endif

  /* Register 'FTFA_FPROT2' initialization */
  #ifdef FTFA_FPROT2_VALUE
  FTFA_FPROT2 = FTFA_FPROT2_VALUE;
  #endif

  /* Register 'FTFA_FPROT3' initialization */
  #ifdef FTFA_FPROT3_VALUE
  FTFA_FPROT3 = FTFA_FPROT3_VALUE;
  #endif

  /* Register 'FTFA_FCNFG' initialization */
  #ifdef FTFA_FCNFG_VALUE
  FTFA_FCNFG = FTFA_FCNFG_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END FTFA_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
