/** ###################################################################
 **     Filename    : CMPD_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.7
 **     Abstract    :
 **          This file implements the CMPD module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void CMPD_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file CMPD_Init.c
 * @version 1.7
 * @brief This file implements the CMPD module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE CMPD_Init. */

#include "CMPD_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void CMPD_Init(void) {

  CMPD_CR1 = 0;

  CMPD_CR0 = 0;

  CMPD_MUXCR = 0;

  /* Register 'CMPD_FPR' initialization */
  #if CMPD_FPR_MASK
    #if CMPD_FPR_MASK == 0xFFFF
  CMPD_FPR = CMPD_FPR_VALUE;
    #elif CMPD_FPR_MASK == CMPD_FPR_VALUE
  CMPD_FPR |= CMPD_FPR_VALUE;
    #elif CMPD_FPR_VALUE == 0
  CMPD_FPR &= ~CMPD_FPR_MASK;
    #else
  CMPD_FPR = (CMPD_FPR & (~CMPD_FPR_MASK)) | CMPD_FPR_VALUE;
    #endif
  #elif defined(CMPD_FPR_VALUE)
  CMPD_FPR = CMPD_FPR_VALUE;
  #endif

  /* Register 'CMPD_CR1' initialization */
  #ifdef CMPD_CR1_VALUE_1
  CMPD_CR1 = CMPD_CR1_VALUE_1;
  #endif

  /* Register 'CMPD_SCR' initialization */
  #ifdef CMPD_SCR_VALUE
  CMPD_SCR = CMPD_SCR_VALUE;
  #endif

  /* Register 'CMPD_CR0' initialization */
  #ifdef CMPD_CR0_VALUE
  CMPD_CR0 = CMPD_CR0_VALUE;
  #endif

  /* Register 'CMPD_DACCR' initialization */
  #if CMPD_DACCR_MASK
    #if CMPD_DACCR_MASK == 0xFFFF
  CMPD_DACCR = CMPD_DACCR_VALUE;
    #elif CMPD_DACCR_MASK == CMPD_DACCR_VALUE
  CMPD_DACCR |= CMPD_DACCR_VALUE;
    #elif CMPD_DACCR_VALUE == 0
  CMPD_DACCR &= ~CMPD_DACCR_MASK;
    #else
  CMPD_DACCR = (CMPD_DACCR & (~CMPD_DACCR_MASK)) | CMPD_DACCR_VALUE;
    #endif
  #elif defined(CMPD_DACCR_VALUE)
  CMPD_DACCR = CMPD_DACCR_VALUE;
  #endif

  /* Register 'CMPD_MUXCR' initialization */
  #ifdef CMPD_MUXCR_VALUE
  CMPD_MUXCR = CMPD_MUXCR_VALUE;
  #endif

  /* Register 'CMPD_CR1' initialization */
  #if CMPD_CR1_MASK_2
    #if CMPD_CR1_MASK_2 == 0xFFFF
  CMPD_CR1 = CMPD_CR1_VALUE_2;
    #elif CMPD_CR1_MASK_2 == CMPD_CR1_VALUE_2
  CMPD_CR1 |= CMPD_CR1_VALUE_2;
    #elif CMPD_CR1_VALUE_2 == 0
  CMPD_CR1 &= ~CMPD_CR1_MASK_2;
    #else
  CMPD_CR1 = (CMPD_CR1 & (~CMPD_CR1_MASK_2)) | CMPD_CR1_VALUE_2;
    #endif
  #elif defined(CMPD_CR1_VALUE_2)
  CMPD_CR1 = CMPD_CR1_VALUE_2;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END CMPD_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
