/* ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MC56F82748VLH
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2014-03-25, 10:26, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file ProcessorExpert.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup ProcessorExpert_module ProcessorExpert module documentation
**  @{
*/         
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Init_Config.h"
#include "PDD_Includes.h"

/*Data buffer with 128 elements (256bytes)*/
uint16_t DMA_Data[]= 
		{  0, 170,	 341,  512,  682,  853, 1024, 1194,
		1365, 1536,	1706, 1877, 2048, 2218, 2389, 2560,
		2730, 2901, 3072, 3242, 3413, 3584, 3754, 3925,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
		3925, 3754, 3584, 3413, 3242, 3072, 2901, 2730,
		2560, 2389, 2218, 2048, 1877, 1706, 1536, 1365,
		1194, 1024,  853,  682,  512,  341,  170,    0,
		   0,    0,    0,    0,    0,    0,    0,    0
};

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */

  for(;;) {
	  asm(nop);  
  }
}
#pragma interrupt saveall
/*DMA transfer done ISR */
void DMA_transfer_done_isr(void)
{

	DMA_DSR_BCR0 |= DMA_DSR_BCR_DONE_MASK; //clear interrupt flag
	DMA_DSR_BCR0 = DMA_DSR_BCR0_VALUE_2;   //reinitialize byte count
	
	/*SAR reinitialization is required if circular buffer is disabled*/
	//DMA_SAR0 = DMA_SAR0_VALUE;
	
	DMA_DCR0 |= DMA_DCR_ERQ_MASK;  //enable peripheral request
	
}

/* END ProcessorExpert */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.08]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
