/*
 * FTM.h
 *
 *  Created on: Sep 24, 2013
 *      Author: B46911
 */

#ifndef FTM_H_
#define FTM_H_
/*******************************************************************************
* Includes
********************************************************************************/
#include "derivative.h"

/*******************************************************************************
* Constants
********************************************************************************/


/*******************************************************************************
* Macros
********************************************************************************/

                
/*******************************************************************************
* Types
********************************************************************************/


/*******************************************************************************
* Variables
********************************************************************************/


/*******************************************************************************
* Global Variables
********************************************************************************/
extern UINT32 read_rpm;
extern UINT32 rpm_target;

/*******************************************************************************
* Global Functions
********************************************************************************/
/***********************************************************************************************
*
* @brief    FTM_Init - Initialize the FTM counter and enable
* @param    none
* @return   none
*
************************************************************************************************/
void FTM_Init();

/***********************************************************************************************
*
* @brief    FTM_SetCallback - Set the callback function to call on successful matches from any channel 
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/  
void FTM_SetCallback(pt2FuncU8 ptr);

/***********************************************************************************************
*
* @brief    FTM_SetPeriod - Set the period of the periodic interrupt
* @param    ch - channel to configure, per - period to set
* @return   none
*
************************************************************************************************/
void FTM_SetPeriod(UINT8 ch, UINT32 per);

#endif /* FTM_H_ */
