/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file usb_reg.h
 *
 * @author  
 *
 * @version 1.0
 *
 * @date Jul-03-2012
 *
 * @brief This file contains macros to control the USB regulator behavior
 *
 *****************************************************************************/

 #ifndef _USB_REG_H_
 #define _USB_REG_H_

 #include "common.h"
 
/****************************************************************************
*                                 Macros
****************************************************************************/
/******************************************************************************
*                                  USB REG
*
*                                 Silicon V1
******************************************************************************/

#if (defined(MCU_MK51DZ10))

/* Turn ON/OFF Regulator */
#define USB_REG_ON              SIM_SOPT1 |= SIM_SOPT1_USBREGEN_MASK
                                
#define USB_REG_OFF             SIM_SOPT1 &= ~SIM_SOPT1_USBREGEN_MASK

/* Enable/Disable enter to STDBY */   
                                  
#define USB_SSTBY_ON            asm("NOP")//SIM_SOPT1 |= SIM_SOPT1_USBSTBY_MASK
                                
#define USB_SSTBY_OFF           asm("NOP")//SIM_SOPT1 &= ~SIM_SOPT1_USBSTBY_MASK
                                       
#endif
          
/******************************************************************************
*                                    MCG
*
*                                 Silicon V2
******************************************************************************/

#if (defined(MCU_MK51D7) | defined(MCU_MK51D10) | defined(MCU_MK60D10))           
 
/* Turn ON/OFF Regulator */
#define USB_REG_ON              SIM_SOPT1CFG |= SIM_SOPT1CFG_URWE_MASK;\
                                SIM_SOPT1 |= SIM_SOPT1_USBREGEN_MASK
                                
#define USB_REG_OFF             SIM_SOPT1CFG |= SIM_SOPT1CFG_URWE_MASK;\
                                SIM_SOPT1 &= ~SIM_SOPT1_USBREGEN_MASK

/* Enable/Disable enter to STDBY on STOP, VLPS, LLS and VLLS */   
                                  
#define USB_SSTBY_ON            SIM_SOPT1CFG |= SIM_SOPT1CFG_USSWE_MASK;\
                                SIM_SOPT1 |= SIM_SOPT1_USBSSTBY_MASK
                                
#define USB_SSTBY_OFF           SIM_SOPT1CFG |= SIM_SOPT1CFG_USSWE_MASK;\
                                SIM_SOPT1 &= ~SIM_SOPT1_USBSSTBY_MASK
                                  
/* Enable/Disable enter to STBY on VLPR and VLPW modes */
   
#define USB_VSTBY_ON            SIM_SOPT1CFG |= SIM_SOPT1CFG_UVSWE_MASK;\
                                SIM_SOPT1 |= SIM_SOPT1_USBVSTBY_MASK
                                
#define USB_VSTBY_OFF           SIM_SOPT1CFG |= SIM_SOPT1CFG_UVSWE_MASK;\
                                SIM_SOPT1 &= ~SIM_SOPT1_USBVSTBY_MASK                        
#endif
                                  
#endif
/* End of file */