/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file opamp.c
 *
 * @author  
 *
 * @version 2.0
 *
 * @date Apr-19-2013
 *
 * @brief OpAmp drivers for Kinetis
 *
 *****************************************************************************/
 
/****************************************************************************
* Header files
****************************************************************************/
#include "opamp.h"

/***************************************************************************
* Functions
***************************************************************************/

/*******************************************************************************
* Function: vfnOpAmpInit
*
* Description: Initialize OpAmp module usign the opamp_config_t provided
*
* Input:
*       OpConfig: opamp_config_t structure containing the OpAmp configuration
*                 parameters
*
* Output: (none)
*******************************************************************************/
void vfnOpAmpInit(tOPAMP OpConfig)
{
    SIM_SCGC1 |= SIM_SCGC1_OPAMP_MASK;                                           //Enable clock on OpAmps

    OPAMP_C0_REG(OpConfig.OpAmpModule) = OpConfig.u8LowpowerOpmode | OPAMP_C0_EN_MASK;
    OPAMP_C2_REG(OpConfig.OpAmpModule) = OpConfig.u8AmppselAmpnsel;

    if(OpConfig.u8LowpowerOpmode & 0x01u)
     OPAMP_C1_REG(OpConfig.OpAmpModule) = OpConfig.u8Gain;
}

/*******************************************************************************
* Function: vfnOpAmpChangeGain
*
* Description: Change the selected OpAmp gain
*
* Input:
*       OpConfig: opamp_config_t structure containing the OpAmp configuration
*                 parameters
*       u8Gain: New gain value (see opamp.h for available gain values)
*
* Output: (none)
*******************************************************************************/
void vfnOpAmpChangeGain (tOPAMP OpConfig, unsigned char u8Gain)
{
    OPAMP_C1_REG(OpConfig.OpAmpModule) = u8Gain;
}