/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file mcg.h
 *
 * @author  
 *
 * @version 2.0
 *
 * @date Apr-12-2013
 *
 * @brief MCG clock generation routines
 *
 *****************************************************************************/
#ifndef __MCG_H__
#define __MCG_H__

/********************************************************************
*                            Header Files
********************************************************************/
#include "lptmr.h"
#include "derivative.h"

/********************************************************************
*                             Definitions
********************************************************************/
//Device specific out of reset frequency
#define MCG_OOR_FREQ_HZ		   20480	

//Device specific IRC frequencies
#define MCG_SLOW_IRC_HZ        32000
#define MCG_FAST_IRC_HZ        4000000

/********************************
*   List of clock modes
********************************/
typedef enum
{
  MCG_FEI,
  MCG_FEE,
  MCG_FBI,
  MCG_FBE,
  MCG_BLPI,
  MCG_BLPE,
  MCG_PBE,
  MCG_PEE
}MCG_CLOCK_MODES;

/*******************************
* list of available clock dividers
*******************************/
typedef enum
{
  CLKDIV_1,
  CLKDIV_2,
  CLKDIV_3,
  CLKDIV_4,
  CLKDIV_5,
  CLKDIV_6,
  CLKDIV_7,
  CLKDIV_8,
  CLKDIV_9,
  CLKDIV_10,
  CLKDIV_11,
  CLKDIV_12,
  CLKDIV_13,
  CLKDIV_14,
  CLKDIV_15,
  CLKDIV_16
}MCG_SIMCLK_DIVIDERS;

/*****************************************
* List of available PLL Output frequencies
*****************************************/
typedef enum
{
  PLL50,
  PLL100,
  PLL96,
  PLL48
}MCG_PLL_OPTIONS;

/******************************
* List of osc sources
******************************/
typedef enum{
  MCG_XTAL,
  MCG_EXTCLK
}MCG_OSC_SOURCES;

/******************************
*  List of available crystals 
******************************/
typedef enum
{
  XTAL2,
  XTAL4,
  XTAL6,
  XTAL8,
  XTAL10,
  XTAL12,
  XTAL14,
  XTAL16,
  XTAL18,
  XTAL20,
  XTAL22,
  XTAL24,
  XTAL26,
  XTAL28,
  XTAL30,
  XTAL32
}MCG_CRYSTAL_OPTIONS;

/******************************
*  List of available external clocks 
******************************/
typedef enum
{
 CLK4 = 2,
 CLK50 = 24
}MCG_EXTCLK_OPTIONS;

/*******************************
* List of available IRC clocks
********************************/
typedef enum
{
  MCG_IRC_FAST,
  MCG_IRC_SLOW
}MCG_AVAILABLE_IRC;

typedef enum
{
  MCG_OK,
  MCG_ERR
}MCG_ERROR_OPTIONS;

/********************************************************************
*                             Globals
********************************************************************/

extern unsigned char gu8ActualClkMode;                          //Actual MCG mode
extern unsigned long gu32McgFreqKhz;                            //Actual MCG freq
extern unsigned long gu32CoreFreqKhz;                           //Actual CPU freq
extern unsigned long gu32BusFreqKhz;                            //Actual BUS freq
extern unsigned long gu32FlashFreqKhz;                          //Actual Flash freq

/********************************************************************
*                             Functions
********************************************************************/
unsigned char u8PllInit(unsigned char u8PlloutOption, unsigned char u8OscSource, unsigned char u8ClkValue);
unsigned char u8McgPee2Blpi(unsigned char u8ClkValue);
unsigned char u8McgBlpi2Pee(unsigned char u8PlloutOption, unsigned char u8OscSource, unsigned char u8ClkValue);
unsigned char u8McgFee2Fei(unsigned char u8DrsVal, unsigned char u8Dmx32Val);
unsigned char u8McgFei2Fbe(unsigned char u8OscSource, unsigned char u8ClkValue);
unsigned char u8McgFei2Fbi (unsigned char u8IrcOption);
unsigned char u8McgFbe2Pbe(unsigned char u8PrdivVal, unsigned char u8VdivVal);
unsigned char u8McgPbe2Pee(unsigned char u8ClkValue);
unsigned char u8McgPee2Pbe(unsigned char u8ClkValue);
unsigned char u8McgPbe2Fbe (void);
unsigned char u8McgFbe2Fbi(unsigned char u8IrcOption);
unsigned char u8McgFbi2Blpi(void);
unsigned char u8McgPbe2Blpe (void);
unsigned char u8McgBlpe2Pbe (void);
void vfnUpdateClkFreq (void);
void vfnSetSysDividers(unsigned char u8Outdiv1, unsigned char u8Outdiv2, unsigned char u8Outdiv4);
int vfnFllFreq(int i32FllRef);

/********************************************************************/
#endif /* __MCG_H__ */
