/****************************************************************************************************/
/**
\file       adc.h
\brief      
\author     Freescale Semiconductor
\version    1.1
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef ADC_H_
#define ADC_H_

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"

#define ADC_CONFIGURATIONS_USED 	1

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
typedef enum
{
  ADC_EKG_SIGNAL,
//  ADC_EKG_BASELINE
}ADCConfigurations;

typedef enum
{
	x1,
	x2,
	x4,
	x8,
	x16,
	x32,
	x64
}tPGAPossibleGains;

typedef struct 
{
  uint16_t gu16LatestResult[4];
  uint8_t  gu8ActualConfig;
  uint8_t  gu8PrevConfig;
  uint8_t  gu8Status;
}tADCControl;

typedef struct 
{
	ADC_MemMapPtr	pADCBase;
	uint8_t  u8ClockResolutionLowpower;
	uint16_t u16HwCmpVrefTrgDMA;
	uint16_t u16CompareValue1;
	uint16_t u16CompareValue2;
	uint8_t  u8ChannelA;
	uint8_t  u8ChannelB; 
	uint8_t  u8HwAverage;
	uint8_t  u8LowPower;
}tADC;


/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern tADC sADC[ADC_CONFIGURATIONS_USED];
extern tADCControl sADCControl;
/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define ADC0		ADC0_BASE_PTR
#define ADC1		ADC1_BASE_PTR

#define ADC_CONVERT_CHANNEL(Index)		        ADC_SC1_REG(sADC[Index].pADCBase,0) =  ADC_SC1_AIEN_MASK | sADC[Index].u8ChannelA
#define ADC_CONVERT_CHANNEL_NO_INT(Index)	        ADC_SC1_REG(sADC[Index].pADCBase,0) =  sADC[Index].u8ChannelA
#define ADC_CONVERT_CONTINUOUS_CHANNEL(Index)	        ADC_SC3_REG(sADC[Index].pADCBase) |= ADC_SC3_ADCO_MASK;\
                                                        ADC_SC1_REG(sADC[Index].pADCBase,0) =  ADC_SC1_AIEN_MASK | sADC[Index].u8ChannelA
#define ADC_CONVERT_CONTINUOUS_CHANNEL_NO_INT(Index)	ADC_SC3_REG(sADC[Index].pADCBase) |= ADC_SC3_ADCO_MASK;\
                                                        ADC_SC1_REG(sADC[Index].pADCBase,0) =  sADC[Index].u8ChannelA
										

#define ADC0_COCO_EVENT		EVENT(sADCControl.gu8Status,0)
#define ADC0_COCO	        COMPARE(sADCControl.gu8Status,0)
#define ADC0_COCO_CLEAR		CLEAR(sADCControl.gu8Status,0)

#define ADC1_COCO_EVENT		EVENT(sADCControl.gu8Status,1)
#define ADC1_COCO		COMPARE(sADCControl.gu8Status,1)
#define ADC1_COCO_CLEAR		CLEAR(sADCControl.gu8Status,1)

/** ADC0 differential channels (144-pins)*/
#define ADC0_DIF0		ADC_SC1_ADCH(0)  | ADC_SC1_DIFF_MASK
#define ADC0_DIF1		ADC_SC1_ADCH(1)  | ADC_SC1_DIFF_MASK		
#define ADC0_PGA0		ADC_SC1_ADCH(2)  | ADC_SC1_DIFF_MASK
#define ADC0_DIF3		ADC_SC1_ADCH(3)  | ADC_SC1_DIFF_MASK	
#define ADC0_TEMP_DIF	ADC_SC1_ADCH(26) | ADC_SC1_DIFF_MASK
#define ADC0_BANDGAP_DIF	ADC_SC1_ADCH(27) | ADC_SC1_DIFF_MASK
#define ADC0_VREFH_DIF		ADC_SC1_ADCH(29) | ADC_SC1_DIFF_MASK
                                                  
/** ADC0 single ended channels (144-pins) */
#define ADC0_DP0_CH	        ADC_SC1_ADCH(0)
#define ADC0_DP1_CH	        ADC_SC1_ADCH(1)
#define ADC0_PGADP_CH	        ADC_SC1_ADCH(2)
#define ADC0_DP3_CH	        ADC_SC1_ADCH(3)
#define ADC0_CH4	        ADC_SC1_ADCH(4)
#define ADC0_CH5	        ADC_SC1_ADCH(5)
#define ADC0_CH6	        ADC_SC1_ADCH(6)
#define ADC0_CH7	        ADC_SC1_ADCH(7)
#define ADC0_CH8	        ADC_SC1_ADCH(8)
#define ADC0_CH9	        ADC_SC1_ADCH(9)
#define ADC0_CH10	        ADC_SC1_ADCH(10)
#define ADC0_CH11	        ADC_SC1_ADCH(11)
#define ADC0_CH12	        ADC_SC1_ADCH(12)
#define ADC0_CH13	        ADC_SC1_ADCH(13)
#define ADC0_CH14	        ADC_SC1_ADCH(14)
#define ADC0_CH15	        ADC_SC1_ADCH(15)
#define ADC0_CH16	        ADC_SC1_ADCH(16)
#define ADC0_DM0_CH	        ADC_SC1_ADCH(19)
#define ADC0_DM1_CH	        ADC_SC1_ADCH(20)
#define ADC0_OPAMP0_CH	        ADC_SC1_ADCH(21)
#define ADC0_OPAMP1_CH	        ADC_SC1_ADCH(22)
#define ADC0_DAC0_CH	        ADC_SC1_ADCH(23)
#define ADC0_TEMP_CH	        ADC_SC1_ADCH(26) 
#define ADC0_BGP_DIF	        ADC_SC1_ADCH(27) 
#define ADC0_VREFH_CH	        ADC_SC1_ADCH(29) 
#define ADC0_VREFL_CH	        ADC_SC1_ADCH(30)


/** ADC1 differential channels (144-pins)*/
#define ADC1_DIF0		ADC_SC1_ADCH(0)  | ADC_SC1_DIFF_MASK
#define ADC1_DIF1		ADC_SC1_ADCH(1)  | ADC_SC1_DIFF_MASK		
#define ADC1_PGA1		ADC_SC1_ADCH(2)  | ADC_SC1_DIFF_MASK
#define ADC1_DIF3		ADC_SC1_ADCH(3)  | ADC_SC1_DIFF_MASK	
#define ADC1_TEMP_DIF		ADC_SC1_ADCH(26) | ADC_SC1_DIFF_MASK
#define ADC1_BANDGAP_DIF	ADC_SC1_ADCH(27) | ADC_SC1_DIFF_MASK
#define ADC1_VREFH_DIF		ADC_SC1_ADCH(29) | ADC_SC1_DIFF_MASK
                                                  
/** ADC1 single ended channels (144-pins) */
#define ADC1_DP0_CH		ADC_SC1_ADCH(0)
#define ADC1_DP1_CH		ADC_SC1_ADCH(1)
#define ADC1_PGA_CH		ADC_SC1_ADCH(2)
#define ADC1_DP3_CH		ADC_SC1_ADCH(3)
#define ADC1_CH4		ADC_SC1_ADCH(4)
#define ADC1_CH5		ADC_SC1_ADCH(5)
#define ADC1_CH6		ADC_SC1_ADCH(6)
#define ADC1_CH7		ADC_SC1_ADCH(7)
#define ADC1_CH8		ADC_SC1_ADCH(8)
#define ADC1_CH9		ADC_SC1_ADCH(9)
#define ADC1_CH10		ADC_SC1_ADCH(10)
#define ADC1_CH11		ADC_SC1_ADCH(11)
#define ADC1_CH12		ADC_SC1_ADCH(12)
#define ADC1_CH13		ADC_SC1_ADCH(13)
#define ADC1_CH14		ADC_SC1_ADCH(14)
#define ADC1_CH15		ADC_SC1_ADCH(15)
#define ADC1_CH16		ADC_SC1_ADCH(16)
#define ADC1_CH1		ADC_SC1_ADCH(17)
#define ADC1_VREF_CH	        ADC_SC1_ADCH(18)
#define ADC1_DM0_CH		ADC_SC1_ADCH(19)
#define ADC1_DM1_CH		ADC_SC1_ADCH(20)
#define ADC1_TRIAMP1_CH         ADC_SC1_ADCH(22)
#define ADC1_DAC1_CH	        ADC_SC1_ADCH(23)
#define ADC1_TEMP_CH	        ADC_SC1_ADCH(26) 
#define ADC1_BGP_DIF	        ADC_SC1_ADCH(27) 
#define ADC1_VREFH_CH	        ADC_SC1_ADCH(29) 
#define ADC1_VREFL_CH	        ADC_SC1_ADCH(30) 


/** ADC low power */
#define ADC_NORMAL_MODE		0
#define ADC_LOWPOWER_MODE	ADC_CFG1_ADLPC_MASK
/** ADC clock source*/
#define ADCK_BUSCLCK		ADC_CFG1_ADICLK(0)
#define ADCK_BUSCLCK_DIVBY2	ADC_CFG1_ADICLK(1)
#define ADCK_ALTCLK		ADC_CFG1_ADICLK(2)
#define ADCK_ADACK		ADC_CFG1_ADICLK(3)
/** ADC clock divider */
#define	ADCK_DIV_BY_1		ADC_CFG1_ADIV(0)
#define	ADCK_DIV_BY_2		ADC_CFG1_ADIV(1)
#define	ADCK_DIV_BY_4		ADC_CFG1_ADIV(2)
#define	ADCK_DIV_BY_8		ADC_CFG1_ADIV(3)
/** Resolution */
#define _8B_RESOLUTION		0
#define _9B_RESOLUTION		0
#define _12B_RESOLUTION		ADC_CFG1_MODE(1)
#define _13B_RESOLUTION		ADC_CFG1_MODE(1)
#define _10B_RESOLUTION		ADC_CFG1_MODE(2)
#define _11B_RESOLUTION		ADC_CFG1_MODE(2)
#define _16B_RESOLUTION		ADC_CFG1_MODE(3)
/** Sample time */
#define SHORT_SAMPLE	0
#define LONG_SAMPLE		ADC_CFG1_ADLSMP_MASK


/** Hardware Compare */
#define ADC_LESS_THAN					ADC_SC2_ACFE_MASK
#define ADC_GREATER_THAN				ADC_SC2_ACFE_MASK | ADC_SC2_ACFGT_MASK
#define ADC_INSIDE_RANGE				ADC_SC2_ACFE_MASK | ADC_SC2_ACREN_MASK 			//NOTE: CV1 <= CV2
#define ADC_OUTSIDE_RANGE				ADC_SC2_ACFE_MASK | ADC_SC2_ACREN_MASK			//NOTE: CV1  > CV2
#define ADC_INSIDE_RANGE_INCLUSIVE		        ADC_SC2_ACFE_MASK | ADC_SC2_ACFGT_MASK | ADC_SC2_ACREN_MASK		//NOTE:  CV1 <= CV2
#define ADC_OUTSIDE_RANGE_INCLUSIVE		        ADC_SC2_ACFE_MASK | ADC_SC2_ACFGT_MASK | ADC_SC2_ACREN_MASK		//NOTE:  CV1  > CV2
/** ADC voltage reference */
#define ADC_EXTERNAL_VREFH	ADC_SC2_REFSEL(0) 
#define ADC_INTERNAL_VREFO	ADC_SC2_REFSEL(1)  		// Voltage reference module only reference when using PGA....
/** Conversion trigger select */
#define ADC_SW_TRIGGER		0
#define ADC_HW_TRIGGER		ADC_SC2_ADTRG_MASK
/** Enable or disable DMA */
#define ADC_DMA_ENABLE		ADC_SC2_DMAEN_MASK
#define ADC_DMA_DISABLE		0

/** Hardware average */
#define ADC_HW_AVG_4SAMPLES	ADC_SC3_AVGE_MASK
#define ADC_HW_AVG_8SAMPLES	ADC_SC3_AVGE_MASK | ADC_SC3_AVGS(1)
#define ADC_HW_AVG_16SAMPLES	ADC_SC3_AVGE_MASK | ADC_SC3_AVGS(2)
#define ADC_HW_AVG_32SAMPLES	ADC_SC3_AVGE_MASK | ADC_SC3_AVGS(3)





/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnADCInit (void);
void vfnADCConfigChannel (uint8_t u8Index);
void vfnADCPGAChangeGain (uint8_t u8Index, uint8_t u8Gain);
void vfnADCCal (uint8_t u8Index);
void vfnPollChannel(uint8_t u8Index);
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* ADC_H_ */

