/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file fsl_types.h
 *
 * @author  
 *
 * @version 0.0
 *
 * @date Apr-12-2013
 *
 * @brief Freescale types definitions
 *
 *****************************************************************************/
 #ifndef _FSL_TYPES_H_
 #define _FSL_TYPES_H_
 
/*
 * Misc. Defines
 */
#ifdef	FALSE
#undef	FALSE
#endif
#define FALSE	(0)

#ifdef	TRUE
#undef	TRUE
#endif
#define	TRUE	(1)

#ifdef	NULL
#undef	NULL
#endif
#define NULL	(0)

#ifdef  ON
#undef  ON
#endif
#define ON      (1)

#ifdef  OFF
#undef  OFF
#endif
#define OFF     (0)

/***********************************************************************
 * The basic data types
 **********************************************************************/
#if (!defined(_STDINT))  //This data types are included in code warrior and STDINT libraries by default
typedef unsigned char		uint8_t;  /*  8 bits */
typedef unsigned short	    uint16_t; /* 16 bits */
typedef unsigned long	    uint32_t; /* 32 bits */

typedef signed char			int8_t;   /*  8 bits */
typedef signed short        int16_t;  /* 16 bits */
typedef signed long			int32_t;  /* 32 bits */
#endif

typedef volatile int8_t		vint8_t;  /*  8 bits */
typedef volatile int16_t	vint16_t; /* 16 bits */
typedef volatile int32_t	vint32_t; /* 32 bits */

typedef volatile uint8_t	vuint8_t;  /*  8 bits */
typedef volatile uint16_t	vuint16_t; /* 16 bits */
typedef volatile unsigned long	vuint32_t; /* 32 bits */

typedef void (* pFunc_t) (void);


/***********************************************************************
 * Macros definitions for software flags 
 ***********************************************************************/
#define EVENT(gu8Status,bit)		gu8Status |= (1<<bit)
#define COMPARE(gu8Status,bit)		gu8Status & (1<<bit)
#define CLEAR(gu8Status,bit)		gu8Status &=  ~(1<<bit)

#endif
