/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file hr_analysis.h
 *
 * @author  
 *
 * @version 1.0
 *
 * @date Sep-09-2013
 *
 * @brief HR analysis functions
 * 
 *****************************************************************************/
#ifndef HR_ANALYSIS_H_
#define HR_ANALYSIS_H_

/*****************************************************************************
 * Header files
 ***************************************************************************/
#include "fsl_types.h"

/*****************************************************************************
 * User definitions
 ***************************************************************************/
//Timing
#define HR_SAMPLING_PERIOD_MS	10
#define HR_TIMEOUT_MS			3000

//Thresholds and limits
#define HR_THRESHOLD_HIGH		600
#define HR_THRESHOLD_LOW		-550

//HR average
#define HR_AVERAGE				5
/*****************************************************************************
 * Globals
 ****************************************************************************/
extern uint8_t gu8HrValue;

/*****************************************************************************
 * Type definitions
 ****************************************************************************/
typedef enum{
	HR_FIND_MAX,
	HR_FIND_MIN,
	HR_QRS_DETECTED
}HR_DETECTOR_STATES;

/*****************************************************************************
 * Function prototypes
 ****************************************************************************/
void vfnHrDetector (int16_t i16EcgSample);

#endif /* HR_ANALYSIS_H_ */
