/*
 *    kinetis_sysinit.c - Default init routines for P2
 *                     		Kinetis ARM systems
 *    Copyright  2012 Freescale semiConductor Inc. All Rights Reserved.
 */
 
#include "kinetis_sysinit.h"
#include "derivative.h"

/**
 **===========================================================================
 **  External declarations
 **===========================================================================
 */
#if __cplusplus
extern "C" {
#endif
extern uint32_t __vector_table[];
extern unsigned long _estack;
extern void __thumb_startup(void);
#if __cplusplus
}
#endif
extern void vfnLptTimerIsr (void);
extern void USB_ISR (void);


/**
 **===========================================================================
 **  Default interrupt handler
 **===========================================================================
 */
void Default_Handler()
{
	__asm("bkpt");
}

/**
 **===========================================================================
 **  Reset handler
 **===========================================================================
 */
void __init_hardware()
{
	SCB_VTOR = (uint32_t)__vector_table; /* Set the interrupt vector table position */
	/*
		Disable the Watchdog because it may reset the core before entering main().
		There are 2 unlock words which shall be provided in sequence before
		accessing the control register.
	*/
	WDOG_UNLOCK = KINETIS_WDOG_UNLOCK_SEQ_1;
	WDOG_UNLOCK = KINETIS_WDOG_UNLOCK_SEQ_2;
	WDOG_STCTRLH = KINETIS_WDOG_DISABLED_CTRL;
}

/* Weak definitions of handlers point to Default_Handler if not implemented */
void NMI_Handler() __attribute__ ((weak, alias("Default_Handler")));
void HardFault_Handler() __attribute__ ((weak, alias("Default_Handler")));
void MemManage_Handler() __attribute__ ((weak, alias("Default_Handler")));
void BusFault_Handler() __attribute__ ((weak, alias("Default_Handler")));
void UsageFault_Handler() __attribute__ ((weak, alias("Default_Handler")));
void SVC_Handler() __attribute__ ((weak, alias("Default_Handler")));
void DebugMonitor_Handler() __attribute__ ((weak, alias("Default_Handler")));
void PendSV_Handler() __attribute__ ((weak, alias("Default_Handler")));
void SysTick_Handler() __attribute__ ((weak, alias("Default_Handler")));


/* The Interrupt Vector Table */
void (* const InterruptVector[])() __attribute__ ((section(".vectortable"))) = {
    /* Processor exceptions */
    (void(*)(void)) &_estack,
    __thumb_startup,
    NMI_Handler, 
    HardFault_Handler, 
    MemManage_Handler, 
    BusFault_Handler,
    UsageFault_Handler, 
    0, 
    0, 
    0, 
    0, 
    SVC_Handler, 
    DebugMonitor_Handler, 
    0,
    PendSV_Handler, 
    SysTick_Handler,

    /* Interrupts */
    Default_Handler,				//Vector 16
    Default_Handler,				//Vector 17
    Default_Handler,				//Vector 18
    Default_Handler,				//Vector 19
    Default_Handler,				//Vector 20
    Default_Handler,				//Vector 21
    Default_Handler,				//Vector 22
    Default_Handler,				//Vector 23
    Default_Handler,				//Vector 24
    Default_Handler,				//Vector 25
    Default_Handler,				//Vector 26
    Default_Handler,				//Vector 27
    Default_Handler,				//Vector 28
    Default_Handler,				//Vector 29
    Default_Handler,				//Vector 30
    Default_Handler,				//Vector 31
    Default_Handler,				//Vector 32
    Default_Handler,				//Vector 33
    Default_Handler,				//Vector 34
    Default_Handler,				//Vector 35
    Default_Handler,				//Vector 36
    Default_Handler,				//Vector 37
    Default_Handler,				//Vector 38
    Default_Handler,				//Vector 39
    Default_Handler,				//Vector 40
    Default_Handler,				//Vector 41
    Default_Handler,				//Vector 42
    Default_Handler,				//Vector 43
    Default_Handler,				//Vector 44
    Default_Handler,				//Vector 45
    Default_Handler,				//Vector 46
    Default_Handler,				//Vector 47
    Default_Handler,				//Vector 48
    Default_Handler,				//Vector 49
    Default_Handler,				//Vector 50
    Default_Handler,				//Vector 51
    Default_Handler,				//Vector 52
    Default_Handler,				//Vector 53
    Default_Handler,				//Vector 54
    Default_Handler,				//Vector 55
    Default_Handler,				//Vector 56
    Default_Handler,				//Vector 57
    Default_Handler,				//Vector 58
    Default_Handler,				//Vector 59
    Default_Handler,				//Vector 60
    Default_Handler,				//Vector 61
    Default_Handler,				//Vector 62
    Default_Handler,				//Vector 63
    Default_Handler,				//Vector 64
    Default_Handler,				//Vector 65
    Default_Handler,				//Vector 66
    Default_Handler,				//Vector 67
    Default_Handler,				//Vector 68
    Default_Handler,				//Vector 69
    Default_Handler,				//Vector 70
    Default_Handler,				//Vector 71
    Default_Handler,				//Vector 72
    Default_Handler,				//Vector 73
    Default_Handler,				//Vector 74
    Default_Handler,				//Vector 75
    Default_Handler,				//Vector 76
    Default_Handler,				//Vector 77
    Default_Handler,				//Vector 78
    Default_Handler,				//Vector 79
    Default_Handler,				//Vector 80
    Default_Handler,				//Vector 81
    Default_Handler,				//Vector 82
    Default_Handler,				//Vector 83
    Default_Handler,				//Vector 84
    Default_Handler,				//Vector 85
    Default_Handler,				//Vector 86
    Default_Handler,				//Vector 87
    Default_Handler,				//Vector 88
    USB_ISR,						//Vector 89 USB
    Default_Handler,				//Vector 90
    Default_Handler,				//Vector 91
    Default_Handler,				//Vector 92
    Default_Handler,				//Vector 93
    Default_Handler,				//Vector 94
    Default_Handler,				//Vector 95
    Default_Handler,				//Vector 96
    Default_Handler,				//Vector 97
    Default_Handler,				//Vector 98
    Default_Handler,				//Vector 99
    Default_Handler,				//Vector 100
    vfnLptTimerIsr,					//Vector 101 LPTMR
    Default_Handler,				//Vector 102
    Default_Handler,				//Vector 103
    Default_Handler,				//Vector 104
    Default_Handler,				//Vector 105
    Default_Handler,				//Vector 106
    Default_Handler,				//Vector 107
    Default_Handler,				//Vector 108
    Default_Handler,				//Vector 109
    Default_Handler,				//Vector 110		
};
