/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************//*!
*
* @file triamp.h
*
* @author  
*
* @version 2.0
*
* @date Apr-19-2013
*
* @brief TRIAMP drivers for Kinetis
*
*****************************************************************************/

#ifndef _TRIAMP_H_
#define _TRIAMP_H_

/*******************************************************************************
* Header files
*******************************************************************************/
#include "derivative.h"

/*******************************************************************************
* User definitions
*******************************************************************************/
#define TRIAMP0                         TRIAMP0_BASE_PTR
#define TRIAMP1                         TRIAMP1_BASE_PTR

/* Power Modes*/
#define TRIAMP_LOW_POWER                1
#define TRIAMP_HIGH_SPEED               0

/*******************************************************************************
* Function prototypes
*******************************************************************************/
void vfnTriampInit (TRIAMP_MemMapPtr Module, unsigned char u8PowerMode);
void vfnTriampDeinit (TRIAMP_MemMapPtr Module);

#endif
