/*****************************************************************************
 * 
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
 * 
 * ALL RIGHTS RESERVED
 * 
 * ***************************************************************************
 * 
 * @file	nvic.h
 * 
 * @author	
 * 
 * @version	1.1.0
 * 
 * @date	Feb-21-2013
 * 
 * @brief	H header file for NVIC functions
 * 
 ******************************************************************************/

#ifndef _NVIC_H
#define _NVIC_H

/******************************************************************************
*                               Header files
******************************************************************************/
#include "derivative.h"

/*****
 * User definitions
 */
typedef enum{
	NVIC_OK,
	NVIC_ERR
}NVIC_ERROR_STATUS;

/******************************************************************************
*                            Function Prototypes
******************************************************************************/
unsigned char u8NvicEnableIrq(int irq);
unsigned char u8NvicDisableIrq(int irq);
unsigned char u8NvicSetIrqPriority(int irq, int prio);

#endif
//End of File
