/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file med_ekg.h
 *
 * @author  
 *
 * @version 1.0
 *
 * @date Sep-01-2013
 *
 * @brief ECG acquisition tasks using the MED-EKG board
 *
 *****************************************************************************/

#ifndef MED_EKG_H_
#define MED_EKG_H_

/*****************************************************************************
 * Header files
 ****************************************************************************/
#include "fsl_types.h"

/*****************************************************************************
 * User definitions
 ****************************************************************************/
#define EKG_TASK_TIME_MS	10

/*****************************************************************************
 * Globals
 ****************************************************************************/
extern uint8_t u8EcgTaskTimer;

/*****************************************************************************
 * Type definitions
 ****************************************************************************/
typedef enum{
	MED_EKG_OK,
	MED_EKG_ERR
}MED_EKG_STATUS;

/*****************************************************************************
 * Function prototypes
 ****************************************************************************/
uint8_t u8MedEkgInit (void);
void vfnMedEkgPeriodicTask (void);

#endif /* MED_EKG_H_ */
