/*
 * File:		io.c
 * Purpose:		Serial Input/Output routines
 *
 * Notes:       TERMINAL_PORT defined in <board>.h
 */

#include "derivative.h"
#include "usb_cdc.h"
#include "fsl_types.h"

extern uint8_t gu8USB_Flags;
extern uint8_t gu8EP3_OUT_ODD_Buffer[];
extern tBDT tBDTtable[];

/********************************************************************/
char
in_char (void)
{
  char i8ReturnValue;
  
  if(FLAG_CHK(EP_OUT,gu8USB_Flags))
  {
    (void)USB_EP_OUT_SizeCheck(EP_OUT);         
    usbEP_Reset(EP_OUT);
    usbSIE_CONTROL(EP_OUT);
    FLAG_CLR(EP_OUT,gu8USB_Flags);
  
    i8ReturnValue = *CDC_OUTPointer;
  }
  else
  {
    i8ReturnValue = 0;  //Return no-value
  }
  
  return i8ReturnValue;
}
/********************************************************************/
void
out_char (char ch)
{
  unsigned char u8Temp;
  unsigned int u32Time;
  
  u8Temp=ch;
  EP_IN_Transfer(EP2,&u8Temp,1);
  
  for(u32Time = 2000; u32Time != 0; u32Time--)//5000
  {
    //Time delay neccesary when sending one char at a time
  }
}
/********************************************************************/
int
char_present (void)
{
  return FLAG_CHK(EP_OUT,gu8USB_Flags);
}
/********************************************************************/
