/*******************************************************************************
*
*  FREESCALE SEMICONDUCTOR INC. 2004-2014
*  ALL RIGHTS RESERVED
*  COPYRIGHT (c)
*
********************************************************************************
*
*  FILE NAME:  etpuc_set.h
*
*  DESCRIPTION:
*     This file includes function prototypes for etpuc_set.c.
*
*******************************************************************************/
#ifndef _ETPUC_SET_H_
#define _ETPUC_SET_H_

/*******************************************************************************
*  Definitions
*******************************************************************************/
/* Global Error flags and masks */
#define GLOBAL_ERROR_CHANNEL_MASK    0x00FFU
#define GLOBAL_ERROR_EVENT_MASK      0xFF00U
#define GLOBAL_ERROR_EVENT_LSR       0x0100U
#define GLOBAL_ERROR_EVENT_MRLA      0x0200U
#define GLOBAL_ERROR_EVENT_MRLB      0x0400U
#define GLOBAL_ERROR_EVENT_TDLA      0x0800U
#define GLOBAL_ERROR_EVENT_TDLB      0x1000U
#define GLOBAL_ERROR_EVENT_PSS       0x2000U
#ifdef __ETPU2__
#define GLOBAL_ERROR_EVENT_FLAG0     0x4000U
#define GLOBAL_ERROR_EVENT_FLAG1     0x8000U
#endif

/*******************************************************************************
   Function Prototypes
*******************************************************************************/
void __attribute__((noreturn)) GlobalError(void);
void __attribute__((pure_assembly)) Link4(register_p uint32_t link_chans);


#endif /* _ETPUC_SET_H_ */
/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 *
 ********************************************************************/
/*******************************************************************************
*
*  REVISION HISTORY:
*
*  FILE OWNER: Milan Brejl [r54529]
*  Revision 1.0  2014/03/06  r54529
*  Minor comment and formating improvements. MISRA compliancy check.
*  Ready for release 1.0.
*
*  Revision 0.1  2011/05/15  r54529
*  Initial version.
*
*******************************************************************************/
