/*******************************************************************************
*
*  FREESCALE SEMICONDUCTOR INC. 2004-2014
*  ALL RIGHTS RESERVED
*  COPYRIGHT (c)
*
********************************************************************************
*
*  FILE NAME:  etpuc_set.c
*
*  DESCRIPTION:
*     This file includes general eTPU routines
*     and generates a function set image file.
*
*******************************************************************************/

/*******************************************************************************
*  Includes
*******************************************************************************/
#include "etpudef.h"       /* Defines eTPU hardware */
#include "etpuc_set.h"     /* Private header file */

/*******************************************************************************
*  Global Variables
*******************************************************************************/
uint24_t global_error = GLOBAL_ERROR_CHANNEL_MASK;

/*******************************************************************************
*  Global Functions
*******************************************************************************/
/*******************************************************************************
*  FUNCTION NAME: GlobalError
*  DESCRIPTION: This function is typically used to handle unexpected events
*    in eTPU(2) functions. The function stores the event entry conditions to
*    a global variable "global_error" and generates eTPU global exception 
*    interrupt request.
*******************************************************************************/
void __attribute__((noreturn)) GlobalError(void)
{
	uint24_t tmp;

	/* Put the active channel number to the lower byte */
	tmp = chan;
	
	/* Put the entry conditions to the middle byte */
	if(cc.LSR  == 1) { tmp |= GLOBAL_ERROR_EVENT_LSR; }
	if(cc.MRLA == 1) { tmp |= GLOBAL_ERROR_EVENT_MRLA; }
	if(cc.MRLB == 1) { tmp |= GLOBAL_ERROR_EVENT_MRLB; }
	if(cc.TDLA == 1) { tmp |= GLOBAL_ERROR_EVENT_TDLA; }
	if(cc.TDLB == 1) { tmp |= GLOBAL_ERROR_EVENT_TDLB; }
	if(cc.PSS  == 1) { tmp |= GLOBAL_ERROR_EVENT_PSS; }
#ifdef __ETPU2__
	if(cc.FLAG0 == 1) { tmp |= GLOBAL_ERROR_EVENT_FLAG0; }
	if(cc.FLAG1 == 1) { tmp |= GLOBAL_ERROR_EVENT_FLAG1; }
#endif
	
	/* Write global_error */
	global_error = tmp;

	/* Generate global exception */
	channel.CIRC = CIRC_GLOBAL_EXCEPTION;
	
	/* Clear all latches */
	channel.LSR  = LSR_CLEAR;
	channel.MRLA = MRL_CLEAR;
	channel.MRLB = MRL_CLEAR;
	channel.TDL  = TDL_CLEAR;
}

/*******************************************************************************
*  FUNCTION NAME: Link4
*  DESCRIPTION: This function can be used to send links to 4 channels. 
*    The channel numbers are packed into a single 32-bit argument, 
*    each byte of which includes one channel number. 
*******************************************************************************/
/* [MISRA 2004 Rule 2.1] Assembly language shall be encapsulated and isolated */
void __attribute__((pure_assembly)) Link4(register_p uint32_t link_chans)
{
	asm{.nonvolatile
		move link,p31_24
		move link,p23_16
		move link,p15_8
		rtn.d
		move link,p7_0
	}
}

/*******************************************************************************
*  Output eTPU code image and information for CPU 
*******************************************************************************/
/* [MISRA 2004 Rule 3.4] usage of #pragma write documented in 
   eTPU_Build_Tools_Reference.pdf, v.09/2013, chapter 26.13, p.309 */
#pragma write h, (::ETPUfilename (cpu/etpu_set.h));
#pragma write h, (/***************************************************************** );
#pragma write h, (* WARNING: This file is automatically generated. DO NOT EDIT IT! );
#pragma write h, (*);
#pragma write h, (* COPYRIGHT (c) Freescale 2004-2014, All Rights Reserved );
#pragma write h, (*);
#pragma write h, (* FILE NAME: etpu_set.h  );
#ifdef __ETPU2__
#pragma write h, (* ARCHITECTURE: eTPU2 );
#else
#pragma write h, (* ARCHITECTURE: eTPU );
#endif
#pragma write h, (*);
#pragma write h, (* This file was generated by: __FILE__ on __DATE__, __TIME__ );
#pragma write h, (*);
#pragma write h, (*****************************************************************/);
#pragma write h, (#ifndef _ETPU_SET_H_ );
#pragma write h, (#define _ETPU_SET_H_ );
#pragma write h, ();
#pragma write h, (/***************************************************************** );
#pragma write h, (* Function Set Definitions );
#pragma write h, (*****************************************************************/ );
#pragma write h, (#define FS_ETPU_ENTRY_TABLE 0x0000);
#pragma write h, (#define FS_ETPU_MISC ::ETPUmisc);
#ifdef __ETPU2__
#pragma write h, (#define FS_ETPU_ENGINE_MEM_SIZE  ::ETPUenginememsize );
#pragma write h, (#define FS_ETPU_ARCHITECTURE  ETPU2 );
#else
#pragma write h, (#define FS_ETPU_ARCHITECTURE  ETPU );
#endif
#pragma write h, ();
#pragma write h, (/***************************************************************** );
#pragma write h, (* Global Error Definitions );
#pragma write h, (*****************************************************************/ );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_CHANNEL_MASK) GLOBAL_ERROR_CHANNEL_MASK );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_MASK)   GLOBAL_ERROR_EVENT_MASK );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_LSR)    GLOBAL_ERROR_EVENT_LSR );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_MRLA)   GLOBAL_ERROR_EVENT_MRLA );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_MRLB)   GLOBAL_ERROR_EVENT_MRLB );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_TDLA)   GLOBAL_ERROR_EVENT_TDLA );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_TDLB)   GLOBAL_ERROR_EVENT_TDLB );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_PSS)    GLOBAL_ERROR_EVENT_PSS );
#ifdef __ETPU2__
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_FLAG0)  GLOBAL_ERROR_EVENT_FLAG0 );
#pragma write h, (::ETPUliteral(#define FS_ETPU_GLOBAL_ERROR_EVENT_FLAG1)  GLOBAL_ERROR_EVENT_FLAG1 );
#endif
#pragma write h, ();
#pragma write h, (::ETPUliteral(#define FS_ETPU_OFFSET_GLOBAL_ERROR) ::ETPUlocation(global_error) );
#pragma write h, ( );
#pragma write h, (/***************************************************************** );
#pragma write h, (* Initialization values of global variables );
#pragma write h, (*   On eTPU(2) initialization, this array must be copied );
#pragma write h, (*   into the eTPU DATA RAM from its start address. );
#pragma write h, (*****************************************************************/ );
#pragma write h, (const uint32_t etpu_globals[] = { );
#pragma write h, (::ETPUglobalimage32 );
#pragma write h, (};);
#pragma write h, ();
#pragma write h, (/***************************************************************** );
#pragma write h, (* Image of the compiled eTPU code binary );
#pragma write h, (*   On eTPU(2) initialization, this array must be copied );
#pragma write h, (*   into the eTPU CODE RAM. );
#pragma write h, (*****************************************************************/ );
#pragma write h, (const uint32_t etpu_code[] = { );
#pragma write h, (::ETPUcode32 );
#pragma write h, (};);
#pragma write h, ();
#pragma write h, (/***************************************************************** );
#pragma write h, (* List of eTPU functions included in this set );
#pragma write h, (****************************************************************** );
#pragma write h, (::ETPUnames);
#pragma write h, (*/);
#pragma write h, ();
#pragma write h, (#endif /* _ETPU_SET_H_ */ );
#pragma write h, ();


/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 *
 ********************************************************************/
/*******************************************************************************
*
*  REVISION HISTORY:
*
*  FILE OWNER: Milan Brejl [r54529]
*  Revision 1.0  2014/03/16  r54529
*  Minor comment and formating improvements. MISRA compliancy check.
*  Ready for release 1.0.
*
*  Revision 0.1  2011/05/15  r54529
*  Initial version.
*
*******************************************************************************/
